/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PolygonEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Polygon polygon;
    private int selected = -1;
    protected JScrollPane myScroll;
    private static final String DELETE = "Delete";
    private static final int POINT_RADIUS = 10;
    private static final int CLICK_THRESHOLD = 10;

    public PolygonEditor(Polygon p) {
        this.polygon = p;
    }

    protected void reset() {
        MouseMotionListener[] mml;
        MouseListener[] ml;
        for (MouseListener i : ml = this.getMouseListeners()) {
            this.removeMouseListener(i);
        }
        for (MouseMotionListener i : mml = this.getMouseMotionListeners()) {
            this.removeMouseMotionListener(i);
        }
        InputMap im = this.getInputMap(2);
        im.remove(KeyStroke.getKeyStroke(127, 0));
        im.remove(KeyStroke.getKeyStroke(27, 0));
        if (this.polygon == null || this.polygon.npoints == 0) {
            this.setupForCreate();
        } else {
            this.setupForEdit();
        }
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public Polygon clonePolygon() {
        return new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public void setScroll(JScrollPane scroll) {
        this.myScroll = scroll;
    }

    private void setupForCreate() {
        new DefineRectangle();
        this.requestFocus();
        this.repaint();
    }

    private void setupForEdit() {
        new ModifyPolygon();
        this.requestFocus();
        this.repaint();
    }

    public void center(Point p) {
        Rectangle r = this.getVisibleRect();
        if (r.width == 0) {
            r.width = 600;
            r.height = 600;
        }
        int x = p.x - r.width / 2;
        int y = p.y - r.height / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.scrollRectToVisible(new Rectangle(x, y, r.width, r.height));
    }

    public void scrollAtEdge(Point p, int dist) {
        p = new Point(p.x - this.myScroll.getViewport().getViewPosition().x, p.y - this.myScroll.getViewport().getViewPosition().y);
        int dx = 0;
        int dy = 0;
        if (p.x < dist && p.x >= 0) {
            dx = -1;
        }
        if (p.x >= this.myScroll.getViewport().getSize().width - dist && p.x < this.myScroll.getViewport().getSize().width) {
            dx = 1;
        }
        if (p.y < dist && p.y >= 0) {
            dy = -1;
        }
        if (p.y >= this.myScroll.getViewport().getSize().height - dist && p.y < this.myScroll.getViewport().getSize().height) {
            dy = 1;
        }
        if (dx != 0 || dy != 0) {
            Rectangle r = new Rectangle(this.myScroll.getViewport().getViewRect());
            r.translate(2 * dist * dx, 2 * dist * dy);
            r = r.intersection(new Rectangle(new Point(0, 0), this.getPreferredSize()));
            this.scrollRectToVisible(r);
        }
    }

    public static void reset(Polygon p, String pathStr) {
        p.reset();
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(pathStr, ';');
        while (sd.hasMoreTokens()) {
            String s = sd.nextToken();
            SequenceEncoder.Decoder pd = new SequenceEncoder.Decoder(s, ',');
            if (!pd.hasMoreTokens()) continue;
            try {
                int x = Integer.parseInt(pd.nextToken().trim());
                if (!pd.hasMoreTokens()) continue;
                int y = Integer.parseInt(pd.nextToken().trim());
                p.addPoint(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static String polygonToString(Polygon p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < p.npoints; ++i) {
            sb.append(Math.round(p.xpoints[i])).append(',').append(Math.round(p.ypoints[i]));
            if (i >= p.npoints - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public void paint(Graphics g) {
        this.paintBackground(g);
        if (this.polygon == null || this.polygon.npoints == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(SwingUtils.FONT_HINTS);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        int r = 10;
        int d = 20;
        g2d.setColor(Color.WHITE);
        g2d.fill(this.polygon);
        g2d.setColor(Color.BLACK);
        for (int i = 0; i < this.polygon.npoints; ++i) {
            int x = this.polygon.xpoints[i];
            int y = this.polygon.ypoints[i];
            g2d.drawOval(x - 10, y - 10, 20, 20);
        }
        if (this.selected >= 0 && this.selected < this.polygon.xpoints.length) {
            g2d.setColor(Color.RED);
            int x = this.polygon.xpoints[this.selected];
            int y = this.polygon.ypoints[this.selected];
            g2d.fillOval(x - 10, y - 10, 20, 20);
        }
        g2d.setComposite(AlphaComposite.SrcAtop);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawPolygon(this.polygon);
    }

    protected void paintBackground(Graphics g) {
        super.paint(g);
    }

    protected static Pair<Integer, Double> nearestVertex(Polygon p, int x, int y) {
        int idx = -1;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < p.npoints; ++i) {
            int x1 = p.xpoints[i];
            int y1 = p.ypoints[i];
            double d = Point2D.distance(x, y, x1, y1);
            if (!(d < minDist)) continue;
            minDist = d;
            idx = i;
        }
        return Pair.of((Object)idx, (Object)minDist);
    }

    protected static Triple<Integer, Point, Double> nearestSegment(Polygon p, int x, int y) {
        int idx = -1;
        int min_x = 0;
        int min_y = 0;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < p.npoints; ++i) {
            int y3;
            int x1;
            int j = (i + 1) % p.npoints;
            int x2 = p.xpoints[j];
            int px = x2 - x1;
            int y1 = p.ypoints[i];
            int y2 = p.ypoints[j];
            int py = y2 - y1;
            int norm = px * px + py * py;
            double u = (double)((x - (x1 = p.xpoints[i])) * px + (y - y1) * py) / (double)norm;
            u = u > 1.0 ? 1.0 : (u < 0.0 ? 0.0 : u);
            int x3 = (int)Math.round((double)x1 + u * (double)px);
            double d = Point2D.distance(x, y, x3, y3 = (int)Math.round((double)y1 + u * (double)py));
            if (!(d < minDist)) continue;
            minDist = d;
            min_x = x3;
            min_y = y3;
            idx = i;
        }
        return Triple.of((Object)idx, (Object)new Point(min_x, min_y), (Object)minDist);
    }

    protected static void deleteVertex(Polygon p, int i) {
        p.xpoints = ArrayUtils.remove((int[])p.xpoints, (int)i);
        p.ypoints = ArrayUtils.remove((int[])p.ypoints, (int)i);
        --p.npoints;
        p.invalidate();
    }

    protected static void insertVertex(Polygon p, int i, int x, int y) {
        p.xpoints = ArrayUtils.insert((int)i, (int[])p.xpoints, (int[])new int[]{x});
        p.ypoints = ArrayUtils.insert((int)i, (int[])p.ypoints, (int[])new int[]{y});
        ++p.npoints;
        p.invalidate();
    }

    protected static void moveVertex(Polygon p, int i, int x, int y) {
        p.xpoints[i] = x;
        p.ypoints[i] = y;
        p.invalidate();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.add(new PolygonEditor(null));
        f.setSize(500, 500);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }

    private class DefineRectangle
    extends MouseInputAdapter {
        public DefineRectangle() {
            PolygonEditor.this.addMouseListener(this);
        }

        private void remove() {
            PolygonEditor.this.removeMouseListener(this);
            PolygonEditor.this.removeMouseMotionListener(this);
        }

        private void resetPolygon(int x, int y, int n) {
            int[] xpoints = new int[n];
            Arrays.fill(xpoints, x);
            int[] ypoints = new int[n];
            Arrays.fill(ypoints, y);
            PolygonEditor.this.polygon = new Polygon(xpoints, ypoints, n);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (PolygonEditor.this.polygon == null || PolygonEditor.this.polygon.npoints == 0) {
                if (SwingUtils.isMainMouseButtonDown(e)) {
                    this.resetPolygon(e.getX(), e.getY(), 4);
                    PolygonEditor.this.addMouseMotionListener(this);
                    PolygonEditor.this.repaint();
                } else if (SwingUtils.isContextMouseButtonDown(e)) {
                    this.remove();
                    this.resetPolygon(e.getX(), e.getY(), 1);
                    PolygonEditor.this.selected = 0;
                    PolygonEditor.this.setupForEdit();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                PolygonEditor.this.polygon.xpoints[1] = PolygonEditor.this.polygon.xpoints[2] = e.getX();
                PolygonEditor.this.polygon.ypoints[2] = PolygonEditor.this.polygon.ypoints[3] = e.getY();
                PolygonEditor.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (PolygonEditor.this.polygon != null && PolygonEditor.this.polygon.npoints == 4 && SwingUtils.isMainMouseButtonDown(e)) {
                if (Math.abs(PolygonEditor.this.polygon.xpoints[0] - PolygonEditor.this.polygon.xpoints[2]) + Math.abs(PolygonEditor.this.polygon.ypoints[0] - PolygonEditor.this.polygon.ypoints[2]) < 20) {
                    PolygonEditor.this.polygon.xpoints[1] = PolygonEditor.this.polygon.xpoints[2] = PolygonEditor.this.polygon.xpoints[0] + 25;
                    PolygonEditor.this.polygon.ypoints[2] = PolygonEditor.this.polygon.ypoints[3] = PolygonEditor.this.polygon.ypoints[0] + 25;
                }
                this.remove();
                PolygonEditor.this.selected = (Integer)PolygonEditor.nearestVertex(PolygonEditor.this.polygon, e.getX(), e.getY()).getLeft();
                PolygonEditor.this.setupForEdit();
            }
        }
    }

    private class ModifyPolygon
    extends MouseInputAdapter {
        public ModifyPolygon() {
            PolygonEditor.this.addMouseListener(this);
            PolygonEditor.this.addMouseMotionListener(this);
            PolygonEditor.this.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), PolygonEditor.DELETE);
            PolygonEditor.this.getActionMap().put(PolygonEditor.DELETE, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModifyPolygon.this.deleteKeyPressed();
                }
            });
        }

        private void remove() {
            PolygonEditor.this.removeMouseListener(this);
            PolygonEditor.this.removeMouseMotionListener(this);
            PolygonEditor.this.getInputMap(2).remove(KeyStroke.getKeyStroke(127, 0));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                if (PolygonEditor.this.selected >= 0 && PolygonEditor.this.selected < PolygonEditor.this.polygon.xpoints.length) {
                    PolygonEditor.moveVertex(PolygonEditor.this.polygon, PolygonEditor.this.selected, e.getX(), e.getY());
                }
                PolygonEditor.this.scrollAtEdge(e.getPoint(), 15);
                PolygonEditor.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                Pair<Integer, Double> n = PolygonEditor.nearestVertex(PolygonEditor.this.polygon, e.getX(), e.getY());
                double d = (Double)n.getRight();
                PolygonEditor.this.selected = d <= 10.0 ? (Integer)n.getLeft() : -1;
                PolygonEditor.this.repaint();
            } else if (SwingUtils.isContextMouseButtonDown(e)) {
                int ins = (Integer)PolygonEditor.nearestSegment(PolygonEditor.this.polygon, e.getX(), e.getY()).getLeft() + 1;
                PolygonEditor.insertVertex(PolygonEditor.this.polygon, ins, e.getX(), e.getY());
                PolygonEditor.this.selected = ins;
                PolygonEditor.this.repaint();
            }
        }

        public void deleteKeyPressed() {
            if (PolygonEditor.this.selected >= 0) {
                PolygonEditor.deleteVertex(PolygonEditor.this.polygon, PolygonEditor.this.selected);
                PolygonEditor.this.selected = -1;
                if (PolygonEditor.this.polygon.npoints == 0) {
                    PolygonEditor.this.polygon = null;
                    this.remove();
                    PolygonEditor.this.setupForCreate();
                }
                PolygonEditor.this.repaint();
            }
        }
    }
}

