/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.tools.SequenceEncoder;

public class SortParameter {
    private String sortProperty = "";
    private boolean descendingSort = false;
    private boolean numericSort;

    public SortParameter() {
    }

    public SortParameter(String code) {
        this();
        this.decode(code);
    }

    public SortParameter(String property, boolean descending, boolean numeric) {
        this.setSortProperty(property);
        this.setDescendingSort(descending);
        this.setNumericSort(numeric);
    }

    public String encode() {
        SequenceEncoder se = new SequenceEncoder('|');
        se.append(this.getSortProperty()).append(this.isDescendingSort()).append(this.isNumericSort());
        return se.getValue();
    }

    public String toString() {
        return this.encode();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, '|');
        this.setSortProperty(sd.nextToken(""));
        this.setDescendingSort(sd.nextBoolean(false));
        this.setNumericSort(sd.nextBoolean(false));
    }

    public void setValue(SortParameter param) {
        this.setDescendingSort(param.isDescendingSort());
        this.setSortProperty(param.getSortProperty());
        this.setNumericSort(param.isNumericSort());
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String sortProperty) {
        this.sortProperty = sortProperty;
    }

    public boolean isDescendingSort() {
        return this.descendingSort;
    }

    public void setDescendingSort(boolean descendingSort) {
        this.descendingSort = descendingSort;
    }

    public boolean isNumericSort() {
        return this.numericSort;
    }

    public void setNumericSort(boolean numericSort) {
        this.numericSort = numericSort;
    }
}

