/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.build.module.map.deck.SortParameter;
import VASSAL.counters.GamePiece;
import java.util.Comparator;
import java.util.List;

public class SortParameterComparator
implements Comparator<GamePiece> {
    private final List<SortParameter> sortParameters;

    public SortParameterComparator(List<SortParameter> sortParameters) {
        this.sortParameters = sortParameters;
    }

    @Override
    public int compare(GamePiece piece1, GamePiece piece2) {
        boolean ascending;
        boolean bl = ascending = !this.sortParameters.get(0).isDescendingSort();
        if (piece2 == null) {
            return ascending ? -1 : 1;
        }
        for (SortParameter sp : this.sortParameters) {
            int result;
            String sortProperty = sp.getSortProperty();
            ascending = !sp.isDescendingSort();
            String property2 = (String)piece2.getProperty(sortProperty);
            if (property2 == null) {
                return ascending ? -1 : 1;
            }
            String property1 = (String)piece1.getProperty(sortProperty);
            if (property1 == null) {
                return ascending ? 1 : -1;
            }
            if (sp.isNumericSort()) {
                try {
                    Integer num1;
                    Integer num2 = Integer.parseInt(property2);
                    int result2 = num2.compareTo(num1 = Integer.valueOf(Integer.parseInt(property1)));
                    if (result2 == 0) continue;
                    return result2 * (ascending ? 1 : -1);
                }
                catch (NumberFormatException num2) {
                    // empty catch block
                }
            }
            if ((result = property2.compareTo(property1)) == 0) continue;
            return result * (ascending ? 1 : -1);
        }
        return 0;
    }
}

