/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DeckSelectionConfigurer
extends FormattedExpressionConfigurer {
    private final JButton select = new JButton(Resources.getString("Editor.select"));

    public DeckSelectionConfigurer(String s) {
        super(s);
        this.select.addActionListener(e -> this.showPopup());
    }

    public DeckSelectionConfigurer(String s, GamePiece p) {
        super(s, p);
        this.select.addActionListener(e -> this.showPopup());
    }

    public void showPopup() {
        JPopupMenu mapMenu = new JPopupMenu();
        for (Map m : GameModule.getGameModule().getAllDescendantComponentsOf(Map.class)) {
            JMenu deckMenu = new JMenu(m.getMapName());
            for (DrawPile d : m.getAllDescendantComponentsOf(DrawPile.class)) {
                JMenuItem item = new JMenuItem(d.getConfigureName());
                item.addActionListener(ev -> this.setValue(d.getConfigureName()));
                deckMenu.add(item);
            }
            if (deckMenu.getItemCount() <= 0) continue;
            mapMenu.add(deckMenu);
        }
        mapMenu.show(this.select, 0, 0);
    }

    @Override
    public Component getControls() {
        JPanel p = (JPanel)super.getControls();
        p.add((Component)this.select, "gapleft 2");
        return p;
    }
}

