/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TableConfigurer
extends Configurer
implements ActionListener {
    public static final String ADD_ACTION = Resources.getString("Editor.TableConfigurer.add");
    public static final String DEL_ACTION = Resources.getString("Editor.TableConfigurer.remove");
    public static final String INS_ACTION = Resources.getString("Editor.TableConfigurer.insert");
    protected Box controls;
    protected JPanel contents = null;
    protected Column[] columns = new Column[0];
    protected char rowDelimiter = (char)44;
    protected char colDelimiter = (char)124;

    public TableConfigurer(String key, String name, String[] headings, Class<?>[] types) {
        this(key, name);
        this.columns = new Column[headings.length];
        for (int i = 0; i < headings.length; ++i) {
            this.columns[i] = new Column(headings[i], types[i]);
        }
    }

    public TableConfigurer(String key, String name) {
        super(key, name);
    }

    @Override
    public String getValueString() {
        return null;
    }

    @Override
    public void setValue(String s) {
    }

    public void setRowDelimiter(char c) {
        this.rowDelimiter = c;
    }

    public void setColDelimiter(char c) {
        this.colDelimiter = c;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.buildControls();
        }
        return this.controls;
    }

    protected void buildControls() {
        this.controls = Box.createVerticalBox();
        this.controls.setBorder(BorderFactory.createEtchedBorder());
        this.controls.add(new JLabel(this.getName()));
        this.updateContents();
        Box buttonBox = Box.createHorizontalBox();
        JButton addButton = new JButton(ADD_ACTION);
        addButton.addActionListener(this);
        buttonBox.add(addButton);
        JButton delButton = new JButton(DEL_ACTION);
        delButton.addActionListener(this);
        buttonBox.add(delButton);
        JButton insButton = new JButton(INS_ACTION);
        insButton.addActionListener(this);
        buttonBox.add(insButton);
        this.controls.add(buttonBox);
        this.repack();
    }

    @Override
    protected void repack() {
        Window w = SwingUtilities.getWindowAncestor(this.controls);
        if (w != null) {
            w.pack();
        }
    }

    protected void updateContents() {
        if (this.contents != null) {
            this.controls.remove(this.contents);
            this.contents = null;
        }
        this.contents = new JPanel();
        this.contents.setBorder(BorderFactory.createEtchedBorder());
        this.contents.setLayout(new GridLayout(0, 5));
        for (Column item : this.columns) {
            this.contents.add(new JLabel(item.getName()));
        }
        if (this.columns[0].getRowCount() > 0) {
            for (int row = 0; row < this.columns[0].getRowCount(); ++row) {
                for (Column column : this.columns) {
                    this.contents.add(column.getControls(row));
                }
            }
        }
        this.controls.add(this.contents);
        this.repack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ADD_ACTION)) {
            Arrays.stream(this.columns).forEach(Column::addRow);
            this.updateContents();
        }
    }

    protected static class Column {
        protected Class<?> type;
        protected String name;
        protected List<Configurer> configurers = new ArrayList<Configurer>();
        protected Box controls;
        protected JPanel contents;

        public Column(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public Component getControls(int row) {
            if (row >= 0 && row < this.getRowCount()) {
                return this.configurers.get(row).getControls();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void addRow() {
            Configurer c = AutoConfigurer.createConfigurer(this.type, null, "", null);
            this.configurers.add(c);
        }

        public int getRowCount() {
            return this.configurers.size();
        }
    }
}

