/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class ColoredBorder
implements Highlighter {
    protected Color c;
    protected int thickness;
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();

    public ColoredBorder() {
        this(Color.black, 3);
    }

    public ColoredBorder(Color c, int thickness) {
        this.c = c;
        this.thickness = thickness;
    }

    public void addHighlighter(Highlighter h) {
        this.highlighters.add(h);
    }

    public void removeHighlighter(Highlighter h) {
        this.highlighters.remove(h);
    }

    @Override
    public void draw(GamePiece p, Graphics g, int x, int y, Component obs, double zoom) {
        if (this.thickness > 0) {
            if (this.c != null) {
                Shape s = p.getShape();
                Rectangle br = s.getBounds();
                if (!br.isEmpty()) {
                    double xzoom = (br.getWidth() + 1.0) / br.getWidth();
                    double yzoom = (br.getHeight() + 1.0) / br.getHeight();
                    AffineTransform t = AffineTransform.getTranslateInstance(x, y);
                    t.scale(xzoom * zoom, yzoom * zoom);
                    Graphics2D g2d = (Graphics2D)g;
                    Stroke str = g2d.getStroke();
                    g2d.setStroke(new BasicStroke(Math.max(1L, Math.round(zoom * (double)this.thickness))));
                    g2d.setColor(this.c);
                    g2d.draw(t.createTransformedShape(s));
                    g2d.setStroke(str);
                }
            } else {
                this.highlightSelectionBounds(p, g, x, y, obs, zoom);
            }
        }
        for (Highlighter h : this.highlighters) {
            h.draw(p, g, x, y, obs, zoom);
        }
    }

    protected void highlightSelectionBounds(GamePiece p, Graphics g, int x, int y, Component obs, double zoom) {
        Rectangle r = p.getShape().getBounds();
        g.setColor(this.c);
        for (int i = 1; i < this.thickness; ++i) {
            g.drawRect(x + (int)(zoom * (double)r.x) - i, y + (int)(zoom * (double)r.y) - i, (int)(zoom * (double)r.width) + 2 * i - 1, (int)(zoom * (double)r.height) + 2 * i - 1);
        }
    }

    @Override
    public Rectangle boundingBox(GamePiece p) {
        Rectangle r = p.getShape().getBounds();
        r.translate(-this.thickness, -this.thickness);
        r.setSize(r.width + 2 * this.thickness, r.height + 2 * this.thickness);
        for (Highlighter h : this.highlighters) {
            r.add(h.boundingBox(p));
        }
        return r;
    }

    public void setColor(Color c) {
        this.c = c;
    }

    public Color getColor() {
        return this.c;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }
}

