/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.ImagePicker;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class MultiImagePicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JList<String> imageList;
    protected DefaultListModel<String> imageListElements = new DefaultListModel();
    protected CardLayout cl = new CardLayout();
    protected JPanel multiPanel = new JPanel();

    public MultiImagePicker() {
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow][]", "[grow]"));
        this.imageList = new JList<String>(this.imageListElements);
        this.imageList.addListSelectionListener(e -> this.showSelected());
        this.imageList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    MultiImagePicker.this.showSelected();
                }
            }
        });
        this.imageList.setPrototypeCellValue("Image 999");
        this.imageList.setMinimumSize(this.imageList.getPreferredSize());
        this.multiPanel.setLayout(this.cl);
        this.add((Component)this.multiPanel, "grow");
        ScrollPane scroll = new ScrollPane(this.imageList);
        scroll.getViewport().setMinimumSize(this.imageList.getPreferredSize());
        this.add(scroll);
        this.addEntry();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.imageList.addListSelectionListener(l);
    }

    public void showSelected() {
        if (this.imageList.getSelectedValue() != null) {
            this.cl.show(this.multiPanel, this.imageList.getSelectedValue());
        }
    }

    public void addEntry() {
        String entry = Resources.getString("Editor.MultiImagePicker.image", this.imageListElements.size() + 1);
        this.imageListElements.addElement(entry);
        ImagePicker pick = new ImagePicker();
        this.multiPanel.add(entry, pick);
        this.imageList.setSelectedIndex(this.imageListElements.size() - 1);
        this.cl.show(this.multiPanel, this.imageList.getSelectedValue());
    }

    public JList<String> getList() {
        return this.imageList;
    }

    public List<String> getImageNameList() {
        int size = this.imageListElements.size();
        ArrayList<String> names = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            names.add(((ImagePicker)this.multiPanel.getComponent(i)).getImageName());
        }
        return names;
    }

    @Deprecated(since="2021-08-06", forRemoval=true)
    public Enumeration<String> getImageNames() {
        return Collections.enumeration(this.getImageNameList());
    }

    public void removeEntryAt(int index) {
        if (index < 0 || index >= this.imageListElements.size()) {
            return;
        }
        this.multiPanel.remove(index);
        this.imageListElements.removeElementAt(index);
        if (index < this.imageListElements.size()) {
            this.imageList.setSelectedIndex(index);
        } else if (index > 0) {
            this.imageList.setSelectedIndex(index - 1);
        }
        if (this.imageList.getSelectedValue() != null) {
            this.cl.show(this.multiPanel, this.imageList.getSelectedValue());
        }
    }

    public void clear() {
        for (int i = 0; i < this.imageListElements.size(); ++i) {
            ((ImagePicker)this.multiPanel.getComponent(i)).setImageName(null);
        }
        this.multiPanel.removeAll();
        this.imageListElements.removeAllElements();
    }

    public void swap(int index1, int index2) {
        int i;
        Component[] components = new Component[this.imageListElements.size()];
        for (i = 0; i < this.imageListElements.size(); ++i) {
            components[i] = this.multiPanel.getComponent(i);
        }
        this.multiPanel.removeAll();
        this.cl = new CardLayout();
        this.multiPanel.setLayout(this.cl);
        for (i = 0; i < this.imageListElements.size(); ++i) {
            Component c = i == index1 ? components[index2] : (i == index2 ? components[index1] : components[i]);
            this.multiPanel.add(c, Resources.getString("Editor.MultiImagePicker.image", i + 1));
        }
        this.imageList.setSelectedIndex(index2);
        this.showSelected();
    }

    public void setImageList(String[] names) {
        while (names.length > this.multiPanel.getComponentCount()) {
            this.addEntry();
        }
        IntStream.range(0, names.length).forEach(i -> ((ImagePicker)this.multiPanel.getComponent(i)).setImageName(names[i]));
    }
}

