/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.configure.IntConfigurer;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.MacOSXStartUp;
import VASSAL.launch.StartUp;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.concurrent.FutureUtils;
import VASSAL.tools.concurrent.SimpleRunnableFuture;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MenuManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);
    protected final LaunchRequest lr;
    private static Launcher instance = null;

    public static Launcher getInstance() {
        return instance;
    }

    protected Launcher(String[] args) {
        block16: {
            if (instance != null) {
                throw new IllegalStateException();
            }
            instance = this;
            LaunchRequest lreq = null;
            try {
                lreq = LaunchRequest.parseArgs(args);
            }
            catch (LaunchRequestException e) {
                System.err.println("VASSAL: " + e.getMessage());
                System.exit(1);
            }
            this.lr = lreq;
            StartUp start = SystemUtils.IS_OS_MAC ? new MacOSXStartUp() : new StartUp();
            start.startErrorLog();
            System.setErr(new PrintStream((OutputStream)new LoggedOutputStream(), true, Charset.defaultCharset()));
            logger.info(this.getClass().getSimpleName());
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
            start.initSystemProperties();
            this.createMenuManager();
            SimpleRunnableFuture fut = new SimpleRunnableFuture(){

                @Override
                public void run() {
                    try {
                        Launcher.this.launch();
                        this.set(null);
                    }
                    catch (Throwable t) {
                        this.setException(t);
                    }
                }
            };
            SwingUtilities.invokeLater(fut);
            try {
                fut.get();
            }
            catch (InterruptedException | CancellationException e) {
                FutureUtils.wait(ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.module_load_failed", e.getMessage()));
                System.exit(1);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof OutOfMemoryError) {
                    logger.error("Exiting: ", t);
                    FutureUtils.wait(ErrorDialog.show("Error.out_of_memory_reload", new Object[0]));
                    String gname = GameModule.getGameModule().getGameName();
                    try (Prefs p = new Prefs(Prefs.getGlobalPrefs().getEditor(), gname);){
                        IntConfigurer maxHeapConf = new IntConfigurer("maximumHeap", "", (Integer)512);
                        p.addOption(maxHeapConf);
                        Integer h = (Integer)p.getValue("maximumHeap");
                        if (h == null) {
                            h = 512;
                        }
                        p.setValue("maximumHeap", 2 * h);
                    }
                    catch (IOException ioe) {
                        logger.error("", (Throwable)ioe);
                    }
                    System.exit(2);
                }
                if (!(t instanceof ExtensionsLoader.LoadExtensionException) && !(t instanceof IOException)) break block16;
                FutureUtils.wait(ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.module_load_failed", e.getMessage()));
                System.exit(1);
            }
        }
    }

    protected abstract void launch() throws IOException;

    protected abstract MenuManager createMenuManager();
}

