/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.property;

import VASSAL.property.Property;
import VASSAL.property.PropertyContainer;
import VASSAL.property.PropertyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class SinglePropertyContainer<V>
implements PropertyContainer {
    protected final Property<V> prop;
    protected V value;
    protected final CopyOnWriteArrayList<PropertyListener<Object>> listeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<PropertyListener<? super V>> plisteners = new CopyOnWriteArrayList();

    public SinglePropertyContainer(Property<V> prop, V value) {
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.prop = prop;
        this.value = value;
    }

    @Override
    public Set<Property<?>> getProperties() {
        return Collections.singleton(this.prop);
    }

    @Override
    public <T> void setValue(Property<T> prop, T value) {
        if (!this.prop.equals(prop)) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (this.value.equals(value)) {
            return;
        }
        V oldVal = this.value;
        this.value = value;
        for (PropertyListener<Object> propertyListener : this.listeners) {
            propertyListener.propertyChanged(this, this.prop, oldVal, this.value);
        }
        for (PropertyListener<Object> propertyListener : this.plisteners) {
            propertyListener.propertyChanged(this, this.prop, oldVal, this.value);
        }
    }

    @Override
    public <T> T getValue(Property<T> prop) {
        if (!this.prop.equals(prop)) {
            throw new IllegalArgumentException();
        }
        return (T)this.value;
    }

    @Override
    public void addPropertyListener(PropertyListener<Object> l) {
        this.listeners.add(l);
    }

    @Override
    public <T> void addPropertyListener(Property<T> prop, PropertyListener<? super T> l) {
        if (!this.prop.equals(prop)) {
            throw new IllegalArgumentException();
        }
        this.plisteners.add(l);
    }

    @Override
    public void removePropertyListener(PropertyListener<Object> l) {
        this.listeners.remove(l);
    }

    @Override
    public <T> void removePropertyListener(Property<T> prop, PropertyListener<? super T> l) {
        if (!this.prop.equals(prop)) {
            throw new IllegalArgumentException();
        }
        this.plisteners.remove(l);
    }

    @Override
    public List<PropertyListener<Object>> getPropertyListeners() {
        return this.listeners.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyListener<Object>>(this.listeners);
    }

    @Override
    public <T> List<PropertyListener<? super T>> getPropertyListeners(Property<T> prop) {
        if (!this.prop.equals(prop)) {
            throw new IllegalArgumentException();
        }
        return this.plisteners.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyListener<V>>(this.plisteners);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public <T> boolean hasListeners(Property<T> prop) {
        if (!this.prop.equals(prop)) {
            throw new IllegalArgumentException();
        }
        return !this.plisteners.isEmpty();
    }
}

