/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent.listener;

import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.EventListenerSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultEventListenerSupport<T>
implements EventListenerSupport<T> {
    protected final List<EventListener<? super T>> listeners = new CopyOnWriteArrayList<EventListener<? super T>>();
    protected final Object src;

    public DefaultEventListenerSupport(Object src) {
        this.src = src;
    }

    @Override
    public void addEventListener(EventListener<? super T> l) {
        this.listeners.add(l);
    }

    @Override
    public void removeEventListener(EventListener<? super T> l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean hasEventListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public List<EventListener<? super T>> getEventListeners() {
        return new ArrayList<EventListener<? super T>>(this.listeners);
    }

    @Override
    public void notify(T event) {
        for (EventListener<T> l : this.listeners) {
            l.receive(this.src, event);
        }
    }
}

