/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.icon;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.swing.Dialogs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class IconFamily
extends AbstractConfigurable {
    public static final String SCALABLE_ICON = "scalableIcon";
    public static final String ICON0 = "icon0";
    public static final String ICON1 = "icon1";
    public static final String ICON2 = "icon2";
    public static final String ICON3 = "icon3";
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    public static final int XSMALL = 0;
    public static final int SMALL = 1;
    public static final int MEDIUM = 2;
    public static final int LARGE = 3;
    static final int MAX_SIZE = 3;
    static final int SIZE_COUNT = 4;
    static final int[] SIZES = new int[]{16, 22, 32, 48};
    static final String[] SIZE_DIRS = new String[]{"16x16/", "22x22/", "32x32/", "48x48/"};
    static final String[] SIZE_NAMES = new String[4];
    static final String SCALABLE_DIR = "scalable/";
    protected OpIcon[] icons;
    protected OpIcon scalableIcon;
    protected String scalablePath;
    protected String[] sizePaths = new String[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getIconSizeNames() {
        String[] stringArray = SIZE_NAMES;
        synchronized (SIZE_NAMES) {
            if (SIZE_NAMES[0] == null) {
                IconFamily.SIZE_NAMES[0] = Resources.getString("Icon.extra_small");
                IconFamily.SIZE_NAMES[1] = Resources.getString("Icon.small");
                IconFamily.SIZE_NAMES[2] = Resources.getString("Icon.medium");
                IconFamily.SIZE_NAMES[3] = Resources.getString("Icon.large");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SIZE_NAMES;
        }
    }

    public static int getIconSize(String name) {
        String[] options = IconFamily.getIconSizeNames();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(name)) continue;
            return i;
        }
        return 1;
    }

    public static int getIconHeight(int size) {
        if (size < 0 || size > 3) {
            return 0;
        }
        return SIZES[size];
    }

    public IconFamily(String familyName, String scalableName, String[] sizeName) {
        this(familyName);
        this.setScalableIconPath(scalableName);
        for (int i = 0; i < 3; ++i) {
            this.setSizeIconPath(i, sizeName[i]);
        }
    }

    public IconFamily(String familyName) {
        this();
        this.setConfigureName(familyName);
    }

    public IconFamily() {
        this.icons = new OpIcon[4];
        this.setConfigureName("");
    }

    public void setScalableIconPath(String s) {
        this.scalablePath = s;
        this.scalableIcon = null;
    }

    public void setSizeIconPath(int size, String path) {
        this.sizePaths[size] = path;
        this.icons[size] = null;
    }

    public boolean isLegacy() {
        return this.getName().contains(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(int size) {
        if (size < 0 || size > 3) {
            return null;
        }
        IconFamily iconFamily = this;
        synchronized (iconFamily) {
            if (this.icons[size] == null) {
                this.icons[size] = this.buildIcon(size);
            }
        }
        return this.icons[size];
    }

    public Icon getRawIcon(int size) {
        if (size < 0 || size > 3 || this.sizePaths[size] == null) {
            return null;
        }
        return this.getIcon(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getScalableIcon() {
        IconFamily iconFamily = this;
        synchronized (iconFamily) {
            this.buildScalableIcon();
        }
        return this.scalableIcon;
    }

    public BufferedImage getImage(int size) {
        if (size < 0 || size > 3) {
            return null;
        }
        this.getIcon(size);
        return (BufferedImage)(this.icons[size] == null ? null : this.icons[size].getImage());
    }

    protected OpIcon buildIcon(int size) {
        if (this.icons[size] != null) {
            return this.icons[size];
        }
        if (this.sizePaths[size] != null) {
            this.icons[size] = new OpIcon(Op.load(this.sizePaths[size]));
            this.icons[size].getImage();
            return this.icons[size];
        }
        this.buildScalableIcon();
        this.icons[size] = this.scaleIcon(this.scalableIcon, SIZES[size]);
        this.icons[size].getImage();
        return this.icons[size];
    }

    protected void buildScalableIcon() {
        if (this.scalableIcon == null && this.scalablePath != null) {
            this.scalableIcon = new OpIcon(Op.load(this.scalablePath));
        }
    }

    protected OpIcon scaleIcon(OpIcon base, int toSizePixels) {
        if (base == null) {
            return null;
        }
        int baseHeight = base.getIconHeight();
        if (baseHeight == toSizePixels) {
            return base;
        }
        return new OpIcon(Op.scale(base.getOp(), (double)toSizePixels / (double)base.getIconHeight()));
    }

    public String getName() {
        return this.getConfigureName();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    @Override
    public void setConfigureName(String s) {
        String oldName = this.name;
        this.name = s;
        this.propSupport.firePropertyChange("name", oldName, this.name);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.IconFamily.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", SCALABLE_ICON, ICON0, ICON1, ICON2, ICON3};
    }

    @Override
    public String getAttributeValueString(String key) {
        if ("name".equals(key)) {
            return this.getConfigureName();
        }
        if (SCALABLE_ICON.equals(key)) {
            return this.scalablePath;
        }
        if (ICON0.equals(key)) {
            return this.sizePaths[0];
        }
        if (ICON1.equals(key)) {
            return this.sizePaths[1];
        }
        if (ICON2.equals(key)) {
            return this.sizePaths[2];
        }
        if (ICON3.equals(key)) {
            return this.sizePaths[3];
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if ("name".equals(key)) {
            this.setConfigureName((String)value);
        } else if (SCALABLE_ICON.equals(key)) {
            this.setScalableIconPath((String)value);
        } else if (ICON0.equals(key)) {
            this.setSizeIconPath(0, (String)value);
        } else if (ICON1.equals(key)) {
            this.setSizeIconPath(1, (String)value);
        } else if (ICON2.equals(key)) {
            this.setSizeIconPath(2, (String)value);
        } else if (ICON3.equals(key)) {
            this.setSizeIconPath(3, (String)value);
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public void addTo(Buildable parent) {
    }

    @Override
    public Configurer getConfigurer() {
        return new IconFamilyConfig(this);
    }

    static class IconFamilyConfig
    extends Configurer {
        protected IconFamily family;
        protected JPanel controls;
        protected StringConfigurer title;
        protected JLabel errorLabel;
        protected ImageConfigurer scalableConfig;

        public IconFamilyConfig(IconFamily f) {
            super(null, null);
            this.family = f;
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            JPanel mig = new JPanel((LayoutManager)new MigLayout("inset 5"));
            this.title = new StringConfigurer(null, "", this.family.getConfigureName());
            this.title.addPropertyChangeListener(evt -> {
                if (evt.getNewValue() != null) {
                    this.family.setConfigureName((String)evt.getNewValue());
                }
            });
            mig.add(new JLabel(Resources.getString("Editor.IconFamily.family_name")));
            mig.add(this.title.getControls(), "wrap");
            this.errorLabel = new JLabel(Resources.getString("Editor.IconFamily.name_taken"));
            this.errorLabel.setForeground(Color.red);
            this.errorLabel.setVisible(false);
            this.family.addPropertyChangeListener(evt -> {
                if ("name".equals(evt.getPropertyName())) {
                    IconFamily savedFamily = IconFactory.getIconFamily(this.family.getName());
                    this.errorLabel.setVisible(savedFamily != null && savedFamily != this.family);
                }
            });
            mig.add((Component)this.errorLabel, "span 2,wrap");
            IconImageConfigurer scalableConfig = new IconImageConfigurer(this.family);
            mig.add(new JLabel(Resources.getString("Editor.IconFamily.scalable_icon_label")));
            mig.add(scalableConfig.getControls(), "wrap");
            IconImageConfigurer[] sizeConfig = new IconImageConfigurer[4];
            for (int size = 0; size < 4; ++size) {
                sizeConfig[size] = new IconImageConfigurer(this.family, size);
                String px = String.valueOf(SIZES[size]);
                mig.add(new JLabel(Resources.getString("Editor.IconFamily.icon_label", IconFamily.getIconSizeNames()[size], px)));
                mig.add(sizeConfig[size].getControls(), "wrap");
            }
            this.controls.add(mig);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
        }
    }

    static class FamilyImageFilter
    extends ImageFileFilter {
        private final String familyName;

        public FamilyImageFilter(String family) {
            this.familyName = family;
        }

        @Override
        public boolean accept(File f) {
            if (super.accept(f)) {
                String s = f.getName().split("\\.")[0];
                return s.equals(this.familyName);
            }
            return false;
        }
    }

    static class IconImageConfigurer
    extends Configurer {
        protected int size;
        protected JPanel controls;
        protected IconFamily family;
        protected int px;
        protected JLabel warningLabel;

        public IconImageConfigurer(IconFamily family, int size) {
            super(null, null);
            this.size = size;
            this.family = family;
            this.px = size < 0 ? SIZES[3] : SIZES[size];
        }

        public IconImageConfigurer(IconFamily family) {
            this(family, -1);
        }

        @Override
        public Component getControls() {
            if (this.controls == null) {
                this.controls = new JPanel((LayoutManager)new MigLayout());
                this.controls.add(new JLabel(this.getName()));
                JPanel p = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void paint(Graphics g) {
                        g.clearRect(0, 0, this.getSize().width, this.getSize().height);
                        Icon i = this.getIconValue();
                        if (i != null) {
                            i.paintIcon(this, g, this.getSize().width / 2 - i.getIconWidth() / 2, this.getSize().height / 2 - i.getIconHeight() / 2);
                        }
                    }
                };
                p.setPreferredSize(new Dimension(this.px, this.px));
                this.controls.add(p);
                JButton select = new JButton(Resources.getString("General.select"));
                select.addActionListener(e -> {
                    this.selectImage();
                    p.repaint();
                });
                this.controls.add((Component)select, "wrap");
                this.warningLabel = new JLabel();
                this.warningLabel.setForeground(Color.red);
                this.warningLabel.setVisible(false);
                this.checkIconSize();
                this.controls.add((Component)this.warningLabel, "span,wrap");
            }
            return this.controls;
        }

        @Override
        public String getValueString() {
            if (this.size < 0) {
                return this.family.scalablePath;
            }
            return this.family.sizePaths[this.size];
        }

        public Icon getIconValue() {
            Icon icon = null;
            if (this.family != null) {
                if (this.size < 0) {
                    if (this.family.scalablePath != null) {
                        icon = this.family.getScalableIcon();
                    }
                } else if (this.family.sizePaths[this.size] != null) {
                    icon = this.family.getIcon(this.size);
                }
            }
            return icon;
        }

        @Override
        public void setValue(String s) {
            if (this.size < 0) {
                this.family.setScalableIconPath(this.buildPath(s));
            } else {
                this.family.setSizeIconPath(this.size, this.buildPath(s));
                this.checkIconSize();
            }
        }

        protected void checkIconSize() {
            Icon check = this.family.getRawIcon(this.size);
            if (check != null && check.getIconHeight() != SIZES[this.size]) {
                this.setWarning(Resources.getString("Editor.IconFamily.size_warning", SIZES[this.size], check.getIconHeight()));
            }
        }

        protected String buildPath(String s) {
            if (s == null || s.length() == 0) {
                return null;
            }
            if (this.size < 0) {
                return "icons/scalable/" + s;
            }
            return "icons/" + SIZE_DIRS[this.size] + s;
        }

        protected void setWarning(String warning) {
            this.warningLabel.setText(warning);
            this.warningLabel.setVisible(warning != null && warning.length() > 0);
            this.repack();
        }

        @Override
        protected void repack() {
            Window w = SwingUtilities.getWindowAncestor(this.controls);
            if (w != null) {
                w.pack();
            }
        }

        protected void selectImage() {
            FileChooser fc = GameModule.getGameModule().getFileChooser();
            fc.setFileFilter(new FamilyImageFilter(this.family.getName()));
            fc.setSelectedFile(new File(this.family.getName() + ".*"));
            if (fc.showOpenDialog(this.getControls()) != 0) {
                this.setWarning("");
                this.setValue(null);
            } else {
                File f = fc.getSelectedFile();
                if (f != null && f.exists()) {
                    String name = f.getName();
                    if (name.split("\\.").length != 2) {
                        this.showError(Resources.getString("Editor.IconFamily.illegal_icon_name"));
                    } else if (!name.startsWith(this.family.getName())) {
                        this.showError(Resources.getString("Editor.IconFamily.bad_icon_name", this.family.getName()));
                    } else if (!ImageUtils.hasImageSuffix(name)) {
                        this.showError(Resources.getString("Editor.IconFamily.bad_icon_file"));
                    } else {
                        GameModule.getGameModule().getArchiveWriter().addImage(f.getPath(), this.buildPath(f.getName()));
                        this.setWarning("");
                        this.setValue(name);
                    }
                } else {
                    this.setWarning("");
                    this.setValue(null);
                }
            }
        }

        protected void showError(String message) {
            Dialogs.showMessageDialog(SwingUtilities.getWindowAncestor(this.controls), Resources.getString("Editor.IconFamily.icon_load_error"), Resources.getString("Editor.IconFamily.cannot_load_icon"), message, 0);
        }
    }
}

