/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.tilecache.TileUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class TilesToImage {
    public static void main(String[] args) throws IOException {
        System.setProperty("java.awt.headless", "true");
        String base = args[0];
        String scale = args[1];
        String dpath = args[2];
        Dimension d = TileUtils.size(base + "(0,0)@1:" + scale);
        int tw = d.width;
        int th = d.height;
        File bdir = new File(base).getParentFile();
        FileFilter filter = pathname -> pathname.getPath().startsWith(base);
        Pattern p = Pattern.compile(base + "\\((\\d+),(\\d+)\\)@1:");
        int max_row = 0;
        int max_col = 0;
        for (File f : bdir.listFiles(filter)) {
            Matcher m = p.matcher(f.getPath());
            if (!m.lookingAt()) continue;
            int c = Integer.parseInt(m.group(1));
            int r = Integer.parseInt(m.group(2));
            if (c > max_col) {
                max_col = c;
            }
            if (r <= max_row) continue;
            max_row = r;
        }
        int tcols = max_col + 1;
        int trows = max_row + 1;
        d = TileUtils.size(base + "(" + max_col + "," + max_row + ")@1:" + scale);
        int tw_last = d.width;
        int th_last = d.height;
        int w = tw * (tcols - 1) + tw_last;
        int h = th * (trows - 1) + th_last;
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = img.createGraphics();
        for (int tx = 0; tx < tcols; ++tx) {
            for (int ty = 0; ty < trows; ++ty) {
                File tfile = new File(base + "(" + tx + "," + ty + ")@1:" + scale);
                BufferedImage tile = TileUtils.read(tfile);
                g.drawImage((Image)tile, tx * tw, ty * th, null);
            }
        }
        ImageIO.write((RenderedImage)img, "PNG", Files.newOutputStream(Path.of(dpath, new String[0]), new OpenOption[0]));
    }
}

