/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SourceTileOpSVGImpl
extends AbstractTileOpImpl
implements SVGOp {
    private final SVGOp sop;
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int hash;

    public SourceTileOpSVGImpl(SVGOp sop, int tileX, int tileY) {
        if (sop == null) {
            throw new IllegalArgumentException();
        }
        if (tileX < 0 || tileX >= sop.getNumXTiles() || tileY < 0 || tileY >= sop.getNumYTiles()) {
            throw new IndexOutOfBoundsException();
        }
        this.sop = sop;
        int tw = sop.getTileWidth();
        int th = sop.getTileHeight();
        int sw = sop.getWidth();
        int sh = sop.getHeight();
        this.x0 = tileX * tw;
        this.y0 = tileY * th;
        this.x1 = Math.min((tileX + 1) * tw, sw);
        this.y1 = Math.min((tileY + 1) * th, sh);
        this.size = new Dimension(this.x1 - this.x0, this.y1 - this.y0);
        this.hash = new HashCodeBuilder().append((Object)sop).append(this.x0).append(this.y0).append(this.x1).append(this.y1).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        DataArchive archive = GameModule.getGameModule().getDataArchive();
        String name = this.getName();
        try {
            SVGRenderer renderer = new SVGRenderer(archive.getURL(name), (InputStream)new BufferedInputStream(archive.getInputStream(name)));
            Rectangle2D.Float aoi = new Rectangle2D.Float(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
            return renderer.render(0.0, 1.0, aoi);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new ImageNotFoundException(name, (Throwable)e);
        }
        catch (IOException e) {
            throw new ImageIOException(name, (Throwable)e);
        }
    }

    @Override
    protected void fixSize() {
    }

    @Override
    public String getName() {
        return this.sop.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SourceTileOpSVGImpl op = (SourceTileOpSVGImpl)o;
        return this.x0 == op.x0 && this.y0 == op.y0 && this.x1 == op.x1 && this.y1 == op.y1 && this.sop.equals(op.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

