/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.InputStreamPump;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessCallable
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessCallable.class);
    protected final Process proc;
    protected final InputStreamPump stdoutPump;
    protected final InputStreamPump stderrPump;
    protected final ExecutorService exec;

    public ProcessCallable(Process proc, InputStreamPump stdoutPump, InputStreamPump stderrPump, ExecutorService exec) {
        if (proc == null) {
            throw new IllegalArgumentException("proc == null");
        }
        if (stdoutPump == null) {
            throw new IllegalArgumentException("stdoutPump == null");
        }
        if (stderrPump == null) {
            throw new IllegalArgumentException("stderrPump == null");
        }
        if (exec == null) {
            throw new IllegalArgumentException("exec == null");
        }
        this.proc = proc;
        this.stdoutPump = stdoutPump;
        this.stderrPump = stderrPump;
        this.exec = exec;
    }

    @Override
    public Integer call() {
        this.stdoutPump.setInputStream(this.proc.getInputStream());
        this.stderrPump.setInputStream(this.proc.getErrorStream());
        Future<?> out_f = this.exec.submit(this.stdoutPump);
        Future<?> err_f = this.exec.submit(this.stderrPump);
        try {
            int result = this.proc.waitFor();
            this.stopPump(out_f);
            this.stopPump(err_f);
            this.closeStreams();
            return result;
        }
        catch (InterruptedException e) {
            out_f.cancel(true);
            err_f.cancel(true);
            this.closeStreams();
            this.proc.destroy();
            return -1;
        }
    }

    protected void stopPump(Future<?> f) {
        try {
            f.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error("", (Throwable)e);
            f.cancel(true);
        }
    }

    protected void closeStreams() {
        List.of(this.proc.getOutputStream(), this.proc.getErrorStream(), this.proc.getInputStream()).forEach(this::closeCloseable);
    }

    private void closeCloseable(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.error("Error while closing stream", (Throwable)e);
        }
    }
}

