/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.opcache;

import VASSAL.tools.opcache.Op;
import VASSAL.tools.opcache.OpCache;
import VASSAL.tools.opcache.OpObserver;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractOpImpl<V>
implements Op<V> {
    protected final OpCache cache;
    private static final ConcurrentMap<Op<?>, OpCache.Key<?>> kcache = new ConcurrentHashMap();

    public AbstractOpImpl(OpCache cache) {
        this.cache = cache;
    }

    @Override
    public abstract List<Op<?>> getSources();

    @Override
    public abstract V eval() throws Exception;

    public V get() {
        return this.cache.get(this.newKey());
    }

    public V get(OpObserver<V> obs) throws CancellationException, InterruptedException, ExecutionException {
        return this.cache.get(this.newKey(), obs);
    }

    public Future<V> getFuture(OpObserver<V> obs) throws ExecutionException {
        return this.cache.getFuture(this.newKey(), obs);
    }

    @Override
    public OpCache.Key<V> newKey() {
        OpCache.Key nkey;
        OpCache.Key key = (OpCache.Key)kcache.get(this);
        if (key == null && (key = kcache.putIfAbsent(this, nkey = new OpCache.Key(this, 0))) == null) {
            key = nkey;
        }
        return key;
    }

    @Override
    public void update() {
        OpCache.Key key = (OpCache.Key)kcache.get(this);
        if (key != null) {
            OpCache.Key nkey = new OpCache.Key(this, key.version + 1);
            kcache.replace(this, key, nkey);
        }
    }
}

