/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;
import org.litesoft.p2pchat.UserDialogPrivMsgAWT;

public class UserDialogAWT
extends Frame
implements UserDialog {
    private static final long serialVersionUID = 1L;
    private MyInfo zMyInfo;
    private ActivePeerManager zActivePeerManager = null;
    private TextField zChatText;
    private TextField zNameText;
    private TextArea zMessagesTextArea;
    private List zPeersList;
    private Hashtable zPrivateMessagersMap = new Hashtable();

    public UserDialogAWT(String pTitle, MyInfo pMyInfo) {
        super(pTitle);
        IllegalArgument.ifNull("Title", pTitle);
        this.zMyInfo = pMyInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.setLayout(new BorderLayout());
        this.add("North", this.layoutNamePanel());
        this.add("Center", this.layoutReceivedMessagesPanel());
        this.add("East", this.layoutWhoPanel());
        this.add("South", this.layoutChatEntryPanel());
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setVisible(true);
        this.showWho();
        this.zChatText.requestFocus();
    }

    @Override
    public void setActivePeerManager(ActivePeerManager pActivePeerManager) {
        if (pActivePeerManager != null) {
            this.zActivePeerManager = pActivePeerManager;
        }
    }

    @Override
    public void setPendingPeerManager(PendingPeerManager pPendingPeerManager) {
        if (pPendingPeerManager != null) {
            // empty if block
        }
    }

    private Panel layoutChatEntryPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", new Label("Message to Send:"));
        this.zChatText = new TextField();
        panel.add("Center", this.zChatText);
        this.zChatText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDialogAWT.this.handleCHAT(e.getActionCommand());
                UserDialogAWT.this.zChatText.setText("");
            }
        });
        return panel;
    }

    private Panel layoutReceivedMessagesPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Received Messages:"));
        this.zMessagesTextArea = new TextArea();
        panel.add("Center", this.zMessagesTextArea);
        this.zMessagesTextArea.setEnabled(true);
        this.zMessagesTextArea.setEditable(false);
        return panel;
    }

    private Panel layoutWhoPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Who's On:"));
        this.zPeersList = new List(25, false);
        panel.add("Center", this.zPeersList);
        this.zPeersList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lineRest = e.getActionCommand();
                int spaceAt = lineRest.indexOf(32);
                if (spaceAt != -1) {
                    UserDialogAWT.this.handlePrivateMessageWindowRequest(lineRest.substring(0, spaceAt));
                }
                UserDialogAWT.this.zChatText.requestFocus();
            }
        });
        return panel;
    }

    private Panel layoutNamePanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new Label("Name:", 2));
        this.zNameText = new TextField("", 15);
        panel.add(this.zNameText);
        this.zNameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDialogAWT.this.handleNAMEchange(e.getActionCommand().trim());
                UserDialogAWT.this.zNameText.setText("");
                UserDialogAWT.this.showWho();
                UserDialogAWT.this.zChatText.requestFocus();
            }
        });
        return panel;
    }

    private void send(String pMessage) {
        Object current = this.zMessagesTextArea.getText();
        current = (String)current + pMessage + "\n";
        this.zMessagesTextArea.setText((String)current);
    }

    private void showWho() {
        this.zPeersList.removeAll();
        this.zPeersList.add(this.zMyInfo.toString(), 0);
        PeerInfo[] peers = this.getPeerInfos();
        for (int i = 0; i < peers.length; ++i) {
            this.zPeersList.add(peers[i].toString(), i + 1);
        }
    }

    @Override
    public void showUnrecognized(PeerInfo pPeerInfo, String pBadMessage) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("BadMessage", pBadMessage);
        this.send("Unrecognized Command from (" + pPeerInfo.getID() + " " + pPeerInfo.getChatName() + "): " + pBadMessage);
    }

    @Override
    public void showStreamsFailed(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Unable to Set up I/O Streams with: " + pPeerInfo.toString());
    }

    @Override
    public void showConnectFailed(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Unable to Connect to: " + pPeerInfo.toString());
    }

    @Override
    public void showConnect(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.showWho();
    }

    @Override
    public void showDisconnect(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        UserDialogPrivMsgAWT subWindow = this.getPrivateMessageWindow(pPeerInfo);
        if (subWindow != null) {
            this.unregisterPrivateMessager(pPeerInfo);
            subWindow.dispose();
        }
        this.showWho();
    }

    @Override
    public void showCHAT(PeerInfo pPeerInfo, String pMessage) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("Message", pMessage);
        this.send(pPeerInfo.getID() + " " + pPeerInfo.getChatName() + ": " + pMessage);
    }

    @Override
    public void showPMSG(PeerInfo pPeerInfo, String pMessage) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("Message", pMessage);
        UserDialogPrivMsgAWT subWindow = this.getPrivateMessageWindow(pPeerInfo);
        if (subWindow != null) {
            subWindow.send(pPeerInfo.getChatName() + ": " + pMessage);
        } else {
            this.send("Private Message From (" + pPeerInfo.getID() + " " + pPeerInfo.getChatName() + "): " + pMessage);
        }
    }

    @Override
    public void showNAME(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.showWho();
    }

    @Override
    public void showHELO(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.showWho();
    }

    private UserDialogPrivMsgAWT getPrivateMessageWindow(PeerInfo pPeerInfo) {
        return (UserDialogPrivMsgAWT)this.zPrivateMessagersMap.get(pPeerInfo);
    }

    public void unregisterPrivateMessager(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.zPrivateMessagersMap.remove(pPeerInfo);
    }

    private void openPrivateMessageWindow(ActivePeer other) {
        this.zPrivateMessagersMap.put(other.getPeerInfo(), new UserDialogPrivMsgAWT(this, this.zMyInfo, other));
    }

    private void handleCHAT(String pLine) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zActivePeerManager.sendToAllCHAT(pLine);
            this.send(this.zMyInfo.getChatName() + ": " + pLine);
        }
    }

    private void handleNAMEchange(String newName) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zMyInfo.setChatName(newName);
            this.zActivePeerManager.sendToAllNAME();
        }
    }

    private PeerInfo[] getPeerInfos() {
        return this.zActivePeerManager != null ? this.zActivePeerManager.getPeerInfos() : new PeerInfo[]{};
    }

    private void handlePrivateMessageWindowRequest(String id) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            ActivePeer other = this.zActivePeerManager.getPeerListenerByID(id);
            if (other == null) {
                this.send("Unrecognized Peer ID: " + id);
            } else {
                this.openPrivateMessageWindow(other);
            }
        }
    }
}

