/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class UserDialogConsole
extends Thread
implements UserDialog {
    private MyInfo zMyInfo;
    private ActivePeerManager zActivePeerManager = null;
    private BufferedReader zReader;

    public UserDialogConsole(String pTitle, MyInfo pMyInfo) {
        IllegalArgument.ifNull("Title", pTitle);
        this.zMyInfo = pMyInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        System.out.println(pTitle);
        this.zReader = new BufferedReader(new InputStreamReader(System.in));
        this.start();
    }

    @Override
    public void setActivePeerManager(ActivePeerManager pActivePeerManager) {
        if (pActivePeerManager != null) {
            this.zActivePeerManager = pActivePeerManager;
        }
    }

    @Override
    public void setPendingPeerManager(PendingPeerManager pPendingPeerManager) {
        if (pPendingPeerManager != null) {
            // empty if block
        }
    }

    @Override
    public void run() {
        System.out.println("Listening At: " + this.zMyInfo.getAddresses() + ":" + this.zMyInfo.getPort());
        try {
            while (true) {
                this.processCommand(this.zReader.readLine());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void processCommand(String pLine) {
        String lineRest;
        int spaceAt;
        if ((pLine = pLine.trim()).length() == 0) {
            return;
        }
        if (pLine.equalsIgnoreCase("WHO")) {
            this.showWho();
            return;
        }
        if (pLine.toUpperCase().startsWith("I AM ") && pLine.length() > 5) {
            this.handleNAMEchange(pLine.substring(5).trim());
            this.send("Name Change from (" + this.zMyInfo.getPrevChatName() + ") to: " + this.zMyInfo.getChatName());
            return;
        }
        if (pLine.toUpperCase().startsWith("MSG ") && pLine.length() > 4 && (spaceAt = (lineRest = pLine.substring(4).trim()).indexOf(32)) != -1) {
            this.handlePrivateMessage(lineRest.substring(0, spaceAt), lineRest.substring(spaceAt + 1).trim());
            return;
        }
        this.handleCHAT(pLine);
    }

    private void send(String pMessage) {
        System.out.println(pMessage);
    }

    private void showWho() {
        this.send("Currently Connected:");
        this.send("  " + this.zMyInfo.toString());
        PeerInfo[] peers = this.getPeerInfos();
        for (int i = 0; i < peers.length; ++i) {
            this.send("  " + peers[i].toString());
        }
    }

    @Override
    public void showUnrecognized(PeerInfo pPeerInfo, String pBadMessage) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("BadMessage", pBadMessage);
        this.send("Unrecognized Command from (" + pPeerInfo.getID() + " " + pPeerInfo.getChatName() + "): " + pBadMessage);
    }

    @Override
    public void showStreamsFailed(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Unable to Set up I/O Streams with: " + pPeerInfo.toString());
    }

    @Override
    public void showConnectFailed(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Unable to Connect to: " + pPeerInfo.toString());
    }

    @Override
    public void showConnect(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Connection From: " + pPeerInfo.toString());
    }

    @Override
    public void showDisconnect(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Disconnect: " + pPeerInfo.getID() + " " + pPeerInfo.getChatName());
    }

    @Override
    public void showCHAT(PeerInfo pPeerInfo, String pMessage) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("Message", pMessage);
        this.send(pPeerInfo.getID() + " " + pPeerInfo.getChatName() + ": " + pMessage);
    }

    @Override
    public void showPMSG(PeerInfo pPeerInfo, String pMessage) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("Message", pMessage);
        this.send("Private Message From (" + pPeerInfo.getID() + " " + pPeerInfo.getChatName() + "): " + pMessage);
    }

    @Override
    public void showNAME(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("Name Change: " + pPeerInfo.toString());
    }

    @Override
    public void showHELO(PeerInfo pPeerInfo) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        this.send("HELO From: " + pPeerInfo.toString());
    }

    private void handleCHAT(String pLine) {
        IllegalArgument.ifNull("Line", pLine);
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zActivePeerManager.sendToAllCHAT(pLine);
            this.send(this.zMyInfo.getChatName() + ": " + pLine);
        }
    }

    private void handleNAMEchange(String pNewName) {
        IllegalArgument.ifNull("NewName", pNewName);
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zMyInfo.setChatName(pNewName);
            this.zActivePeerManager.sendToAllNAME();
        }
    }

    private PeerInfo[] getPeerInfos() {
        return this.zActivePeerManager != null ? this.zActivePeerManager.getPeerInfos() : new PeerInfo[]{};
    }

    private void handlePrivateMessage(String id, String msg) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            ActivePeer other = this.zActivePeerManager.getPeerListenerByID(id);
            if (other == null) {
                this.send("Unrecognized Peer ID: " + id);
            } else {
                other.sendPMSG(msg);
                this.send("Private Message sent to: " + other.getPeerInfo().toString());
            }
        }
    }
}

