import VASSAL
import VASSAL.build
import VASSAL.build.module.chessclockcontrol
import VASSAL.build.module.dice
import VASSAL.build.module.documentation
import VASSAL.build.module.folder
import VASSAL.build.module.gamepieceimage
import VASSAL.build.module.map
import VASSAL.build.module.map.boardPicker
import VASSAL.build.module.map.boardPicker.board
import VASSAL.build.module.map.boardPicker.board.mapgrid
import VASSAL.build.module.metadata
import VASSAL.build.module.noteswindow
import VASSAL.build.module.properties
import VASSAL.build.module.turn
import VASSAL.command
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import VASSAL.tools
import VASSAL.tools.io
import ch.qos.logback.classic.spi
import ch.qos.logback.core
import java.awt
import java.awt.dnd
import java.awt.event
import java.beans
import java.io
import java.lang
import java.util
import javax.swing
import javax.swing.event
import javax.swing.tree
import jpype.protocol
import org.netbeans.spi.wizard
import org.w3c.dom
import typing



class BasicCommandEncoder(VASSAL.command.CommandEncoder, VASSAL.build.Buildable):
    ADD: typing.ClassVar[str] = ...
    REMOVE: typing.ClassVar[str] = ...
    CHANGE: typing.ClassVar[str] = ...
    MOVE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def createDecorator(self, string: str, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.counters.Decorator: ...
    def createPiece(self, string: str) -> VASSAL.counters.GamePiece: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    class BasicPieceFactory:
        def createBasicPiece(self, string: str) -> VASSAL.counters.GamePiece: ...
    class DecoratorFactory:
        def createDecorator(self, string: str, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.counters.Decorator: ...

class ChartWindow(VASSAL.build.Widget):
    DEPRECATED_NAME: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getChildAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class Chatter(javax.swing.JPanel, VASSAL.command.CommandEncoder, VASSAL.build.Buildable):
    def __init__(self): ...
    @typing.overload
    def add(self, component: java.awt.Component) -> java.awt.Component: ...
    @typing.overload
    def add(self, component: java.awt.Component, int: int) -> java.awt.Component: ...
    @typing.overload
    def add(self, string: str, component: java.awt.Component) -> java.awt.Component: ...
    @typing.overload
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def add(self, popupMenu: java.awt.PopupMenu) -> None: ...
    @typing.overload
    def add(self, component: java.awt.Component, object: typing.Any) -> None: ...
    @typing.overload
    def add(self, component: java.awt.Component, object: typing.Any, int: int) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def consoleHook(self, string: str, string2: str, boolean: bool) -> bool: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    @staticmethod
    def getAnonymousUserName() -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getHandle(self) -> str: ...
    def getInputField(self) -> javax.swing.JTextField: ...
    def keyCommand(self, keyStroke: javax.swing.KeyStroke) -> None: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    @typing.overload
    def send(self, string: str) -> None: ...
    @typing.overload
    def send(self, string: str, string2: str) -> None: ...
    def setFont(self, font: java.awt.Font) -> None: ...
    @typing.overload
    def show(self, string: str) -> None: ...
    @typing.overload
    def show(self) -> None: ...
    @typing.overload
    def show(self, boolean: bool) -> None: ...
    @staticmethod
    def warning(string: str) -> None: ...
    class DisplayText(VASSAL.command.Command):
        PREFIX: typing.ClassVar[str] = ...
        def __init__(self, chatter: 'Chatter', string: str): ...
        def executeCommand(self) -> None: ...
        def getDetails(self) -> str: ...
        def getMessage(self) -> str: ...
        def myUndoCommand(self) -> VASSAL.command.Command: ...

class ConnectionWindow(VASSAL.build.AbstractBuildable):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class Console:
    def __init__(self): ...
    def consoleHook(self, string: str, string2: str, iterator: java.util.Iterator[str], string3: str) -> bool: ...

class ConsoleAppender(ch.qos.logback.core.AppenderBase[ch.qos.logback.classic.spi.ILoggingEvent]):
    def __init__(self): ...
    def start(self) -> None: ...

class DiceButton(VASSAL.build.AbstractToolbarItem):
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    DEPRECATED_NAME: typing.ClassVar[str] = ...
    N_DICE: typing.ClassVar[str] = ...
    N_SIDES: typing.ClassVar[str] = ...
    PLUS: typing.ClassVar[str] = ...
    ADD_TO_TOTAL: typing.ClassVar[str] = ...
    REPORT_TOTAL: typing.ClassVar[str] = ...
    PROMPT_ALWAYS: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    SORT_DICE_RESULTS: typing.ClassVar[str] = ...
    KEEP_DICE: typing.ClassVar[str] = ...
    KEEP_OPTION: typing.ClassVar[str] = ...
    KEEP_COUNT: typing.ClassVar[str] = ...
    RESULT: typing.ClassVar[str] = ...
    REPORT_NAME: typing.ClassVar[str] = ...
    RESULT_N: typing.ClassVar[str] = ...
    NUMERIC_TOTAL: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class KeepConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class DieManager(VASSAL.build.AbstractConfigurable):
    USE_INTERNET_DICE: typing.ClassVar[str] = ...
    DICE_SERVER: typing.ClassVar[str] = ...
    SERVER_PW: typing.ClassVar[str] = ...
    USE_EMAIL: typing.ClassVar[str] = ...
    PRIMARY_EMAIL: typing.ClassVar[str] = ...
    SECONDARY_EMAIL: typing.ClassVar[str] = ...
    ADDRESS_BOOK: typing.ClassVar[str] = ...
    MULTI_ROLL: typing.ClassVar[str] = ...
    DIE_MANAGER: typing.ClassVar[str] = ...
    DESC: typing.ClassVar[str] = ...
    DFLT_NSIDES: typing.ClassVar[str] = ...
    DFLT_NDICE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addDieButton(self, internetDiceButton: 'InternetDiceButton') -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDescriptions(self) -> typing.List[str]: ...
    def getDfltNDice(self) -> int: ...
    def getDfltNSides(self) -> int: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMultiRoll(self, int: int, int2: int) -> 'MultiRoll': ...
    def getNames(self) -> typing.List[str]: ...
    def getServer(self) -> VASSAL.build.module.dice.DieServer: ...
    def getServerDescription(self) -> str: ...
    def getServerForName(self, string: str) -> VASSAL.build.module.dice.DieServer: ...
    def getServerFromDescription(self, string: str) -> VASSAL.build.module.dice.DieServer: ...
    def getServerName(self) -> str: ...
    def removeDieButton(self, internetDiceButton: 'InternetDiceButton') -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def roll(self, int: int, int2: int, int3: int, boolean: bool, string: str, formattedString: VASSAL.tools.FormattedString) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setSecondaryEmail(self, string: str) -> None: ...
    def setSemailValues(self) -> None: ...

class DieRoll:
    @typing.overload
    def __init__(self, string: str, int: int, int2: int): ...
    @typing.overload
    def __init__(self, string: str, int: int, int2: int, int3: int): ...
    @typing.overload
    def __init__(self, string: str, int: int, int2: int, int3: int, boolean: bool): ...
    def getDescription(self) -> str: ...
    def getNumDice(self) -> int: ...
    def getNumSides(self) -> int: ...
    def getPlus(self) -> int: ...
    def getResult(self, int: int) -> int: ...
    def isReportTotal(self) -> bool: ...
    def setDescription(self, string: str) -> None: ...
    def setNumDice(self, int: int) -> None: ...
    def setNumSides(self, int: int) -> None: ...
    def setPlus(self, int: int) -> None: ...
    def setReportTotal(self, boolean: bool) -> None: ...
    def setResult(self, int: int, int2: int) -> None: ...

class DoActionButton(VASSAL.build.AbstractToolbarItem, VASSAL.tools.RecursionLimiter.Loopable):
    DO_REPORT: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    DO_SOUND: typing.ClassVar[str] = ...
    SOUND_CLIP: typing.ClassVar[str] = ...
    DO_HOTKEY: typing.ClassVar[str] = ...
    HOTKEYS: typing.ClassVar[str] = ...
    DO_LOOP: typing.ClassVar[str] = ...
    LOOP_TYPE: typing.ClassVar[str] = ...
    LOOP_COUNT: typing.ClassVar[str] = ...
    WHILE_EXPRESSION: typing.ClassVar[str] = ...
    UNTIL_EXPRESSION: typing.ClassVar[str] = ...
    PRE_LOOP_HOTKEY: typing.ClassVar[str] = ...
    POST_LOOP_HOTKEY: typing.ClassVar[str] = ...
    INDEX: typing.ClassVar[str] = ...
    INDEX_PROPERTY: typing.ClassVar[str] = ...
    INDEX_START: typing.ClassVar[str] = ...
    INDEX_STEP: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class HotkeyConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LoopConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LoopCountConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LoopTypeConfig(VASSAL.configure.StringEnumConfigurer):
        def __init__(self, string: str, string2: str, string3: str): ...
        @typing.overload
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        @typing.overload
        def getValidValues(self) -> typing.List[str]: ...
        def getValueString(self) -> str: ...
    class NamedHotkeyListConfigurer(VASSAL.configure.ListConfigurer):
        def __init__(self, string: str, string2: str, list: java.util.List[VASSAL.tools.NamedKeyStroke]): ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class SoundConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class Documentation(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    @staticmethod
    def getDocumentationBaseDir() -> java.io.File: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getHelpMenu(self) -> javax.swing.JMenu: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ExtensionElement(VASSAL.build.Buildable):
    TARGET: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, buildable: VASSAL.build.Buildable, configurableArray: typing.List[VASSAL.build.Configurable]): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getExtension(self) -> VASSAL.build.Buildable: ...
    def getTargetPath(self) -> typing.List[VASSAL.build.Configurable]: ...

class ExtensionsLoader(VASSAL.command.CommandEncoder):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    SPECIFY_DIR_IN_PREFS: typing.ClassVar[str] = ...
    EXTENSION_DIR: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, gameModule: VASSAL.build.GameModule) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    class LoadExtensionException(java.lang.RuntimeException):
        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, string: str): ...
        @typing.overload
        def __init__(self, string: str, throwable: java.lang.Throwable): ...
        @typing.overload
        def __init__(self, throwable: java.lang.Throwable): ...

class ExtensionsManager:
    @typing.overload
    def __init__(self, gameModule: VASSAL.build.GameModule): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, string: str): ...
    def getActiveExtensions(self) -> java.util.List[java.io.File]: ...
    def getExtensionsDirectory(self, boolean: bool) -> java.io.File: ...
    def getInactiveExtensions(self) -> java.util.List[java.io.File]: ...
    def getInactiveExtensionsDirectory(self, boolean: bool) -> java.io.File: ...
    def isExtensionActive(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    def setActive(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], boolean: bool) -> java.io.File: ...
    def setExtensionsDirectory(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...

class GameComponent:
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def setup(self, boolean: bool) -> None: ...

class GameSetupStep:
    def finish(self) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getStepTitle(self) -> str: ...
    def isFinished(self) -> bool: ...

class GameState(VASSAL.command.CommandEncoder):
    SAVEFILE_ZIP_ENTRY: typing.ClassVar[str] = ...
    BEGIN_SAVE: typing.ClassVar[str] = ...
    END_SAVE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addGameComponent(self, gameComponent: GameComponent) -> None: ...
    def addGameSetupStep(self, gameSetupStep: GameSetupStep) -> None: ...
    def addPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def addTo(self, gameModule: VASSAL.build.GameModule) -> None: ...
    def closeGame(self) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    @typing.overload
    def decodeSavedGame(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> VASSAL.command.Command: ...
    @typing.overload
    def decodeSavedGame(self, inputStream: java.io.InputStream) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllPieces(self) -> java.util.Collection[VASSAL.counters.GamePiece]: ...
    def getGameComponents(self) -> java.util.Collection[GameComponent]: ...
    def getNewPieceId(self) -> str: ...
    def getPieceForId(self, string: str) -> VASSAL.counters.GamePiece: ...
    def getPieces(self) -> java.util.Enumeration[VASSAL.counters.GamePiece]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getRestorePiecesCommand(self) -> VASSAL.command.Command: ...
    def getSavedGameDirectoryPreference(self) -> VASSAL.configure.DirectoryConfigurer: ...
    def getUnfinishedSetupSteps(self) -> java.util.Iterator[GameSetupStep]: ...
    def isGameStarted(self) -> bool: ...
    def isLoadingInBackground(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isSaveEnabled(self) -> bool: ...
    def isSaveMetaDataValid(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    def isUpdating(self) -> bool: ...
    def loadContinuation(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def loadGame(self) -> None: ...
    @typing.overload
    def loadGame(self, boolean: bool) -> None: ...
    @typing.overload
    def loadGameInBackground(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def loadGameInBackground(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def loadGameInForeground(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def loadGameInForeground(self, string: str, inputStream: java.io.InputStream) -> None: ...
    def removeGameComponent(self, gameComponent: GameComponent) -> None: ...
    def removeGameSetupStep(self, gameSetupStep: GameSetupStep) -> None: ...
    def removePiece(self, string: str) -> None: ...
    @typing.overload
    def saveGame(self) -> None: ...
    @typing.overload
    def saveGame(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    def saveGameAs(self) -> None: ...
    def saveGameRefresh(self, zipArchive: VASSAL.tools.io.ZipArchive) -> None: ...
    def setModified(self, boolean: bool) -> None: ...
    @typing.overload
    def setup(self, boolean: bool) -> None: ...
    @typing.overload
    def setup(self, boolean: bool, boolean2: bool) -> None: ...
    def setupRefresh(self) -> None: ...
    def updateDone(self) -> None: ...
    class SetupCommand(VASSAL.command.Command):
        def __init__(self, boolean: bool): ...
        def isGameStarting(self) -> bool: ...

class GlobalKeyCommand(VASSAL.build.module.map.MassKeyCommand):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, massKeyCommand: VASSAL.build.module.map.MassKeyCommand): ...
    def apply(self) -> None: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getGKCtype(self) -> VASSAL.counters.GlobalCommandTarget.GKCtype: ...

class GlobalOptions(VASSAL.build.AbstractConfigurable):
    NON_OWNER_UNMASKABLE: typing.ClassVar[str] = ...
    PROMPT_STRING: typing.ClassVar[str] = ...
    MARK_MOVED: typing.ClassVar[str] = ...
    AUTO_REPORT: typing.ClassVar[str] = ...
    CHATTER_HTML_SUPPORT: typing.ClassVar[str] = ...
    HOTKEYS_ON_CLOSED_WINDOWS: typing.ClassVar[str] = ...
    TRANSLATABLE_SUPPORT: typing.ClassVar[str] = ...
    ALWAYS: typing.ClassVar[str] = ...
    NEVER: typing.ClassVar[str] = ...
    PROMPT: typing.ClassVar[str] = ...
    CENTER_ON_MOVE: typing.ClassVar[str] = ...
    CENTER_ON_MOVE_SENSITIVITY: typing.ClassVar[str] = ...
    SINGLE_WINDOW: typing.ClassVar[str] = ...
    MAXIMUM_HEAP: typing.ClassVar[str] = ...
    DRAG_THRESHOLD: typing.ClassVar[str] = ...
    STACK_VIEWER_ORDER: typing.ClassVar[str] = ...
    BUG_10295: typing.ClassVar[str] = ...
    CLASSIC_MFD: typing.ClassVar[str] = ...
    MAC_LEGACY: typing.ClassVar[str] = ...
    OLD_CONTINUATION: typing.ClassVar[str] = ...
    SEND_TO_LOCATION_MOVEMENT_TRAILS: typing.ClassVar[str] = ...
    SOUND_GLOBAL_MUTE: typing.ClassVar[str] = ...
    SOUND_WAKEUP_MUTE: typing.ClassVar[str] = ...
    PLAYER_NAME: typing.ClassVar[str] = ...
    PLAYER_NAME_ALT: typing.ClassVar[str] = ...
    PLAYER_SIDE: typing.ClassVar[str] = ...
    PLAYER_SIDE_ALT: typing.ClassVar[str] = ...
    PLAYER_ID: typing.ClassVar[str] = ...
    PLAYER_ID_ALT: typing.ClassVar[str] = ...
    PLAYER_ID_FORMAT: typing.ClassVar[str] = ...
    FORCE_MAC_LEGACY: typing.ClassVar[bool] = ...
    INITIAL_HEAP: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addOption(self, configurer: VASSAL.configure.Configurer) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def autoReportEnabled(self) -> bool: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def centerOnOpponentsMove(self) -> bool: ...
    def centerOnOpponentsMoveSensitivity(self) -> float: ...
    def chatterHTMLSetting(self) -> str: ...
    def chatterHTMLSupport(self) -> bool: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getDragThreshold(self) -> int: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    @staticmethod
    def getInstance() -> 'GlobalOptions': ...
    def getPlayerId(self) -> str: ...
    def getPrefMacLegacy(self) -> bool: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def isForceNonNativeDrag(self) -> bool: ...
    def isHotKeysOnClosedWindows(self) -> bool: ...
    def isMarkMoveEnabled(self) -> bool: ...
    def isReverseStackViewerOrder(self) -> bool: ...
    def isSoundGlobalMute(self) -> bool: ...
    def isSoundWakeupMute(self) -> bool: ...
    def isUseClassicMoveFixedDistance(self) -> bool: ...
    def isUseSingleWindow(self) -> bool: ...
    def isWarnOldContinuation(self) -> bool: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setPrefMacLegacy(self, boolean: bool) -> None: ...
    def setSoundGlobalMute(self, boolean: bool) -> None: ...
    def setSoundWakeupMute(self, boolean: bool) -> None: ...
    def setUseClassicMoveFixedDistance(self, boolean: bool) -> None: ...
    def setWarnOldContinuation(self, boolean: bool) -> None: ...
    class PlayerIdFormatConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class Prompt(VASSAL.configure.StringEnum):
        def __init__(self): ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class PromptOnOff(VASSAL.configure.StringEnum):
        def __init__(self): ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class KeyNamer(VASSAL.build.Buildable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @staticmethod
    def getKeyString(keyStroke: javax.swing.KeyStroke) -> str: ...

class MultiRoll(javax.swing.JDialog, java.awt.event.ActionListener):
    COL_IDX: typing.ClassVar[int] = ...
    COL_ROLL: typing.ClassVar[int] = ...
    COL_DESC: typing.ClassVar[int] = ...
    COL_NDICE: typing.ClassVar[int] = ...
    COL_NSIDES: typing.ClassVar[int] = ...
    COL_ADD: typing.ClassVar[int] = ...
    COL_TOTAL: typing.ClassVar[int] = ...
    NUMCOLS: typing.ClassVar[int] = ...
    MAX_ROLLS: typing.ClassVar[int] = ...
    ROW_HEIGHT: typing.ClassVar[int] = ...
    COL1_WIDTH: typing.ClassVar[int] = ...
    COL2_WIDTH: typing.ClassVar[int] = ...
    COL3_WIDTH: typing.ClassVar[int] = ...
    COL4_WIDTH: typing.ClassVar[int] = ...
    COL5_WIDTH: typing.ClassVar[int] = ...
    COL6_WIDTH: typing.ClassVar[int] = ...
    COL7_WIDTH: typing.ClassVar[int] = ...
    def __init__(self, dieManager: DieManager, int: int, int2: int): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def getDescription(self) -> str: ...
    def getRollSet(self) -> VASSAL.build.module.dice.RollSet: ...
    def setDescription(self, string: str) -> None: ...
    def setVisible(self, boolean: bool) -> None: ...
    def wasCancelled(self) -> bool: ...

class PieceWindow(VASSAL.build.Widget, VASSAL.tools.UniqueIdManager.Identifyable):
    DEPRECATED_NAME: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    HIDDEN: typing.ClassVar[str] = ...
    SCALE: typing.ClassVar[str] = ...
    DEFAULT_DOCKED_WIDTH: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def dockMe(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getChildAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getScale(self) -> float: ...
    def hasScale(self) -> bool: ...
    def launchButtonPressed(self) -> None: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    def shouldDockIntoMainWindow(self) -> bool: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class PrototypeDefinition(VASSAL.build.AbstractConfigurable, VASSAL.tools.UniqueIdManager.Identifyable, VASSAL.configure.ValidityChecker):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def clearCache(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getDescription(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getId(self) -> str: ...
    @typing.overload
    def getPiece(self) -> VASSAL.counters.GamePiece: ...
    @typing.overload
    def getPiece(self, propertySource: VASSAL.build.module.properties.PropertySource) -> VASSAL.counters.GamePiece: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setConfigureName(self, string: str) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setId(self, string: str) -> None: ...
    def setPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...
    class Config(VASSAL.configure.Configurer):
        def __init__(self, prototypeDefinition: 'PrototypeDefinition'): ...
        def getControls(self) -> java.awt.Component: ...
        def getValue(self) -> typing.Any: ...
        def getValueString(self) -> str: ...
        @typing.overload
        def setValue(self, string: str) -> None: ...
        @typing.overload
        def setValue(self, object: typing.Any) -> None: ...
        class Definer(VASSAL.counters.PieceDefiner):
            def __init__(self, gpIdSupport: VASSAL.build.GpIdSupport): ...
            def setPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...

class PrototypesContainer(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addDefinition(self, prototypeDefinition: PrototypeDefinition) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    @staticmethod
    def findInstance() -> 'PrototypesContainer': ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getDefinitions(self) -> java.util.Collection[PrototypeDefinition]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    @staticmethod
    def getPrototype(string: str) -> PrototypeDefinition: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def resetCache(self) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ServerConnection:
    CONNECTED: typing.ClassVar[str] = ...
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def isConnected(self) -> bool: ...
    def sendToOthers(self, command: VASSAL.command.Command) -> None: ...
    def setConnected(self, boolean: bool) -> None: ...

class SpecialDiceButton(VASSAL.build.AbstractToolbarItem, VASSAL.command.CommandEncoder, VASSAL.tools.UniqueIdManager.Identifyable):
    SHOW_RESULTS_COMMAND: typing.ClassVar[str] = ...
    RESULT_CHATTER: typing.ClassVar[str] = ...
    CHAT_RESULT_FORMAT: typing.ClassVar[str] = ...
    RESULT_N: typing.ClassVar[str] = ...
    RESULT_TOTAL: typing.ClassVar[str] = ...
    RESULT_WINDOW: typing.ClassVar[str] = ...
    WINDOW_TITLE_RESULT_FORMAT: typing.ClassVar[str] = ...
    RESULT_BUTTON: typing.ClassVar[str] = ...
    WINDOW_X: typing.ClassVar[str] = ...
    WINDOW_Y: typing.ClassVar[str] = ...
    BACKGROUND_COLOR: typing.ClassVar[str] = ...
    DICE_SET: typing.ClassVar[str] = ...
    NONE: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addSpecialDie(self, specialDie: 'SpecialDie') -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getIdentifier(self) -> str: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    @staticmethod
    def intArrayToString(intArray: typing.List[int]) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeSpecialDie(self, specialDie: 'SpecialDie') -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    @staticmethod
    def stringToIntArray(string: str) -> typing.List[int]: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class ShowResults(VASSAL.command.Command):
        def __init__(self, specialDiceButton: 'SpecialDiceButton', intArray: typing.List[int]): ...

class SpecialDie(VASSAL.build.AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    FORMAT: typing.ClassVar[str] = ...
    RESULT: typing.ClassVar[str] = ...
    NUMERICAL_VALUE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addFace(self, specialDieFace: 'SpecialDieFace') -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFaceCount(self) -> int: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getImageName(self, int: int) -> str: ...
    def getIntValue(self, int: int) -> int: ...
    def getTextValue(self, int: int) -> str: ...
    def removeFace(self, specialDieFace: 'SpecialDieFace') -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class ResultFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class SpecialDieFace(VASSAL.build.AbstractConfigurable):
    TEXT: typing.ClassVar[str] = ...
    NUMERICAL_VALUE: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    IMAGE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getImageName(self) -> str: ...
    def getIntValue(self) -> int: ...
    def getTextValue(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class BasicLogger(VASSAL.command.Logger, VASSAL.build.Buildable, GameComponent, VASSAL.command.CommandEncoder):
    BEGIN: typing.ClassVar[str] = ...
    END: typing.ClassVar[str] = ...
    LOG: typing.ClassVar[str] = ...
    PROMPT_NEW_LOG: typing.ClassVar[str] = ...
    PROMPT_NEW_LOG_START: typing.ClassVar[str] = ...
    PROMPT_NEW_LOG_END: typing.ClassVar[str] = ...
    PROMPT_LOG_COMMENT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def enableDrawing(self, boolean: bool) -> None: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def hasMoreCommands(self) -> bool: ...
    def isLogging(self) -> bool: ...
    def isMultiPlayer(self) -> bool: ...
    def isReplaying(self) -> bool: ...
    def log(self, command: VASSAL.command.Command) -> None: ...
    def queryNewLogFile(self, boolean: bool) -> None: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setMultiPlayer(self, boolean: bool) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def write(self) -> None: ...
    class LogCommand(VASSAL.command.Command):
        def __init__(self, command: VASSAL.command.Command, list: java.util.List[VASSAL.command.Command], action: javax.swing.Action): ...
        def execute(self) -> None: ...
        def getLoggedCommand(self) -> VASSAL.command.Command: ...
    class StepAction(javax.swing.AbstractAction):
        def __init__(self, basicLogger: 'BasicLogger'): ...
        def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    class UndoAction(javax.swing.AbstractAction):
        def __init__(self, basicLogger: 'BasicLogger'): ...
        def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class ChessClockControl(VASSAL.build.AbstractConfigurable, VASSAL.command.CommandEncoder, GameComponent, VASSAL.tools.UniqueIdManager.Identifyable):
    DELIMITER: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    BUTTON_TOOLTIP: typing.ClassVar[str] = ...
    PAUSE_HOTKEY: typing.ClassVar[str] = ...
    NEXT_HOTKEY: typing.ClassVar[str] = ...
    SHOW_HOTKEY: typing.ClassVar[str] = ...
    SHOW_TENTHSECONDS: typing.ClassVar[str] = ...
    SHOW_SECONDS: typing.ClassVar[str] = ...
    SHOW_HOURS: typing.ClassVar[str] = ...
    SHOW_DAYS: typing.ClassVar[str] = ...
    ALLOW_RESET: typing.ClassVar[str] = ...
    STYLE_ALWAYS: typing.ClassVar[str] = ...
    STYLE_AUTO: typing.ClassVar[str] = ...
    STYLE_NEVER: typing.ClassVar[str] = ...
    CHESSMENU_PAUSE: typing.ClassVar[str] = ...
    CHESSMENU_SHOW: typing.ClassVar[str] = ...
    CHESSMENU_HIDE: typing.ClassVar[str] = ...
    CHESSMENU_NEXT: typing.ClassVar[str] = ...
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addChessClock(self, chessClock: VASSAL.build.module.chessclockcontrol.ChessClock) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getChessClocks(self) -> java.util.List[VASSAL.build.module.chessclockcontrol.ChessClock]: ...
    def getChessClocksVisible(self) -> bool: ...
    def getClocksTicking(self) -> int: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    @staticmethod
    def getInstance() -> 'ChessClockControl': ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getShowDays(self) -> str: ...
    def getShowHours(self) -> str: ...
    def getShowSeconds(self) -> str: ...
    def getShowTenths(self) -> str: ...
    def hideClocks(self) -> None: ...
    def isAllowReset(self) -> bool: ...
    def isInstanceIsActive(self) -> bool: ...
    def isOnline(self) -> bool: ...
    def pressControlButton(self) -> None: ...
    def removeChessClock(self, chessClock: VASSAL.build.module.chessclockcontrol.ChessClock) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    def setOnline(self, boolean: bool) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def showClocks(self) -> None: ...
    def startNextClock(self) -> VASSAL.command.Command: ...
    def stopAllClocks(self) -> VASSAL.command.Command: ...
    def updateAllClocks(self) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class TimeStyleConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class EventLog(VASSAL.build.AbstractBuildable, VASSAL.command.CommandEncoder, GameComponent):
    EVENT_LIST: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def clearSaved(self) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    @staticmethod
    def decodedEvents(string: str) -> java.lang.Iterable['EventLog.Event']: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    @staticmethod
    def encodedEvents(iterable: typing.Union[java.lang.Iterable['EventLog.Event'], typing.Sequence['EventLog.Event'], typing.Set['EventLog.Event']]) -> str: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def log(self, event: 'EventLog.Event') -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def store(self, event: 'EventLog.Event') -> None: ...
    class Event:
        def __init__(self, long: int, string: str, string2: str): ...
        def getAction(self) -> str: ...
        def getTime(self) -> int: ...
        def getUser(self) -> str: ...
    class StoreEvents(VASSAL.command.Command):
        def __init__(self, eventLog: 'EventLog', string: str): ...
        def executeCommand(self) -> None: ...
        def getEvents(self) -> str: ...
        def myUndoCommand(self) -> VASSAL.command.Command: ...

class GameRefresher(VASSAL.command.CommandEncoder, GameComponent):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    def __init__(self, gpIdSupport: VASSAL.build.GpIdSupport): ...
    def addTo(self, abstractConfigurable: VASSAL.build.AbstractConfigurable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def execute(self, set: java.util.Set[str], command: VASSAL.command.Command) -> None: ...
    def getCurrentGameRefresherPieces(self) -> java.util.List[VASSAL.counters.GamePiece]: ...
    def getRefreshAction(self) -> javax.swing.Action: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def isDeleteNoMap(self) -> bool: ...
    def isTestMode(self) -> bool: ...
    def log(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def start(self) -> None: ...

class InternetDiceButton(DiceButton, GameComponent, VASSAL.command.CommandEncoder):
    DETAILS: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class InternetReportFormatConfig(DiceButton.ReportFormatConfig):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class NewGameIndicator(GameComponent, VASSAL.command.CommandEncoder):
    def __init__(self, string: str): ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def isNewGame(self) -> bool: ...
    def setup(self, boolean: bool) -> None: ...
    class MarkGameNotNew(VASSAL.command.Command):
        def __init__(self, newGameIndicator: 'NewGameIndicator'): ...

class NotesWindow(VASSAL.build.AbstractToolbarItem, GameComponent, VASSAL.command.CommandEncoder):
    BUTTON_TEXT: typing.ClassVar[str] = ...
    HOT_KEY: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def cancel(self) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class ObscurableOptions(VASSAL.command.CommandEncoder, GameComponent):
    COMMAND_ID: typing.ClassVar[str] = ...
    PREFS_KEY: typing.ClassVar[str] = ...
    def __init__(self, string: str): ...
    def allow(self, string: str) -> None: ...
    def allowAll(self) -> None: ...
    def allowNone(self) -> None: ...
    def allowSome(self, string: str) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def decodeOptions(self, string: str) -> None: ...
    def disallow(self, string: str) -> None: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def encodeOptions(self) -> str: ...
    @staticmethod
    def getInstance() -> 'ObscurableOptions': ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def isUnmaskable(self, string: str) -> bool: ...
    def setPrompt(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class SetAllowed(VASSAL.command.Command):
        def __init__(self, list: java.util.List[str]): ...
        def getAllowedIds(self) -> java.util.List[str]: ...

class PlayerRoster(VASSAL.build.AbstractToolbarItem, VASSAL.command.CommandEncoder, GameComponent, GameSetupStep):
    BUTTON_ICON: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOL_TIP: typing.ClassVar[str] = ...
    BUTTON_KEYSTROKE: typing.ClassVar[str] = ...
    SIDES: typing.ClassVar[str] = ...
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    OBSERVER: typing.ClassVar[str] = ...
    SOLITAIRE: typing.ClassVar[str] = ...
    REFEREE: typing.ClassVar[str] = ...
    SOLO: typing.ClassVar[str] = ...
    MODERATOR: typing.ClassVar[str] = ...
    def __init__(self): ...
    @typing.overload
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def add(self, string: str, string2: str, string3: str) -> None: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addSideChangeListenerToInstance(self, sideChangeListener: typing.Union['PlayerRoster.SideChangeListener', typing.Callable]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def finish(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    @staticmethod
    def getMyLocalizedSide() -> str: ...
    @staticmethod
    def getMySide() -> str: ...
    def getPlayers(self) -> typing.List['PlayerRoster.PlayerInfo']: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getSides(self) -> java.util.List[str]: ...
    def getStepTitle(self) -> str: ...
    @staticmethod
    def isActive() -> bool: ...
    def isFinished(self) -> bool: ...
    def isMultiPlayer(self) -> bool: ...
    @staticmethod
    def isSoloSide(string: str) -> bool: ...
    @typing.overload
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def remove(self, string: str) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeSideChangeListenerFromInstance(self, sideChangeListener: typing.Union['PlayerRoster.SideChangeListener', typing.Callable]) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def translateSide(self, string: str) -> str: ...
    def untranslateSide(self, string: str) -> str: ...
    class Add(VASSAL.command.Command):
        def __init__(self, playerRoster: 'PlayerRoster', string: str, string2: str, string3: str): ...
    class PlayerInfo:
        playerId: str = ...
        playerName: str = ...
        def __init__(self, string: str, string2: str, string3: str): ...
        def equals(self, object: typing.Any) -> bool: ...
        def getLocalizedSide(self) -> str: ...
        def getSide(self) -> str: ...
        def hashCode(self) -> int: ...
    class SideChangeListener:
        def sideChanged(self, string: str, string2: str) -> None: ...

class PluginsLoader(ExtensionsLoader):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, gameModule: VASSAL.build.GameModule) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    @staticmethod
    def getPluginDirectory() -> str: ...
    class PluginElement: ...

class PredefinedSetup(VASSAL.build.AbstractConfigurable, GameComponent):
    NAME: typing.ClassVar[str] = ...
    FILE: typing.ClassVar[str] = ...
    USE_FILE: typing.ClassVar[str] = ...
    IS_MENU: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFileName(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getSavedGameContents(self) -> java.io.InputStream: ...
    def isMenu(self) -> bool: ...
    def isUseFile(self) -> bool: ...
    def launch(self) -> None: ...
    def refresh(self, set: java.util.Set[str]) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...

class RandomTextButton(DiceButton):
    FACES: typing.ClassVar[str] = ...
    NUMERIC: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class StartupGlobalKeyCommand(GlobalKeyCommand, GameComponent):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def setup(self, boolean: bool) -> None: ...

class ToolbarMenu(VASSAL.build.AbstractToolbarItem, java.awt.event.ContainerListener, java.beans.PropertyChangeListener, GameComponent):
    DESCRIPTION: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    BUTTON_ICON: typing.ClassVar[str] = ...
    BUTTON_HOTKEY: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    MENU_ITEMS: typing.ClassVar[str] = ...
    MENU_PROPERTY: typing.ClassVar[str] = ...
    MENU_ICON_PROPERTY: typing.ClassVar[str] = ...
    HIDDEN_BY_TOOLBAR: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def componentAdded(self, containerEvent: java.awt.event.ContainerEvent) -> None: ...
    def componentRemoved(self, containerEvent: java.awt.event.ContainerEvent) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def launch(self) -> None: ...
    def propertyChange(self, propertyChangeEvent: java.beans.PropertyChangeEvent) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...

class Inventory(VASSAL.build.AbstractToolbarItem, GameComponent, PlayerRoster.SideChangeListener):
    REFRESH_HOTKEY: typing.ClassVar[str] = ...
    VERSION: typing.ClassVar[str] = ...
    FILTER: typing.ClassVar[str] = ...
    GROUP_BY: typing.ClassVar[str] = ...
    NON_LEAF_FORMAT: typing.ClassVar[str] = ...
    CENTERONPIECE: typing.ClassVar[str] = ...
    FORWARD_KEYSTROKE: typing.ClassVar[str] = ...
    SHOW_MENU: typing.ClassVar[str] = ...
    SIDES: typing.ClassVar[str] = ...
    KEYSTROKE: typing.ClassVar[str] = ...
    CUTBELOWROOT: typing.ClassVar[str] = ...
    CUTABOVELEAVES: typing.ClassVar[str] = ...
    LEAF_FORMAT: typing.ClassVar[str] = ...
    PIECE_ZOOM: typing.ClassVar[str] = ...
    DRAW_PIECES: typing.ClassVar[str] = ...
    FOLDERS_ONLY: typing.ClassVar[str] = ...
    SORT_PIECES: typing.ClassVar[str] = ...
    SORT_FORMAT: typing.ClassVar[str] = ...
    ALPHA: typing.ClassVar[str] = ...
    LENGTHALPHA: typing.ClassVar[str] = ...
    NUMERIC: typing.ClassVar[str] = ...
    SORT_OPTIONS: typing.ClassVar[typing.List[str]] = ...
    LAUNCH_FUNCTION: typing.ClassVar[str] = ...
    FUNCTION_REFRESH: typing.ClassVar[str] = ...
    FUNCTION_HIDE: typing.ClassVar[str] = ...
    FUNCTION_OPTIONS: typing.ClassVar[typing.List[str]] = ...
    FUNCTION_KEYS: typing.ClassVar[typing.List[str]] = ...
    SORTING: typing.ClassVar[str] = ...
    BUTTON_FUNCTION: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getSelectedCounter(self) -> VASSAL.counters.GamePiece: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def sideChanged(self, string: str, string2: str) -> None: ...
    class Counter(VASSAL.build.module.properties.PropertySource):
        @typing.overload
        def __init__(self, inventory: 'Inventory', gamePiece: VASSAL.counters.GamePiece, list: java.util.List, int: int, string: str, string2: str): ...
        @typing.overload
        def __init__(self, inventory: 'Inventory', string: str): ...
        @typing.overload
        def __init__(self, inventory: 'Inventory', string: str, gamePiece: VASSAL.counters.GamePiece): ...
        def equals(self, object: typing.Any) -> bool: ...
        def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
        def getName(self) -> str: ...
        def getPath(self) -> typing.List[str]: ...
        def getPiece(self) -> VASSAL.counters.GamePiece: ...
        def getProperty(self, object: typing.Any) -> typing.Any: ...
        def getValue(self) -> int: ...
        def hashCode(self) -> int: ...
        def setNode(self, counterNode: 'Inventory.CounterNode') -> None: ...
        def setPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
        def setValue(self, int: int) -> None: ...
        def toSortKey(self) -> str: ...
        def toString(self) -> str: ...
    class CounterInventory(javax.swing.tree.TreeModel):
        def __init__(self, inventory: 'Inventory', counter: 'Inventory.Counter', list: java.util.List, boolean: bool): ...
        def addTreeModelListener(self, treeModelListener: javax.swing.event.TreeModelListener) -> None: ...
        def fireNodesRemoved(self, objectArray: typing.List[typing.Any], intArray: typing.List[int], objectArray2: typing.List[typing.Any]) -> None: ...
        def getChild(self, object: typing.Any, int: int) -> typing.Any: ...
        def getChildCount(self, object: typing.Any) -> int: ...
        def getIndexOfChild(self, object: typing.Any, object2: typing.Any) -> int: ...
        def getResultString(self) -> str: ...
        def getResultStringArray(self) -> typing.List[str]: ...
        def getRoot(self) -> typing.Any: ...
        def insert(self, counter: 'Inventory.Counter') -> None: ...
        def isLeaf(self, object: typing.Any) -> bool: ...
        def removeTreeModelListener(self, treeModelListener: javax.swing.event.TreeModelListener) -> None: ...
        def valueForPathChanged(self, treePath: javax.swing.tree.TreePath, object: typing.Any) -> None: ...
    class CounterNode(java.lang.Comparable['Inventory.CounterNode']):
        def __init__(self, inventory: 'Inventory', string: str, counter: 'Inventory.Counter', int: int): ...
        @typing.overload
        def addChild(self, counterNode: 'Inventory.CounterNode', boolean: bool) -> None: ...
        @typing.overload
        def addChild(self, int: int, counterNode: 'Inventory.CounterNode', boolean: bool) -> None: ...
        def compareTo(self, counterNode: 'Inventory.CounterNode') -> int: ...
        def cutLeaves(self) -> None: ...
        def cutLevel(self, int: int) -> None: ...
        def getChild(self, int: int) -> typing.Any: ...
        def getChildCount(self) -> int: ...
        def getCounter(self) -> 'Inventory.Counter': ...
        def getEntry(self) -> str: ...
        def getIndexOfChild(self, object: typing.Any) -> int: ...
        def getLevel(self) -> int: ...
        def isLeaf(self) -> bool: ...
        def iterator(self) -> java.util.Iterator['Inventory.CounterNode']: ...
        def removeChild(self, counterNode: 'Inventory.CounterNode') -> None: ...
        def setLevel(self, int: int) -> None: ...
        def toResultString(self) -> str: ...
        def toString(self) -> str: ...
        def updateValues(self) -> int: ...
    class FunctionConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class HotKeySender(java.awt.event.KeyListener):
        def __init__(self, inventory: 'Inventory'): ...
        def keyCommand(self, keyStroke: javax.swing.KeyStroke) -> None: ...
        def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
        def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
        def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class PieceFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class SortConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class ModuleExtension(VASSAL.build.AbstractBuildable, GameComponent, PluginsLoader.PluginElement, VASSAL.build.GpIdSupport):
    BASE_MODULE_NAME: typing.ClassVar[str] = ...
    BASE_MODULE_VERSION: typing.ClassVar[str] = ...
    VERSION: typing.ClassVar[str] = ...
    VASSAL_VERSION_CREATED: typing.ClassVar[str] = ...
    UNIVERSAL: typing.ClassVar[str] = ...
    NEXT_PIECESLOT_ID: typing.ClassVar[str] = ...
    EXTENSION_ID: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    def __init__(self, dataArchive: VASSAL.tools.DataArchive): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def build(self, element: org.w3c.dom.Element) -> None: ...
    @typing.overload
    def build(self) -> None: ...
    def buildString(self) -> str: ...
    def confirmExit(self) -> bool: ...
    def generateGpId(self) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getDataArchive(self) -> VASSAL.tools.DataArchive: ...
    def getDescription(self) -> str: ...
    def getEditAction(self, jDialog: javax.swing.JDialog) -> javax.swing.Action: ...
    def getExtensionId(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getName(self) -> str: ...
    def getNextGpId(self) -> int: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getUniversal(self) -> bool: ...
    def getVersion(self) -> str: ...
    def remove(self, extensionElement: ExtensionElement) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def save(self) -> None: ...
    def saveAs(self) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setNextGpId(self, int: int) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class RegCmd(VASSAL.command.Command):
        def __init__(self, string: str, string2: str): ...
        def getName(self) -> str: ...
        def getVersion(self) -> str: ...

class MultiActionButton(ToolbarMenu, VASSAL.tools.RecursionLimiter.Loopable):
    def __init__(self): ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def launch(self) -> None: ...

class Plugin(VASSAL.build.AbstractConfigurable, PluginsLoader.PluginElement):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def init(self) -> None: ...
    def registerCommandEncoder(self, commandEncoder: VASSAL.command.CommandEncoder) -> None: ...
    def registerComponent(self, class_: typing.Type[VASSAL.build.Buildable], class2: typing.Type[VASSAL.build.Buildable]) -> None: ...
    def registerGamePiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ModulePlugin(ModuleExtension):
    def __init__(self, dataArchive: VASSAL.tools.DataArchive): ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    class RegCmd(ModuleExtension.RegCmd):
        def __init__(self, string: str, string2: str): ...

class PlayerHand(VASSAL.build.module.PrivateMap):
    def __init__(self): ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getStackMetrics(self) -> VASSAL.build.module.map.StackMetrics: ...
    def mapSize(self) -> java.awt.Dimension: ...

class PrivateMap(VASSAL.build.module.Map):
    VISIBLE: typing.ClassVar[str] = ...
    SIDE: typing.ClassVar[str] = ...
    USE_BOARDS: typing.ClassVar[str] = ...
    def __init__(self): ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getView(self) -> javax.swing.JComponent: ...
    def isAccessibleTo(self, string: str) -> bool: ...
    def isVisibleTo(self, string: str) -> bool: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setBoards(self, collection: typing.Union[java.util.Collection[VASSAL.build.module.map.boardPicker.Board], typing.Sequence[VASSAL.build.module.map.boardPicker.Board], typing.Set[VASSAL.build.module.map.boardPicker.Board]]) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def shouldDockIntoMainWindow(self) -> bool: ...
    def sideChanged(self, string: str, string2: str) -> None: ...
    class View(VASSAL.build.module.Map.View):
        def __init__(self, privateMap: 'PrivateMap'): ...
        def addKeyListener(self, keyListener: java.awt.event.KeyListener) -> None: ...
        def addMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
        def addMouseMotionListener(self, mouseMotionListener: java.awt.event.MouseMotionListener) -> None: ...
        def setDropTarget(self, dropTarget: java.awt.dnd.DropTarget) -> None: ...

class WizardSupport:
    POST_INITIAL_STEPS_WIZARD: typing.ClassVar[str] = ...
    POST_LOAD_GAME_WIZARD: typing.ClassVar[str] = ...
    POST_PLAY_OFFLINE_WIZARD: typing.ClassVar[str] = ...
    WELCOME_WIZARD_KEY: typing.ClassVar[str] = ...
    SETUP_KEY: typing.ClassVar[str] = ...
    ACTION_KEY: typing.ClassVar[str] = ...
    LOAD_TUTORIAL_ACTION: typing.ClassVar[str] = ...
    PLAY_ONLINE_ACTION: typing.ClassVar[str] = ...
    PLAY_OFFLINE_ACTION: typing.ClassVar[str] = ...
    LOAD_GAME_ACTION: typing.ClassVar[str] = ...
    WELCOME_WIZARD_ENABLED: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addPredefinedSetup(self, predefinedSetup: PredefinedSetup) -> None: ...
    def createInitialWelcomeSteps(self) -> 'WizardSupport.InitialWelcomeSteps': ...
    def createPlayOfflinePanels(self) -> org.netbeans.spi.wizard.WizardPanelProvider: ...
    def removePredefinedSetup(self, predefinedSetup: PredefinedSetup) -> None: ...
    def setBackgroundImage(self, image: java.awt.Image) -> None: ...
    def setTutorial(self, tutorial: VASSAL.build.module.documentation.Tutorial) -> None: ...
    def showGameSetupWizard(self) -> None: ...
    def showWelcomeWizard(self) -> None: ...
    class BranchingWizard(org.netbeans.spi.wizard.WizardBranchController):
        def __init__(self, wizardPanelProvider: org.netbeans.spi.wizard.WizardPanelProvider, string: str): ...
    class GameSetupPanels(org.netbeans.spi.wizard.WizardPanelProvider, org.netbeans.spi.wizard.WizardPage.WizardResultProducer):
        def cancel(self, map: typing.Union[java.util.Map, typing.Mapping]) -> bool: ...
        def finish(self, map: typing.Union[java.util.Map, typing.Mapping]) -> typing.Any: ...
        @staticmethod
        def newInstance() -> 'WizardSupport.GameSetupPanels': ...
        def newWizard(self, dimension: java.awt.Dimension) -> org.netbeans.spi.wizard.Wizard: ...
    class InitialWelcomeSteps(org.netbeans.spi.wizard.WizardPanelProvider):
        NAME_STEP: typing.ClassVar[str] = ...
        def __init__(self, wizardSupport: 'WizardSupport', stringArray: typing.List[str], stringArray2: typing.List[str]): ...
        def setTutorial(self, tutorial: VASSAL.build.module.documentation.Tutorial) -> None: ...
    class LoadSavedGamePanels(org.netbeans.spi.wizard.WizardPanelProvider):
        def __init__(self): ...
    class PlayOfflinePanels(org.netbeans.spi.wizard.WizardPanelProvider): ...
    class SavedGameLoader(java.lang.Thread):
        @typing.overload
        def __init__(self, wizardController: org.netbeans.spi.wizard.WizardController, map: typing.Union[java.util.Map[str, typing.Any], typing.Mapping[str, typing.Any]], inputStream: java.io.InputStream, string: str): ...
        @typing.overload
        def __init__(self, wizardController: org.netbeans.spi.wizard.WizardController, map: typing.Union[java.util.Map[str, typing.Any], typing.Mapping[str, typing.Any]], inputStream: java.io.InputStream, string: str, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
        def run(self) -> None: ...
    class SetupStepPage(org.netbeans.spi.wizard.WizardPage):
        def __init__(self, gameSetupStep: GameSetupStep): ...
    class TutorialLoader(VASSAL.build.module.WizardSupport.SavedGameLoader):
        def __init__(self, wizardController: org.netbeans.spi.wizard.WizardController, map: typing.Union[java.util.Map[str, typing.Any], typing.Mapping[str, typing.Any]], inputStream: java.io.InputStream, string: str, tutorial: VASSAL.build.module.documentation.Tutorial): ...

class Map(VASSAL.build.AbstractToolbarItem, GameComponent, java.awt.event.MouseListener, java.awt.event.MouseMotionListener, java.awt.dnd.DropTargetListener, VASSAL.build.Configurable, VASSAL.tools.UniqueIdManager.Identifyable, VASSAL.tools.ToolBarComponent, VASSAL.build.module.properties.MutablePropertiesContainer, VASSAL.build.module.properties.PropertySource, PlayerRoster.SideChangeListener):
    NAME: typing.ClassVar[str] = ...
    MARK_MOVED: typing.ClassVar[str] = ...
    MARK_UNMOVED_ICON: typing.ClassVar[str] = ...
    MARK_UNMOVED_TEXT: typing.ClassVar[str] = ...
    MARK_UNMOVED_TOOLTIP: typing.ClassVar[str] = ...
    MARK_UNMOVED_HOTKEY: typing.ClassVar[str] = ...
    MARK_UNMOVED_REPORT: typing.ClassVar[str] = ...
    EDGE_WIDTH: typing.ClassVar[str] = ...
    EDGE_HEIGHT: typing.ClassVar[str] = ...
    BACKGROUND_COLOR: typing.ClassVar[str] = ...
    HIGHLIGHT_COLOR: typing.ClassVar[str] = ...
    HIGHLIGHT_THICKNESS: typing.ClassVar[str] = ...
    ALLOW_MULTIPLE: typing.ClassVar[str] = ...
    USE_LAUNCH_BUTTON: typing.ClassVar[str] = ...
    BUTTON_NAME: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    SUPPRESS_AUTO: typing.ClassVar[str] = ...
    MOVE_WITHIN_FORMAT: typing.ClassVar[str] = ...
    MOVE_TO_FORMAT: typing.ClassVar[str] = ...
    CREATE_FORMAT: typing.ClassVar[str] = ...
    CHANGE_FORMAT: typing.ClassVar[str] = ...
    MOVE_KEY: typing.ClassVar[str] = ...
    MOVING_STACKS_PICKUP_UNITS: typing.ClassVar[str] = ...
    SHOW_KEY: typing.ClassVar[str] = ...
    HIDE_KEY: typing.ClassVar[str] = ...
    activeMap: typing.ClassVar['Map'] = ...
    PREFERRED_EDGE_SCROLL_DELAY: typing.ClassVar[int] = ...
    PREFERRED_EDGE_DELAY: typing.ClassVar[str] = ...
    SCROLL_ZONE: typing.ClassVar[int] = ...
    PREFERRED_SCROLL_ZONE: typing.ClassVar[str] = ...
    LOCATION: typing.ClassVar[str] = ...
    OLD_LOCATION: typing.ClassVar[str] = ...
    OLD_MAP: typing.ClassVar[str] = ...
    MAP_NAME: typing.ClassVar[str] = ...
    PIECE_NAME: typing.ClassVar[str] = ...
    MESSAGE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addDrawComponent(self, drawable: VASSAL.build.module.map.Drawable) -> None: ...
    def addHighlighter(self, highlighter: VASSAL.counters.Highlighter) -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addLocalMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def addLocalMouseListenerFirst(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def addMutableProperty(self, string: str, mutableProperty: VASSAL.build.module.properties.MutableProperty) -> None: ...
    def addPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def appendToTitle(self, string: str) -> None: ...
    def apply(self, pieceVisitorDispatcher: VASSAL.counters.PieceVisitorDispatcher) -> VASSAL.command.Command: ...
    def boundingBoxOf(self, gamePiece: VASSAL.counters.GamePiece) -> java.awt.Rectangle: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    @typing.overload
    def centerAt(self, point: java.awt.Point) -> None: ...
    @typing.overload
    def centerAt(self, point: java.awt.Point, int: int, int2: int) -> None: ...
    @staticmethod
    def clearActiveMap() -> None: ...
    def componentCoordinates(self, point: java.awt.Point) -> java.awt.Point: ...
    def componentRectangle(self, rectangle: java.awt.Rectangle) -> java.awt.Rectangle: ...
    @typing.overload
    def componentToDrawing(self, int: int, double: float) -> int: ...
    @typing.overload
    def componentToDrawing(self, point: java.awt.Point, double: float) -> java.awt.Point: ...
    @typing.overload
    def componentToDrawing(self, rectangle: java.awt.Rectangle, double: float) -> java.awt.Rectangle: ...
    @typing.overload
    def componentToMap(self, int: int) -> int: ...
    @typing.overload
    def componentToMap(self, point: java.awt.Point) -> java.awt.Point: ...
    @typing.overload
    def componentToMap(self, rectangle: java.awt.Rectangle) -> java.awt.Rectangle: ...
    def disableKeyListeners(self) -> None: ...
    def dragEnter(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
    def dragExit(self, dropTargetEvent: java.awt.dnd.DropTargetEvent) -> None: ...
    def dragOver(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
    def drawBoards(self, graphics: java.awt.Graphics, int: int, int2: int, double: float, component: java.awt.Component) -> None: ...
    @typing.overload
    def drawBoardsInRegion(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle) -> None: ...
    @typing.overload
    def drawBoardsInRegion(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, component: java.awt.Component) -> None: ...
    def drawDrawable(self, graphics: java.awt.Graphics, boolean: bool) -> None: ...
    def drawPieces(self, graphics: java.awt.Graphics, int: int, int2: int) -> None: ...
    @typing.overload
    def drawPiecesInRegion(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle) -> None: ...
    @typing.overload
    def drawPiecesInRegion(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, component: java.awt.Component) -> None: ...
    @typing.overload
    def drawingToComponent(self, int: int, double: float) -> int: ...
    @typing.overload
    def drawingToComponent(self, point: java.awt.Point, double: float) -> java.awt.Point: ...
    @typing.overload
    def drawingToComponent(self, rectangle: java.awt.Rectangle, double: float) -> java.awt.Rectangle: ...
    @typing.overload
    def drawingToMap(self, int: int, double: float) -> int: ...
    @typing.overload
    def drawingToMap(self, point: java.awt.Point, double: float) -> java.awt.Point: ...
    @typing.overload
    def drawingToMap(self, rectangle: java.awt.Rectangle, double: float) -> java.awt.Rectangle: ...
    def drop(self, dropTargetDropEvent: java.awt.dnd.DropTargetDropEvent) -> None: ...
    def dropActionChanged(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
    def enableKeyListeners(self) -> None: ...
    def ensureVisible(self, rectangle: java.awt.Rectangle) -> None: ...
    def findAnyPiece(self, point: java.awt.Point, pieceFinder: typing.Union[VASSAL.counters.PieceFinder, typing.Callable]) -> VASSAL.counters.GamePiece: ...
    def findBoard(self, point: java.awt.Point) -> VASSAL.build.module.map.boardPicker.Board: ...
    def findPiece(self, point: java.awt.Point, pieceFinder: typing.Union[VASSAL.counters.PieceFinder, typing.Callable]) -> VASSAL.counters.GamePiece: ...
    def findRegion(self, string: str) -> VASSAL.build.module.map.boardPicker.board.Region: ...
    @typing.overload
    def findZone(self, point: java.awt.Point) -> VASSAL.build.module.map.boardPicker.board.mapgrid.Zone: ...
    @typing.overload
    def findZone(self, string: str) -> VASSAL.build.module.map.boardPicker.board.mapgrid.Zone: ...
    def getAllPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBoardByName(self, string: str) -> VASSAL.build.module.map.boardPicker.Board: ...
    def getBoardCount(self) -> int: ...
    def getBoardPicker(self) -> VASSAL.build.module.map.BoardPicker: ...
    def getBoards(self) -> java.util.Collection[VASSAL.build.module.map.boardPicker.Board]: ...
    @typing.overload
    def getChangeFormat(self) -> str: ...
    @typing.overload
    def getChangeFormat(self, boolean: bool) -> str: ...
    def getComponent(self) -> java.awt.Component: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getCreateFormat(self) -> str: ...
    def getDeckNameAt(self, point: java.awt.Point) -> str: ...
    def getDeckNameContaining(self, point: java.awt.Point) -> str: ...
    def getDragGestureListener(self) -> java.awt.dnd.DragGestureListener: ...
    def getEdgeBuffer(self) -> java.awt.Dimension: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getHighlighter(self) -> VASSAL.counters.Highlighter: ...
    def getHighlighters(self) -> java.util.Iterator[VASSAL.counters.Highlighter]: ...
    def getId(self) -> str: ...
    def getIdentifier(self) -> str: ...
    def getKeyBufferer(self) -> VASSAL.build.module.map.KeyBufferer: ...
    def getLayeredPane(self) -> javax.swing.JLayeredPane: ...
    def getLocalizedDeckNameAt(self, point: java.awt.Point) -> str: ...
    def getLocalizedMapName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    @staticmethod
    def getMapById(string: str) -> 'Map': ...
    @staticmethod
    def getMapList() -> java.util.List['Map']: ...
    def getMapName(self) -> str: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getMoveKey(self) -> javax.swing.KeyStroke: ...
    def getMoveToFormat(self) -> str: ...
    def getMoveWithinFormat(self) -> str: ...
    def getMutablePropertiesContainerId(self) -> str: ...
    def getMutableProperty(self, string: str) -> VASSAL.build.module.properties.MutableProperty: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPieceCollection(self) -> VASSAL.build.module.map.PieceCollection: ...
    def getPieceMover(self) -> VASSAL.build.module.map.PieceMover: ...
    def getPieceOpacity(self) -> float: ...
    def getPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def getPreferredSize(self) -> java.awt.Dimension: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getStackMetrics(self) -> VASSAL.build.module.map.StackMetrics: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def getView(self) -> javax.swing.JComponent: ...
    def getZoom(self) -> float: ...
    def getZoomer(self) -> VASSAL.build.module.map.Zoomer: ...
    def hideMap(self) -> None: ...
    def indexOf(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...
    @staticmethod
    def isChangeReportingEnabled() -> bool: ...
    def isFirstMap(self) -> bool: ...
    def isLocationRestricted(self, point: java.awt.Point) -> bool: ...
    def isPiecesVisible(self) -> bool: ...
    def isVisibleToAll(self) -> bool: ...
    def localizedLocationName(self, point: java.awt.Point) -> str: ...
    def locationName(self, point: java.awt.Point) -> str: ...
    def mapCoordinates(self, point: java.awt.Point) -> java.awt.Point: ...
    def mapRectangle(self, rectangle: java.awt.Rectangle) -> java.awt.Rectangle: ...
    def mapSize(self) -> java.awt.Dimension: ...
    @typing.overload
    def mapToComponent(self, int: int) -> int: ...
    @typing.overload
    def mapToComponent(self, point: java.awt.Point) -> java.awt.Point: ...
    @typing.overload
    def mapToComponent(self, rectangle: java.awt.Rectangle) -> java.awt.Rectangle: ...
    @typing.overload
    def mapToDrawing(self, int: int, double: float) -> int: ...
    @typing.overload
    def mapToDrawing(self, point: java.awt.Point, double: float) -> java.awt.Point: ...
    @typing.overload
    def mapToDrawing(self, rectangle: java.awt.Rectangle, double: float) -> java.awt.Rectangle: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    @typing.overload
    def paintRegion(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle) -> None: ...
    @typing.overload
    def paintRegion(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, component: java.awt.Component) -> None: ...
    def placeAt(self, gamePiece: VASSAL.counters.GamePiece, point: java.awt.Point) -> VASSAL.command.Command: ...
    def placeOrMerge(self, gamePiece: VASSAL.counters.GamePiece, point: java.awt.Point) -> VASSAL.command.Command: ...
    @typing.overload
    def popMouseListener(self) -> None: ...
    @typing.overload
    def popMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def positionOf(self, gamePiece: VASSAL.counters.GamePiece) -> java.awt.Point: ...
    def pushMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def removeDrawComponent(self, drawable: VASSAL.build.module.map.Drawable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeHighlighter(self, highlighter: VASSAL.counters.Highlighter) -> None: ...
    def removeLocalMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def removeMutableProperty(self, string: str) -> VASSAL.build.module.properties.MutableProperty: ...
    def removePiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    @typing.overload
    def repaint(self) -> None: ...
    @typing.overload
    def repaint(self, boolean: bool) -> None: ...
    @typing.overload
    def repaint(self, rectangle: java.awt.Rectangle) -> None: ...
    def scroll(self, int: int, int2: int) -> None: ...
    def scrollAtEdge(self, point: java.awt.Point, int: int) -> None: ...
    def selectionBoundsOf(self, gamePiece: VASSAL.counters.GamePiece) -> java.awt.Rectangle: ...
    @staticmethod
    def setActiveMap(map: 'Map') -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setBoardPicker(self, boardPicker: VASSAL.build.module.map.BoardPicker) -> None: ...
    def setBoards(self, collection: typing.Union[java.util.Collection[VASSAL.build.module.map.boardPicker.Board], typing.Sequence[VASSAL.build.module.map.boardPicker.Board], typing.Set[VASSAL.build.module.map.boardPicker.Board]]) -> None: ...
    @staticmethod
    def setChangeReportingEnabled(boolean: bool) -> None: ...
    def setDragGestureListener(self, dragGestureListener: java.awt.dnd.DragGestureListener) -> None: ...
    def setHighlighter(self, highlighter: VASSAL.counters.Highlighter) -> None: ...
    def setId(self, string: str) -> None: ...
    def setKeyBufferer(self, keyBufferer: VASSAL.build.module.map.KeyBufferer) -> None: ...
    def setMapName(self, string: str) -> None: ...
    def setPieceCollection(self, pieceCollection: VASSAL.build.module.map.PieceCollection) -> None: ...
    def setPieceMover(self, pieceMover: VASSAL.build.module.map.PieceMover) -> None: ...
    def setPieceOpacity(self, float: float) -> None: ...
    def setPiecesVisible(self, boolean: bool) -> None: ...
    def setStackMetrics(self, stackMetrics: VASSAL.build.module.map.StackMetrics) -> None: ...
    def setZoomer(self, zoomer: VASSAL.build.module.map.Zoomer) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def shouldDockIntoMainWindow(self) -> bool: ...
    def showMap(self) -> None: ...
    def sideChanged(self, string: str, string2: str) -> None: ...
    def snapTo(self, point: java.awt.Point) -> java.awt.Point: ...
    def translateEvent(self, mouseEvent: java.awt.event.MouseEvent) -> java.awt.event.MouseEvent: ...
    def updateTitleBar(self) -> None: ...
    class ChangeFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class CreateFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class InsetLayout(javax.swing.OverlayLayout):
        def __init__(self, container: java.awt.Container, jScrollPane: javax.swing.JScrollPane): ...
        def layoutContainer(self, container: java.awt.Container) -> None: ...
    class Merger(VASSAL.counters.DeckVisitor):
        def __init__(self, map: 'Map', point: java.awt.Point, gamePiece: VASSAL.counters.GamePiece): ...
        def visitDeck(self, deck: VASSAL.counters.Deck) -> typing.Any: ...
        def visitDefault(self, gamePiece: VASSAL.counters.GamePiece) -> typing.Any: ...
        def visitStack(self, stack: VASSAL.counters.Stack) -> typing.Any: ...
    class MoveToFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class MoveWithinFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class UnmovedIconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class UnmovedReportConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class View(javax.swing.JPanel):
        def __init__(self, map: 'Map'): ...
        def getMap(self) -> 'Map': ...
        def getPreferredSize(self) -> java.awt.Dimension: ...
        def paint(self, graphics: java.awt.Graphics) -> None: ...
        def update(self, graphics: java.awt.Graphics) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module")``.

    BasicCommandEncoder: typing.Type[BasicCommandEncoder]
    BasicLogger: typing.Type[BasicLogger]
    ChartWindow: typing.Type[ChartWindow]
    Chatter: typing.Type[Chatter]
    ChessClockControl: typing.Type[ChessClockControl]
    ConnectionWindow: typing.Type[ConnectionWindow]
    Console: typing.Type[Console]
    ConsoleAppender: typing.Type[ConsoleAppender]
    DiceButton: typing.Type[DiceButton]
    DieManager: typing.Type[DieManager]
    DieRoll: typing.Type[DieRoll]
    DoActionButton: typing.Type[DoActionButton]
    Documentation: typing.Type[Documentation]
    EventLog: typing.Type[EventLog]
    ExtensionElement: typing.Type[ExtensionElement]
    ExtensionsLoader: typing.Type[ExtensionsLoader]
    ExtensionsManager: typing.Type[ExtensionsManager]
    GameComponent: typing.Type[GameComponent]
    GameRefresher: typing.Type[GameRefresher]
    GameSetupStep: typing.Type[GameSetupStep]
    GameState: typing.Type[GameState]
    GlobalKeyCommand: typing.Type[GlobalKeyCommand]
    GlobalOptions: typing.Type[GlobalOptions]
    InternetDiceButton: typing.Type[InternetDiceButton]
    Inventory: typing.Type[Inventory]
    KeyNamer: typing.Type[KeyNamer]
    Map: typing.Type[Map]
    ModuleExtension: typing.Type[ModuleExtension]
    ModulePlugin: typing.Type[ModulePlugin]
    MultiActionButton: typing.Type[MultiActionButton]
    MultiRoll: typing.Type[MultiRoll]
    NewGameIndicator: typing.Type[NewGameIndicator]
    NotesWindow: typing.Type[NotesWindow]
    ObscurableOptions: typing.Type[ObscurableOptions]
    PieceWindow: typing.Type[PieceWindow]
    PlayerHand: typing.Type[PlayerHand]
    PlayerRoster: typing.Type[PlayerRoster]
    Plugin: typing.Type[Plugin]
    PluginsLoader: typing.Type[PluginsLoader]
    PredefinedSetup: typing.Type[PredefinedSetup]
    PrivateMap: typing.Type[PrivateMap]
    PrototypeDefinition: typing.Type[PrototypeDefinition]
    PrototypesContainer: typing.Type[PrototypesContainer]
    RandomTextButton: typing.Type[RandomTextButton]
    ServerConnection: typing.Type[ServerConnection]
    SpecialDiceButton: typing.Type[SpecialDiceButton]
    SpecialDie: typing.Type[SpecialDie]
    SpecialDieFace: typing.Type[SpecialDieFace]
    StartupGlobalKeyCommand: typing.Type[StartupGlobalKeyCommand]
    ToolbarMenu: typing.Type[ToolbarMenu]
    WizardSupport: typing.Type[WizardSupport]
    chessclockcontrol: VASSAL.build.module.chessclockcontrol.__module_protocol__
    dice: VASSAL.build.module.dice.__module_protocol__
    documentation: VASSAL.build.module.documentation.__module_protocol__
    folder: VASSAL.build.module.folder.__module_protocol__
    gamepieceimage: VASSAL.build.module.gamepieceimage.__module_protocol__
    map: VASSAL.build.module.map.__module_protocol__
    metadata: VASSAL.build.module.metadata.__module_protocol__
    noteswindow: VASSAL.build.module.noteswindow.__module_protocol__
    properties: VASSAL.build.module.properties.__module_protocol__
    turn: VASSAL.build.module.turn.__module_protocol__
