import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.command
import VASSAL.configure
import VASSAL.i18n
import VASSAL.tools
import java.awt.event
import java.lang
import java.util
import typing



class TurnComponent(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def addLevel(self, turnLevel: 'TurnLevel') -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getTurnLevels(self) -> java.util.Iterator['TurnLevel']: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeLevel(self, turnLevel: 'TurnLevel') -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class TurnGlobalHotkey(VASSAL.build.AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    MATCH: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def apply(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class TurnLevel(TurnComponent):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def findMaximumStrings(self, list: java.util.List[str], int: int) -> None: ...
    def getActiveChildLevels(self) -> java.util.List['TurnLevel']: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getTurnString(self) -> str: ...
    def isConfigurable(self) -> bool: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class TurnFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class TurnTracker(TurnComponent, VASSAL.command.CommandEncoder, VASSAL.build.module.GameComponent, java.awt.event.ActionListener, VASSAL.tools.UniqueIdManager.Identifyable, VASSAL.tools.RecursionLimiter.Loopable):
    NAME: typing.ClassVar[str] = ...
    HOT_KEY: typing.ClassVar[str] = ...
    NEXT_HOT_KEY: typing.ClassVar[str] = ...
    PREV_HOT_KEY: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    BUTTON_TOOLTIP: typing.ClassVar[str] = ...
    TURN_FORMAT: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    LENGTH: typing.ClassVar[str] = ...
    LENGTH_STYLE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getState(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def replace(self, stringBuilder: java.lang.StringBuilder, string2: str, string3: str) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    def setState(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def updateString(self, string: str, stringArray: typing.List[str], stringArray2: typing.List[str]) -> str: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LengthStyleConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class SetTurn(VASSAL.command.Command):
        @typing.overload
        def __init__(self, turnTracker: 'TurnTracker', string: str): ...
        @typing.overload
        def __init__(self, string: str, turnTracker: 'TurnTracker'): ...
        def getTurn(self) -> 'TurnTracker': ...
    class TurnFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class CounterTurnLevel(TurnLevel):
    def __init__(self): ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ListTurnLevel(TurnLevel, java.awt.event.ActionListener):
    def __init__(self): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def isConfigurable(self) -> bool: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.turn")``.

    CounterTurnLevel: typing.Type[CounterTurnLevel]
    ListTurnLevel: typing.Type[ListTurnLevel]
    TurnComponent: typing.Type[TurnComponent]
    TurnGlobalHotkey: typing.Type[TurnGlobalHotkey]
    TurnLevel: typing.Type[TurnLevel]
    TurnTracker: typing.Type[TurnTracker]
