import VASSAL.build
import VASSAL.build.module.documentation
import VASSAL.configure
import VASSAL.counters
import VASSAL.tools
import java.awt
import java.awt.event
import java.io
import java.lang
import java.net
import java.util
import javax.swing
import javax.swing.event
import jpype.protocol
import org.w3c.dom
import typing



class BundleHelper:
    def __init__(self, resourceBundle: java.util.ResourceBundle): ...
    def getResourceBundle(self) -> java.util.ResourceBundle: ...
    @typing.overload
    def getString(self, string: str) -> str: ...
    @typing.overload
    def getString(self, string: str, *object: typing.Any) -> str: ...

class ComponentI18nData:
    @typing.overload
    def __init__(self, abstractConfigurable: VASSAL.build.AbstractConfigurable, string: str): ...
    @typing.overload
    def __init__(self, abstractConfigurable: VASSAL.build.AbstractConfigurable, string: str, arrayList: java.util.ArrayList[str], arrayList2: java.util.ArrayList[typing.Type[typing.Any]], arrayList3: java.util.ArrayList[str]): ...
    @typing.overload
    def __init__(self, abstractConfigurable: VASSAL.build.AbstractConfigurable, string: str, list: java.util.List[str], list2: java.util.List[typing.Type[typing.Any]], list3: java.util.List[str]): ...
    @typing.overload
    def __init__(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str): ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, gamePiece: VASSAL.counters.GamePiece): ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, string: str): ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, string: str, translatable: 'Translatable'): ...
    @typing.overload
    def __init__(self, configurable: VASSAL.build.Configurable, string: str, translatable: 'Translatable', stringArray: typing.List[str], booleanArray: typing.List[bool], stringArray2: typing.List[str]): ...
    def applyTranslation(self, string: str, string2: str) -> None: ...
    def getAttributeDescription(self, string: str) -> str: ...
    def getAttributeKeys(self) -> java.util.Collection[str]: ...
    def getChildren(self) -> java.util.List['Translatable']: ...
    def getFullPrefix(self) -> str: ...
    def getLocalUntranslatedValue(self, string: str) -> str: ...
    def getOwningComponent(self) -> 'Translatable': ...
    def getPrefix(self) -> str: ...
    def getTranslatedValue(self, string: str, translation: 'Translation') -> str: ...
    def hasUntranslatedAttributes(self, translation: 'Translation') -> bool: ...
    def isAttributeTranslatable(self, string: str) -> bool: ...
    def isTranslatable(self) -> bool: ...
    def setAllAttributesUntranslatable(self) -> None: ...
    def setAttributeTranslatable(self, string: str, boolean: bool) -> None: ...
    def setOwningComponent(self, translatable: 'Translatable') -> None: ...
    def setPrefix(self, string: str) -> None: ...
    def setUntranslatedValue(self, string: str, string2: str) -> None: ...
    class Property:
        def __init__(self, string: str, string2: str): ...
        def getDescription(self) -> str: ...
        def getName(self) -> str: ...
        def getUntranslatedValue(self) -> str: ...
        def setUntranslatedValue(self, string: str) -> None: ...

class I18nResourcePathFinder(VASSAL.tools.ResourcePathFinder):
    def __init__(self, dataArchive: VASSAL.tools.DataArchive, string: str): ...
    def changeLanguage(self, string: str) -> None: ...
    def findHelpFileName(self, string: str) -> str: ...
    def findImagePath(self, string: str) -> str: ...

class Language(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class LocaleConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, locale: java.util.Locale): ...
    def getControls(self) -> java.awt.Component: ...
    def getValueLocale(self) -> java.util.Locale: ...
    def getValueString(self) -> str: ...
    @staticmethod
    def localeToString(locale: java.util.Locale) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, locale: java.util.Locale) -> None: ...
    @staticmethod
    def stringToLocale(string: str) -> java.util.Locale: ...

class PieceI18nData:
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    def add(self, string: str, string2: str) -> None: ...
    def getProperties(self) -> java.util.List['PieceI18nData.Property']: ...
    def translate(self, string: str) -> str: ...
    class Property:
        def __init__(self, string: str, string2: str): ...
        def getDescription(self) -> str: ...
        def getName(self) -> str: ...

class Resources:
    VASSAL: typing.ClassVar[str] = ...
    LOCALE_PREF_KEY: typing.ClassVar[str] = ...
    ADD: typing.ClassVar[str] = ...
    REMOVE: typing.ClassVar[str] = ...
    INSERT: typing.ClassVar[str] = ...
    YES: typing.ClassVar[str] = ...
    NO: typing.ClassVar[str] = ...
    CANCEL: typing.ClassVar[str] = ...
    SAVE: typing.ClassVar[str] = ...
    OK: typing.ClassVar[str] = ...
    MENU: typing.ClassVar[str] = ...
    LOAD: typing.ClassVar[str] = ...
    QUIT: typing.ClassVar[str] = ...
    EDIT: typing.ClassVar[str] = ...
    NEW: typing.ClassVar[str] = ...
    FILE: typing.ClassVar[str] = ...
    TOOLS: typing.ClassVar[str] = ...
    HELP: typing.ClassVar[str] = ...
    CLOSE: typing.ClassVar[str] = ...
    DATE_DISPLAY: typing.ClassVar[str] = ...
    NEXT: typing.ClassVar[str] = ...
    REFRESH: typing.ClassVar[str] = ...
    SELECT: typing.ClassVar[str] = ...
    EDITOR_PREFIX: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    TOOLTIP_TEXT: typing.ClassVar[str] = ...
    BUTTON_ICON: typing.ClassVar[str] = ...
    HOTKEY_LABEL: typing.ClassVar[str] = ...
    COLOR_LABEL: typing.ClassVar[str] = ...
    NAME_LABEL: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    REPORT_FORMAT_LABEL: typing.ClassVar[str] = ...
    COMMAND_NAME_LABEL: typing.ClassVar[str] = ...
    KEYBOARD_COMMAND_LABEL: typing.ClassVar[str] = ...
    NAME_FORMAT_LABEL: typing.ClassVar[str] = ...
    MENU_COMMAND_LABEL: typing.ClassVar[str] = ...
    HORIZONTAL_OFFSET_LABEL: typing.ClassVar[str] = ...
    VERTICAL_OFFSET_LABEL: typing.ClassVar[str] = ...
    VALUE_LABEL: typing.ClassVar[str] = ...
    @staticmethod
    def addSupportedLocale(locale: java.util.Locale) -> None: ...
    @staticmethod
    def formatDate(date: java.util.Date) -> str: ...
    def getEditorKeys(self) -> java.util.Collection[str]: ...
    @staticmethod
    def getLocale() -> java.util.Locale: ...
    @typing.overload
    @staticmethod
    def getString(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def getString(string: str, *object: typing.Any) -> str: ...
    @staticmethod
    def getSupportedLocales() -> java.util.Collection[java.util.Locale]: ...
    @staticmethod
    def getVassalKeys() -> java.util.Collection[str]: ...
    @staticmethod
    def setLocale(locale: java.util.Locale) -> None: ...
    class VassalPropertyClassLoader(java.lang.ClassLoader):
        def __init__(self, resources: 'Resources'): ...
        def getAResource(self, string: str) -> java.net.URL: ...
        def getResource(self, string: str) -> java.net.URL: ...

class Translatable(VASSAL.build.Buildable):
    def getAttributeValueString(self, string: str) -> str: ...
    def getI18nData(self) -> ComponentI18nData: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class TranslatableAttribute:
    def __init__(self, translatable: Translatable, string: str, string2: str): ...
    def applyTranslation(self, string: str) -> None: ...
    def getKey(self) -> str: ...
    def getUntranslatedValue(self) -> str: ...
    def isTranslatable(self) -> bool: ...

class TranslatableConfigurerFactory(VASSAL.configure.ConfigurerFactory): ...

class TranslatableMarker(VASSAL.build.AbstractConfigurable):
    def __init__(self, placeMarker: VASSAL.counters.PlaceMarker): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> ComponentI18nData: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class TranslatablePiece(VASSAL.counters.EditablePiece):
    PREFIX: typing.ClassVar[str] = ...
    def getI18nData(self) -> PieceI18nData: ...

class TranslateAction(javax.swing.AbstractAction):
    def __init__(self, configurable: VASSAL.build.Configurable, helpWindow: VASSAL.build.module.documentation.HelpWindow, configureTree: VASSAL.configure.ConfigureTree): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class TranslateWindow(javax.swing.JDialog, javax.swing.event.ListSelectionListener, javax.swing.event.TreeSelectionListener):
    def __init__(self, frame: java.awt.Frame, boolean: bool, translatable: Translatable, configureTree: VASSAL.configure.ConfigureTree): ...
    @staticmethod
    def getDisplayName(translatable: Translatable) -> str: ...
    @typing.overload
    def valueChanged(self, listSelectionEvent: javax.swing.event.ListSelectionEvent) -> None: ...
    @typing.overload
    def valueChanged(self, treeSelectionEvent: javax.swing.event.TreeSelectionEvent) -> None: ...

class Translation(VASSAL.build.AbstractConfigurable, java.lang.Comparable['Translation']):
    LOCALE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def compareTo(self, translation: 'Translation') -> int: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBundleFileName(self) -> str: ...
    def getBundleName(self) -> str: ...
    def getConfigureName(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLanguageCode(self) -> str: ...
    def getLocale(self) -> java.util.Locale: ...
    def getProperties(self) -> java.util.Properties: ...
    def isDirty(self) -> bool: ...
    def reloadProperties(self) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setProperty(self, string: str, string2: str) -> None: ...
    def translate(self, string: str) -> str: ...
    class LocalePrompt(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class VassalResourceBundle(java.util.PropertyResourceBundle):
    def __init__(self, inputStream: java.io.InputStream): ...
    def setParent(self, resourceBundle: java.util.ResourceBundle) -> None: ...

class Localization(Language):
    def addTranslation(self, translation: Translation) -> None: ...
    @staticmethod
    def getInstance() -> 'Localization': ...
    def getTranslation(self, string: str) -> Translation: ...
    def getTranslationList(self) -> typing.List[str]: ...
    def isTranslationComplete(self) -> bool: ...
    def isTranslationInProgress(self) -> bool: ...
    def removeTranslation(self, translation: Translation) -> None: ...
    def saveTranslatableAttribute(self, translatable: Translatable, string: str, string2: str) -> None: ...
    @typing.overload
    def translate(self, string: str, string2: str) -> str: ...
    @typing.overload
    def translate(self) -> None: ...

class TranslateVassalWindow(TranslateWindow):
    @typing.overload
    def __init__(self, frame: java.awt.Frame): ...
    @typing.overload
    def __init__(self, frame: java.awt.Frame, boolean: bool, translatable: Translatable, configureTree: VASSAL.configure.ConfigureTree): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...

class VassalTranslation(Translation):
    def __init__(self): ...
    def clearProperties(self) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def saveProperties(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], locale: java.util.Locale) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.i18n")``.

    BundleHelper: typing.Type[BundleHelper]
    ComponentI18nData: typing.Type[ComponentI18nData]
    I18nResourcePathFinder: typing.Type[I18nResourcePathFinder]
    Language: typing.Type[Language]
    LocaleConfigurer: typing.Type[LocaleConfigurer]
    Localization: typing.Type[Localization]
    PieceI18nData: typing.Type[PieceI18nData]
    Resources: typing.Type[Resources]
    Translatable: typing.Type[Translatable]
    TranslatableAttribute: typing.Type[TranslatableAttribute]
    TranslatableConfigurerFactory: typing.Type[TranslatableConfigurerFactory]
    TranslatableMarker: typing.Type[TranslatableMarker]
    TranslatablePiece: typing.Type[TranslatablePiece]
    TranslateAction: typing.Type[TranslateAction]
    TranslateVassalWindow: typing.Type[TranslateVassalWindow]
    TranslateWindow: typing.Type[TranslateWindow]
    Translation: typing.Type[Translation]
    VassalResourceBundle: typing.Type[VassalResourceBundle]
    VassalTranslation: typing.Type[VassalTranslation]
