import VASSAL.configure
import java.awt
import java.io
import javax.swing.filechooser
import jpype.protocol
import typing



class FileChooser:
    APPROVE_OPTION: typing.ClassVar[int] = ...
    CANCEL_OPTION: typing.ClassVar[int] = ...
    ERROR_OPTION: typing.ClassVar[int] = ...
    FILES_ONLY: typing.ClassVar[int] = ...
    DIRECTORIES_ONLY: typing.ClassVar[int] = ...
    def addChoosableFileFilter(self, fileFilter: 'FileFilter') -> None: ...
    @typing.overload
    @staticmethod
    def createFileChooser(component: java.awt.Component) -> 'FileChooser': ...
    @typing.overload
    @staticmethod
    def createFileChooser(component: java.awt.Component, directoryConfigurer: VASSAL.configure.DirectoryConfigurer) -> 'FileChooser': ...
    @typing.overload
    @staticmethod
    def createFileChooser(component: java.awt.Component, directoryConfigurer: VASSAL.configure.DirectoryConfigurer, int: int) -> 'FileChooser': ...
    def getCurrentDirectory(self) -> java.io.File: ...
    def getDialogTitle(self) -> str: ...
    def getFileFilter(self) -> 'FileFilter': ...
    def getSelectedFile(self) -> java.io.File: ...
    def removeChoosableFileFilter(self, fileFilter: 'FileFilter') -> bool: ...
    def rescanCurrentDirectory(self) -> None: ...
    def resetChoosableFileFilters(self) -> None: ...
    def selectDotSavFile(self) -> None: ...
    def setCurrentDirectory(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    def setDialogTitle(self, string: str) -> None: ...
    def setFileFilter(self, fileFilter: 'FileFilter') -> None: ...
    def setSelectedFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def showOpenDialog(self, component: java.awt.Component) -> int: ...
    @typing.overload
    def showOpenDialog(self) -> int: ...
    @typing.overload
    def showSaveDialog(self, component: java.awt.Component) -> int: ...
    @typing.overload
    def showSaveDialog(self) -> int: ...

class FileFilter(javax.swing.filechooser.FileFilter, java.io.FilenameFilter):
    def __init__(self): ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str) -> bool: ...
    def getDescription(self) -> str: ...

class DirectoryFileFilter(FileFilter):
    def __init__(self): ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str) -> bool: ...
    def getDescription(self) -> str: ...

class ExtensionFileFilter(FileFilter):
    def __init__(self, string: str, stringArray: typing.List[str]): ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str) -> bool: ...
    def getDescription(self) -> str: ...

class AudioFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...

class BMPFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...

class ImageFileFilter(ExtensionFileFilter):
    def __init__(self): ...

class LogAndSaveFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...

class LogFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...

class ModuleExtensionFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...

class ModuleFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...

class PNGFileFilter(ExtensionFileFilter):
    types: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.filechooser")``.

    AudioFileFilter: typing.Type[AudioFileFilter]
    BMPFileFilter: typing.Type[BMPFileFilter]
    DirectoryFileFilter: typing.Type[DirectoryFileFilter]
    ExtensionFileFilter: typing.Type[ExtensionFileFilter]
    FileChooser: typing.Type[FileChooser]
    FileFilter: typing.Type[FileFilter]
    ImageFileFilter: typing.Type[ImageFileFilter]
    LogAndSaveFileFilter: typing.Type[LogAndSaveFileFilter]
    LogFileFilter: typing.Type[LogFileFilter]
    ModuleExtensionFileFilter: typing.Type[ModuleExtensionFileFilter]
    ModuleFileFilter: typing.Type[ModuleFileFilter]
    PNGFileFilter: typing.Type[PNGFileFilter]
