import VASSAL.counters
import VASSAL.tools
import VASSAL.tools.image
import VASSAL.tools.io
import VASSAL.tools.opcache
import java.awt
import java.awt.image
import java.lang
import java.util
import java.util.concurrent
import javax.swing
import typing



class ImageOp(VASSAL.tools.opcache.Op[java.awt.image.BufferedImage]):
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getFutureImage(self, imageOpObserver: 'ImageOpObserver') -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    @typing.overload
    def getFutureTile(self, int: int, int2: int, imageOpObserver: 'ImageOpObserver') -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    @typing.overload
    def getFutureTile(self, point: java.awt.Point, imageOpObserver: 'ImageOpObserver') -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    def getHeight(self) -> int: ...
    @typing.overload
    def getImage(self) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def getImage(self, imageOpObserver: 'ImageOpObserver') -> java.awt.image.BufferedImage: ...
    def getNumXTiles(self) -> int: ...
    def getNumYTiles(self) -> int: ...
    def getSize(self) -> java.awt.Dimension: ...
    @typing.overload
    def getTile(self, int: int, int2: int, imageOpObserver: 'ImageOpObserver') -> java.awt.image.BufferedImage: ...
    @typing.overload
    def getTile(self, point: java.awt.Point, imageOpObserver: 'ImageOpObserver') -> java.awt.image.BufferedImage: ...
    def getTileHeight(self) -> int: ...
    def getTileIndices(self, rectangle: java.awt.Rectangle) -> typing.List[java.awt.Point]: ...
    @typing.overload
    def getTileOp(self, int: int, int2: int) -> 'ImageOp': ...
    @typing.overload
    def getTileOp(self, point: java.awt.Point) -> 'ImageOp': ...
    def getTileSize(self) -> java.awt.Dimension: ...
    def getTileWidth(self) -> int: ...
    def getWidth(self) -> int: ...

class ImageOpObserver(VASSAL.tools.opcache.OpObserver[java.awt.image.BufferedImage]):
    def imageOpChange(self, imageOp: ImageOp, boolean: bool) -> None: ...

class Op:
    @staticmethod
    def clearCache() -> None: ...
    @staticmethod
    def crop(imageOp: ImageOp, int: int, int2: int, int3: int, int4: int) -> 'CropOp': ...
    @staticmethod
    def handleException(exception: java.lang.Exception) -> bool: ...
    @typing.overload
    @staticmethod
    def load(bufferedImage: java.awt.image.BufferedImage) -> 'SourceOp': ...
    @typing.overload
    @staticmethod
    def load(string: str) -> 'SourceOp': ...
    @staticmethod
    def loadLarge(string: str) -> 'SourceOp': ...
    @staticmethod
    def piece(gamePiece: VASSAL.counters.GamePiece) -> 'GamePieceOp': ...
    @staticmethod
    def rotate(imageOp: ImageOp, double: float) -> 'RotateOp': ...
    @staticmethod
    def rotateScale(imageOp: ImageOp, double: float, double2: float) -> 'RotateScaleOp': ...
    @staticmethod
    def scale(imageOp: ImageOp, double: float) -> 'ScaleOp': ...

class OpIcon(javax.swing.ImageIcon, javax.swing.Icon):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, imageOp: ImageOp): ...
    def getIconHeight(self) -> int: ...
    def getIconWidth(self) -> int: ...
    def getImage(self) -> java.awt.Image: ...
    def getOp(self) -> ImageOp: ...
    def paintIcon(self, component: java.awt.Component, graphics: java.awt.Graphics, int: int, int2: int) -> None: ...
    def setImage(self, image: java.awt.Image) -> None: ...
    def setOp(self, imageOp: ImageOp) -> None: ...

class OpMultiResolutionImage(java.awt.image.AbstractMultiResolutionImage):
    def __init__(self, imageOp: ImageOp): ...
    def getResolutionVariant(self, double: float, double2: float) -> java.awt.Image: ...
    def getResolutionVariants(self) -> java.util.List[java.awt.Image]: ...

class ScaledImagePainter:
    def __init__(self): ...
    def draw(self, graphics: java.awt.Graphics, int: int, int2: int, double: float, imageObserver: java.awt.image.ImageObserver) -> None: ...
    def getImageSize(self) -> java.awt.Dimension: ...
    def getSource(self) -> ImageOp: ...
    def setImageName(self, string: str) -> None: ...
    def setSource(self, imageOp: ImageOp) -> None: ...

class AbstractOpImpl(VASSAL.tools.opcache.AbstractOpImpl[java.awt.image.BufferedImage], ImageOp):
    def __init__(self): ...
    @staticmethod
    def clearCache() -> None: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getFutureImage(self, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    @typing.overload
    def getFutureTile(self, int: int, int2: int, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    @typing.overload
    def getFutureTile(self, point: java.awt.Point, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    def getHeight(self) -> int: ...
    @typing.overload
    def getImage(self) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def getImage(self, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    def getNumXTiles(self) -> int: ...
    def getNumYTiles(self) -> int: ...
    def getSize(self) -> java.awt.Dimension: ...
    @typing.overload
    def getTile(self, int: int, int2: int, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def getTile(self, point: java.awt.Point, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    def getTileHeight(self) -> int: ...
    def getTileIndices(self, rectangle: java.awt.Rectangle) -> typing.List[java.awt.Point]: ...
    @typing.overload
    def getTileOp(self, point: java.awt.Point) -> ImageOp: ...
    @typing.overload
    def getTileOp(self, int: int, int2: int) -> ImageOp: ...
    def getTileSize(self) -> java.awt.Dimension: ...
    def getTileWidth(self) -> int: ...
    def getWidth(self) -> int: ...

class CropOp(ImageOp):
    def getRect(self) -> java.awt.Rectangle: ...
    def getX0(self) -> int: ...
    def getX1(self) -> int: ...
    def getY0(self) -> int: ...
    def getY1(self) -> int: ...

class GamePieceOp(ImageOp):
    def getPiece(self) -> VASSAL.counters.GamePiece: ...
    def getState(self) -> str: ...
    def isChanged(self) -> bool: ...

class OwningOpMultiResolutionImage(OpMultiResolutionImage):
    def __init__(self, imageOp: ImageOp): ...
    def getResolutionVariant(self, double: float, double2: float) -> java.awt.Image: ...
    def getResolutionVariants(self) -> java.util.List[java.awt.Image]: ...

class Repainter(ImageOpObserver):
    @typing.overload
    def __init__(self, component: java.awt.Component, int: int, int2: int, int3: int, int4: int): ...
    @typing.overload
    def __init__(self, component: java.awt.Component, rectangle: java.awt.Rectangle): ...
    def cancelled(self, op: VASSAL.tools.opcache.Op[java.awt.image.BufferedImage], cancellationException: java.util.concurrent.CancellationException) -> None: ...
    def failed(self, op: VASSAL.tools.opcache.Op[java.awt.image.BufferedImage], executionException: java.util.concurrent.ExecutionException) -> None: ...
    def imageOpChange(self, imageOp: ImageOp, boolean: bool) -> None: ...
    def interrupted(self, op: VASSAL.tools.opcache.Op[java.awt.image.BufferedImage], interruptedException: java.lang.InterruptedException) -> None: ...
    def succeeded(self, op: VASSAL.tools.opcache.Op[java.awt.image.BufferedImage], bufferedImage: java.awt.image.BufferedImage) -> None: ...

class RotateOp(ImageOp):
    def getAngle(self) -> float: ...
    def getHints(self) -> java.awt.RenderingHints: ...

class ScaleOp(ImageOp):
    def getHints(self) -> java.awt.RenderingHints: ...
    def getScale(self) -> float: ...

class SourceOp(ImageOp):
    def getName(self) -> str: ...

class AbstractTileOpImpl(AbstractOpImpl):
    def __init__(self): ...
    @typing.overload
    def getFutureTile(self, point: java.awt.Point, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    @typing.overload
    def getFutureTile(self, int: int, int2: int, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    def getNumXTiles(self) -> int: ...
    def getNumYTiles(self) -> int: ...
    @typing.overload
    def getTile(self, point: java.awt.Point, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def getTile(self, int: int, int2: int, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    def getTileHeight(self) -> int: ...
    def getTileIndices(self, rectangle: java.awt.Rectangle) -> typing.List[java.awt.Point]: ...
    @typing.overload
    def getTileOp(self, point: java.awt.Point) -> ImageOp: ...
    @typing.overload
    def getTileOp(self, int: int, int2: int) -> ImageOp: ...
    def getTileSize(self) -> java.awt.Dimension: ...
    def getTileWidth(self) -> int: ...

class AbstractTiledOpImpl(AbstractOpImpl):
    def __init__(self): ...
    @typing.overload
    def getFutureTile(self, point: java.awt.Point, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    @typing.overload
    def getFutureTile(self, int: int, int2: int, imageOpObserver: ImageOpObserver) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    def getNumXTiles(self) -> int: ...
    def getNumYTiles(self) -> int: ...
    @typing.overload
    def getTile(self, point: java.awt.Point, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def getTile(self, int: int, int2: int, imageOpObserver: ImageOpObserver) -> java.awt.image.BufferedImage: ...
    def getTileHeight(self) -> int: ...
    def getTileIndices(self, rectangle: java.awt.Rectangle) -> typing.List[java.awt.Point]: ...
    @typing.overload
    def getTileOp(self, point: java.awt.Point) -> ImageOp: ...
    @typing.overload
    def getTileOp(self, int: int, int2: int) -> ImageOp: ...
    def getTileSize(self) -> java.awt.Dimension: ...
    def getTileWidth(self) -> int: ...

class RotateScaleOp(RotateOp, ScaleOp): ...

class SVGOp(SourceOp):
    def getName(self) -> str: ...

class CropOpBitmapImpl(AbstractTiledOpImpl, CropOp):
    def __init__(self, imageOp: ImageOp, int: int, int2: int, int3: int, int4: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getRect(self) -> java.awt.Rectangle: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def getX0(self) -> int: ...
    def getX1(self) -> int: ...
    def getY0(self) -> int: ...
    def getY1(self) -> int: ...
    def hashCode(self) -> int: ...

class GamePieceOpImpl(AbstractTileOpImpl, GamePieceOp):
    def __init__(self, gamePiece: VASSAL.counters.GamePiece): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def get(self, opObserver: VASSAL.tools.opcache.OpObserver[java.awt.image.BufferedImage]) -> java.awt.image.BufferedImage: ...
    @typing.overload
    def get(self) -> typing.Any: ...
    def getFuture(self, opObserver: VASSAL.tools.opcache.OpObserver[java.awt.image.BufferedImage]) -> java.util.concurrent.Future[java.awt.image.BufferedImage]: ...
    def getPiece(self) -> VASSAL.counters.GamePiece: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def getState(self) -> str: ...
    def hashCode(self) -> int: ...
    def isChanged(self) -> bool: ...

class ImageSourceOpBitmapImpl(AbstractTiledOpImpl, SourceOp):
    def __init__(self, bufferedImage: java.awt.image.BufferedImage): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getName(self) -> str: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class OrthoRotateOpBitmapImpl(AbstractTiledOpImpl, RotateOp):
    def __init__(self, imageOp: ImageOp, int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getAngle(self) -> float: ...
    def getHints(self) -> java.awt.RenderingHints: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class RotateScaleOpBitmapImpl(AbstractTileOpImpl, RotateScaleOp):
    @typing.overload
    def __init__(self, imageOp: ImageOp, double: float, double2: float): ...
    @typing.overload
    def __init__(self, imageOp: ImageOp, double: float, double2: float, renderingHints: java.awt.RenderingHints): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getAngle(self) -> float: ...
    def getHints(self) -> java.awt.RenderingHints: ...
    def getScale(self) -> float: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class RotateScaleOpSVGImpl(AbstractTileOpImpl, RotateScaleOp, SVGOp):
    @typing.overload
    def __init__(self, sVGOp: SVGOp, double: float, double2: float): ...
    @typing.overload
    def __init__(self, sVGOp: SVGOp, double: float, double2: float, renderingHints: java.awt.RenderingHints): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getAngle(self) -> float: ...
    def getHints(self) -> java.awt.RenderingHints: ...
    def getName(self) -> str: ...
    def getScale(self) -> float: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class ScaleOpBitmapImpl(AbstractTiledOpImpl, ScaleOp):
    @typing.overload
    def __init__(self, imageOp: ImageOp, double: float): ...
    @typing.overload
    def __init__(self, imageOp: ImageOp, double: float, renderingHints: java.awt.RenderingHints): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getHints(self) -> java.awt.RenderingHints: ...
    def getScale(self) -> float: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class SourceOpBitmapImpl(AbstractTiledOpImpl, SourceOp):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, dataArchive: VASSAL.tools.DataArchive): ...
    @typing.overload
    def __init__(self, string: str, fileArchive: VASSAL.tools.io.FileArchive): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getName(self) -> str: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class SourceOpDiskCacheBitmapImpl(AbstractTileOpImpl, SourceOp):
    @typing.overload
    def __init__(self, string: str, int: int, int2: int, double: float): ...
    @typing.overload
    def __init__(self, string: str, int: int, int2: int, double: float, imageTileSource: VASSAL.tools.image.ImageTileSource): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getName(self) -> str: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class SourceOpSVGImpl(AbstractTiledOpImpl, SourceOp, SVGOp):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, dataArchive: VASSAL.tools.DataArchive): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getName(self) -> str: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class SourceTileOpBitmapImpl(AbstractTileOpImpl):
    def __init__(self, imageOp: ImageOp, int: int, int2: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class SourceTileOpSVGImpl(AbstractTileOpImpl, SVGOp):
    def __init__(self, sVGOp: SVGOp, int: int, int2: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def eval(self) -> java.awt.image.BufferedImage: ...
    def getName(self) -> str: ...
    def getSources(self) -> java.util.List[VASSAL.tools.opcache.Op[typing.Any]]: ...
    def hashCode(self) -> int: ...

class ScaleOpTiledBitmapImpl(ScaleOpBitmapImpl):
    @typing.overload
    def __init__(self, imageOp: ImageOp, double: float): ...
    @typing.overload
    def __init__(self, imageOp: ImageOp, double: float, renderingHints: java.awt.RenderingHints): ...

class SourceOpTiledBitmapImpl(SourceOpBitmapImpl):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, dataArchive: VASSAL.tools.DataArchive): ...
    @typing.overload
    def __init__(self, string: str, fileArchive: VASSAL.tools.io.FileArchive): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.imageop")``.

    AbstractOpImpl: typing.Type[AbstractOpImpl]
    AbstractTileOpImpl: typing.Type[AbstractTileOpImpl]
    AbstractTiledOpImpl: typing.Type[AbstractTiledOpImpl]
    CropOp: typing.Type[CropOp]
    CropOpBitmapImpl: typing.Type[CropOpBitmapImpl]
    GamePieceOp: typing.Type[GamePieceOp]
    GamePieceOpImpl: typing.Type[GamePieceOpImpl]
    ImageOp: typing.Type[ImageOp]
    ImageOpObserver: typing.Type[ImageOpObserver]
    ImageSourceOpBitmapImpl: typing.Type[ImageSourceOpBitmapImpl]
    Op: typing.Type[Op]
    OpIcon: typing.Type[OpIcon]
    OpMultiResolutionImage: typing.Type[OpMultiResolutionImage]
    OrthoRotateOpBitmapImpl: typing.Type[OrthoRotateOpBitmapImpl]
    OwningOpMultiResolutionImage: typing.Type[OwningOpMultiResolutionImage]
    Repainter: typing.Type[Repainter]
    RotateOp: typing.Type[RotateOp]
    RotateScaleOp: typing.Type[RotateScaleOp]
    RotateScaleOpBitmapImpl: typing.Type[RotateScaleOpBitmapImpl]
    RotateScaleOpSVGImpl: typing.Type[RotateScaleOpSVGImpl]
    SVGOp: typing.Type[SVGOp]
    ScaleOp: typing.Type[ScaleOp]
    ScaleOpBitmapImpl: typing.Type[ScaleOpBitmapImpl]
    ScaleOpTiledBitmapImpl: typing.Type[ScaleOpTiledBitmapImpl]
    ScaledImagePainter: typing.Type[ScaledImagePainter]
    SourceOp: typing.Type[SourceOp]
    SourceOpBitmapImpl: typing.Type[SourceOpBitmapImpl]
    SourceOpDiskCacheBitmapImpl: typing.Type[SourceOpDiskCacheBitmapImpl]
    SourceOpSVGImpl: typing.Type[SourceOpSVGImpl]
    SourceOpTiledBitmapImpl: typing.Type[SourceOpTiledBitmapImpl]
    SourceTileOpBitmapImpl: typing.Type[SourceTileOpBitmapImpl]
    SourceTileOpSVGImpl: typing.Type[SourceTileOpSVGImpl]
