import VASSAL.tools.concurrent.listener
import java.io
import java.lang
import java.math
import java.net
import java.nio
import java.nio.channels
import java.nio.charset
import java.nio.file
import java.util
import java.util.concurrent
import java.util.function
import jpype.protocol
import org.apache.commons.io
import typing



class ArgEncoding:
    @typing.overload
    @staticmethod
    def decode(boolean: bool, string: str) -> java.io.File: ...
    @typing.overload
    @staticmethod
    def decode(string: str) -> str: ...
    @staticmethod
    def encode(string: str) -> str: ...
    @staticmethod
    def requires(string: str) -> bool: ...

class CompositeInputStream(java.io.InputStream):
    @typing.overload
    def __init__(self, *inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, list: java.util.List[java.io.InputStream]): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...

class DeobfuscatingInputStream(java.io.FilterInputStream):
    def __init__(self, inputStream: java.io.InputStream): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...

class FastByteArrayOutputStream(java.io.ByteArrayOutputStream):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    def toByteArray(self) -> typing.List[int]: ...
    def toInputStream(self) -> java.io.InputStream: ...

class FileArchive(java.io.Closeable):
    @typing.overload
    def add(self, string: str, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def add(self, string: str, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def add(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def add(self, string: str, string2: str) -> None: ...
    def close(self) -> None: ...
    def contains(self, string: str) -> bool: ...
    def flush(self) -> None: ...
    def getCompressedSize(self, string: str) -> int: ...
    def getFile(self) -> java.io.File: ...
    @typing.overload
    def getFiles(self) -> java.util.List[str]: ...
    @typing.overload
    def getFiles(self, string: str) -> java.util.List[str]: ...
    def getInputStream(self, string: str) -> java.io.InputStream: ...
    def getMTime(self, string: str) -> int: ...
    def getName(self) -> str: ...
    def getOutputStream(self, string: str) -> java.io.OutputStream: ...
    def getSize(self, string: str) -> int: ...
    def isClosed(self) -> bool: ...
    def isModified(self) -> bool: ...
    def remove(self, string: str) -> bool: ...
    def revert(self) -> None: ...

class FileStore(java.io.Closeable):
    def close(self) -> None: ...
    def contains(self, string: str) -> bool: ...
    @typing.overload
    def getFiles(self) -> java.util.List[str]: ...
    @typing.overload
    def getFiles(self, string: str) -> java.util.List[str]: ...
    def getInputStream(self, string: str) -> java.io.InputStream: ...
    def getMTime(self, string: str) -> int: ...
    def getSize(self, string: str) -> int: ...
    def isClosed(self) -> bool: ...

class FileUtils:
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def byteCountToDisplaySize(bigInteger: java.math.BigInteger) -> str: ...
    @typing.overload
    @staticmethod
    def byteCountToDisplaySize(long: int) -> str: ...

class IOUtils(org.apache.commons.io.IOUtils):
    @typing.overload
    @staticmethod
    def closeQuietly(autoCloseable: java.lang.AutoCloseable) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(closeable: java.io.Closeable) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(closeable: java.io.Closeable, consumer: typing.Union[java.util.function.Consumer[java.io.IOException], typing.Callable[[java.io.IOException], None]]) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(*closeable: java.io.Closeable) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(outputStream: java.io.OutputStream) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(reader: java.io.Reader) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(writer: java.io.Writer) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(serverSocket: java.net.ServerSocket) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(socket: java.net.Socket) -> None: ...
    @typing.overload
    @staticmethod
    def closeQuietly(selector: java.nio.channels.Selector) -> None: ...
    @typing.overload
    @staticmethod
    def copy(fileInputStream: java.io.FileInputStream, fileOutputStream: java.io.FileOutputStream) -> int: ...
    @typing.overload
    @staticmethod
    def copy(inputStream: java.io.InputStream, outputStream: java.io.OutputStream, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def copy(inputStream: java.io.InputStream, outputStream: java.io.OutputStream) -> int: ...
    @typing.overload
    @staticmethod
    def copy(reader: java.io.Reader, writer: java.io.Writer) -> int: ...
    @typing.overload
    @staticmethod
    def copy(inputStream: java.io.InputStream, outputStream: java.io.OutputStream, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def copy(reader: java.io.Reader, appendable: java.lang.Appendable) -> int: ...
    @typing.overload
    @staticmethod
    def copy(reader: java.io.Reader, appendable: java.lang.Appendable, charBuffer: java.nio.CharBuffer) -> int: ...
    @typing.overload
    @staticmethod
    def copy(uRL: java.net.URL, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> int: ...
    @typing.overload
    @staticmethod
    def copy(uRL: java.net.URL, outputStream: java.io.OutputStream) -> int: ...
    @typing.overload
    @staticmethod
    def copy(inputStream: java.io.InputStream, writer: java.io.Writer) -> None: ...
    @typing.overload
    @staticmethod
    def copy(inputStream: java.io.InputStream, writer: java.io.Writer, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def copy(inputStream: java.io.InputStream, writer: java.io.Writer, charset: java.nio.charset.Charset) -> None: ...
    @typing.overload
    @staticmethod
    def copy(reader: java.io.Reader, outputStream: java.io.OutputStream) -> None: ...
    @typing.overload
    @staticmethod
    def copy(reader: java.io.Reader, outputStream: java.io.OutputStream, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def copy(reader: java.io.Reader, outputStream: java.io.OutputStream, charset: java.nio.charset.Charset) -> None: ...
    @typing.overload
    @staticmethod
    def copyLarge(fileInputStream: java.io.FileInputStream, fileOutputStream: java.io.FileOutputStream) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(inputStream: java.io.InputStream, outputStream: java.io.OutputStream) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(inputStream: java.io.InputStream, outputStream: java.io.OutputStream, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(inputStream: java.io.InputStream, outputStream: java.io.OutputStream, long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(inputStream: java.io.InputStream, outputStream: java.io.OutputStream, long: int, long2: int, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(reader: java.io.Reader, writer: java.io.Writer) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(reader: java.io.Reader, writer: java.io.Writer, charArray: typing.List[str]) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(reader: java.io.Reader, writer: java.io.Writer, long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def copyLarge(reader: java.io.Reader, writer: java.io.Writer, long: int, long2: int, charArray: typing.List[str]) -> int: ...

class InputStreamPump(java.lang.Runnable):
    def setInputStream(self, inputStream: java.io.InputStream) -> None: ...

class ObfuscatingOutputStream(java.io.FilterOutputStream):
    HEADER: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, byte: int): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...

class OutputStreamPump(java.lang.Runnable):
    def setOutputStream(self, outputStream: java.io.OutputStream) -> None: ...

class ProcessLauncher:
    def __init__(self): ...
    @typing.overload
    def launch(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], inputStreamPump: InputStreamPump, inputStreamPump2: InputStreamPump, *string: str) -> 'ProcessWrapper': ...
    @typing.overload
    def launch(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], outputStream: java.io.OutputStream, outputStream2: java.io.OutputStream, *string: str) -> 'ProcessWrapper': ...
    @typing.overload
    def launch(self, *string: str) -> 'ProcessWrapper': ...

class ProcessWrapper:
    future: java.util.concurrent.Future = ...
    stdout: java.io.InputStream = ...
    stderr: java.io.InputStream = ...
    stdin: java.io.OutputStream = ...

class RereadableInputStream(java.io.InputStream):
    def __init__(self, inputStream: java.io.InputStream): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    def reset(self) -> None: ...

class Tailer:
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], long: int): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], long: int, eventListenerSupport: VASSAL.tools.concurrent.listener.EventListenerSupport[str]): ...
    def addEventListener(self, eventListener: typing.Union[VASSAL.tools.concurrent.listener.EventListener[str], typing.Callable[[typing.Any, str], None]]) -> None: ...
    def getEventListeners(self) -> java.util.List[VASSAL.tools.concurrent.listener.EventListener[str]]: ...
    def getFile(self) -> java.io.File: ...
    def hasEventListeners(self) -> bool: ...
    def isTailing(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def removeEventListener(self, eventListener: typing.Union[VASSAL.tools.concurrent.listener.EventListener[str], typing.Callable[[typing.Any, str], None]]) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class TemporaryFileFactory:
    def create(self) -> java.io.File: ...

class ZipWriter(java.io.Closeable):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath]): ...
    def close(self) -> None: ...
    @typing.overload
    def write(self, string: str) -> java.io.OutputStream: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], string: str) -> None: ...
    @typing.overload
    def write(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str) -> None: ...
    @typing.overload
    def write(self, inputStream: java.io.InputStream, string: str) -> None: ...
    @typing.overload
    def write(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], string: str) -> None: ...

class InputOutputStreamPump(InputStreamPump, OutputStreamPump):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, eventListener: typing.Union[VASSAL.tools.concurrent.listener.EventListener[java.io.IOException], typing.Callable[[typing.Any, java.io.IOException], None]]): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, outputStream: java.io.OutputStream, eventListener: typing.Union[VASSAL.tools.concurrent.listener.EventListener[java.io.IOException], typing.Callable[[typing.Any, java.io.IOException], None]]): ...
    def run(self) -> None: ...
    def setInputStream(self, inputStream: java.io.InputStream) -> None: ...
    def setOutputStream(self, outputStream: java.io.OutputStream) -> None: ...

class ZipArchive(FileArchive):
    @typing.overload
    def __init__(self, fileArchive: FileArchive, file2: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, fileArchive: FileArchive, string: str): ...
    @typing.overload
    def __init__(self, fileArchive: FileArchive, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], boolean: bool): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, boolean: bool): ...
    @typing.overload
    def __init__(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], boolean: bool): ...
    @typing.overload
    def add(self, string: str, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def add(self, string: str, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def add(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def add(self, string: str, string2: str) -> None: ...
    def close(self) -> None: ...
    def contains(self, string: str) -> bool: ...
    def flush(self) -> None: ...
    def getCompressedSize(self, string: str) -> int: ...
    def getFile(self) -> java.io.File: ...
    @typing.overload
    def getFiles(self) -> java.util.List[str]: ...
    @typing.overload
    def getFiles(self, string: str) -> java.util.List[str]: ...
    def getInputStream(self, string: str) -> java.io.InputStream: ...
    def getMTime(self, string: str) -> int: ...
    def getName(self) -> str: ...
    @typing.overload
    def getOutputStream(self, string: str) -> java.io.OutputStream: ...
    @typing.overload
    def getOutputStream(self, string: str, boolean: bool) -> java.io.OutputStream: ...
    def getPath(self) -> java.nio.file.Path: ...
    def getSize(self, string: str) -> int: ...
    def isClosed(self) -> bool: ...
    def isModified(self) -> bool: ...
    def remove(self, string: str) -> bool: ...
    def revert(self) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.io")``.

    ArgEncoding: typing.Type[ArgEncoding]
    CompositeInputStream: typing.Type[CompositeInputStream]
    DeobfuscatingInputStream: typing.Type[DeobfuscatingInputStream]
    FastByteArrayOutputStream: typing.Type[FastByteArrayOutputStream]
    FileArchive: typing.Type[FileArchive]
    FileStore: typing.Type[FileStore]
    FileUtils: typing.Type[FileUtils]
    IOUtils: typing.Type[IOUtils]
    InputOutputStreamPump: typing.Type[InputOutputStreamPump]
    InputStreamPump: typing.Type[InputStreamPump]
    ObfuscatingOutputStream: typing.Type[ObfuscatingOutputStream]
    OutputStreamPump: typing.Type[OutputStreamPump]
    ProcessLauncher: typing.Type[ProcessLauncher]
    ProcessWrapper: typing.Type[ProcessWrapper]
    RereadableInputStream: typing.Type[RereadableInputStream]
    Tailer: typing.Type[Tailer]
    TemporaryFileFactory: typing.Type[TemporaryFileFactory]
    ZipArchive: typing.Type[ZipArchive]
    ZipWriter: typing.Type[ZipWriter]
