import ch.qos.logback.classic.pattern
import ch.qos.logback.classic.spi
import java.io
import java.lang
import java.util.concurrent
import javax.swing
import jpype.protocol
import org.slf4j
import typing



class LogEntry(java.io.Serializable):
    MESSAGE: typing.ClassVar[int] = ...
    WARNING: typing.ClassVar[int] = ...
    ERROR: typing.ClassVar[int] = ...
    BUG: typing.ClassVar[int] = ...
    DEBUG: typing.ClassVar[int] = ...
    SYSTEM: typing.ClassVar[int] = ...
    timestamp: int = ...
    type: int = ...
    message: str = ...
    trace: str = ...
    wait: bool = ...
    @typing.overload
    def __init__(self, int: int, throwable: java.lang.Throwable, string: str, boolean: bool): ...
    @typing.overload
    def __init__(self, long: int, int: int, throwable: java.lang.Throwable, string: str, boolean: bool): ...
    def toString(self) -> str: ...

class LogListener:
    def handle(self, logEntry: LogEntry) -> None: ...

class LogPane(javax.swing.JTextArea):
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...

class LoggedOutputStream(java.io.OutputStream):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, logger: org.slf4j.Logger): ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...

class Logger:
    MESSAGE: typing.ClassVar[int] = ...
    WARNING: typing.ClassVar[int] = ...
    ERROR: typing.ClassVar[int] = ...
    BUG: typing.ClassVar[int] = ...
    DEBUG: typing.ClassVar[int] = ...
    SYSTEM: typing.ClassVar[int] = ...
    @staticmethod
    def addLogListener(logListener: typing.Union[LogListener, typing.Callable]) -> None: ...
    @staticmethod
    def enqueue(logEntry: LogEntry) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def getLogListeners() -> typing.List[LogListener]: ...
    @typing.overload
    @staticmethod
    def log(string: str) -> None: ...
    @typing.overload
    @staticmethod
    def log(string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    @staticmethod
    def log(throwable: java.lang.Throwable, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(throwable: java.lang.Throwable, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def log(throwable: java.lang.Throwable, string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def logAndWait(string: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def logAndWait(string: str, int: int) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def logAndWait(throwable: java.lang.Throwable) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def logAndWait(throwable: java.lang.Throwable, int: int) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def logAndWait(throwable: java.lang.Throwable, string: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def logAndWait(throwable: java.lang.Throwable, string: str, int: int) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def removeLogListener(logListener: typing.Union[LogListener, typing.Callable]) -> None: ...

class ProcessIDConverter(ch.qos.logback.classic.pattern.ClassicConverter):
    def __init__(self): ...
    def convert(self, iLoggingEvent: ch.qos.logback.classic.spi.ILoggingEvent) -> str: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.logging")``.

    LogEntry: typing.Type[LogEntry]
    LogListener: typing.Type[LogListener]
    LogPane: typing.Type[LogPane]
    LoggedOutputStream: typing.Type[LoggedOutputStream]
    Logger: typing.Type[Logger]
    ProcessIDConverter: typing.Type[ProcessIDConverter]
