"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from orq_poc_python_client.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from orq_poc_python_client.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class UsageTypedDict(TypedDict):
    r"""Usage statistics to add to the deployment"""

    prompt_tokens: float
    r"""Number of tokens in the prompt."""
    completion_tokens: float
    r"""Number of tokens in the generated completion."""
    total_tokens: NotRequired[float]
    r"""Total number of tokens used in the request (prompt + completion)."""


class Usage(BaseModel):
    r"""Usage statistics to add to the deployment"""

    prompt_tokens: float
    r"""Number of tokens in the prompt."""

    completion_tokens: float
    r"""Number of tokens in the generated completion."""

    total_tokens: Optional[float] = None
    r"""Total number of tokens used in the request (prompt + completion)."""


class PerformanceTypedDict(TypedDict):
    latency: float
    r"""Total time in milliseconds of the request to the LLM provider API."""
    time_to_first_token: NotRequired[float]
    r"""Total time in milliseconds to generate the first token of the completion."""


class Performance(BaseModel):
    latency: float
    r"""Total time in milliseconds of the request to the LLM provider API."""

    time_to_first_token: Optional[float] = None
    r"""Total time in milliseconds to generate the first token of the completion."""


class PostV2DeploymentsIDMetricsRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class PostV2DeploymentsIDMetrics2DeploymentsType(str, Enum):
    IMAGE_URL = "image_url"


class PostV2DeploymentsIDMetrics2ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class PostV2DeploymentsIDMetrics2ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class PostV2DeploymentsIDMetrics22TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: PostV2DeploymentsIDMetrics2DeploymentsType
    image_url: PostV2DeploymentsIDMetrics2ImageURLTypedDict


class PostV2DeploymentsIDMetrics22(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: PostV2DeploymentsIDMetrics2DeploymentsType

    image_url: PostV2DeploymentsIDMetrics2ImageURL


class PostV2DeploymentsIDMetrics2Type(str, Enum):
    TEXT = "text"


class PostV2DeploymentsIDMetrics21TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: PostV2DeploymentsIDMetrics2Type
    text: str


class PostV2DeploymentsIDMetrics21(BaseModel):
    r"""Text content part of a prompt message"""

    type: PostV2DeploymentsIDMetrics2Type

    text: str


PostV2DeploymentsIDMetricsContent2TypedDict = Union[
    PostV2DeploymentsIDMetrics21TypedDict, PostV2DeploymentsIDMetrics22TypedDict
]


PostV2DeploymentsIDMetricsContent2 = Union[
    PostV2DeploymentsIDMetrics21, PostV2DeploymentsIDMetrics22
]


PostV2DeploymentsIDMetricsContentTypedDict = Union[
    str, List[PostV2DeploymentsIDMetricsContent2TypedDict]
]
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


PostV2DeploymentsIDMetricsContent = Union[str, List[PostV2DeploymentsIDMetricsContent2]]
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


class PostV2DeploymentsIDMetricsType(str, Enum):
    FUNCTION = "function"


class PostV2DeploymentsIDMetricsFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class PostV2DeploymentsIDMetricsFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class PostV2DeploymentsIDMetricsToolCallsTypedDict(TypedDict):
    type: PostV2DeploymentsIDMetricsType
    function: PostV2DeploymentsIDMetricsFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class PostV2DeploymentsIDMetricsToolCalls(BaseModel):
    type: PostV2DeploymentsIDMetricsType

    function: PostV2DeploymentsIDMetricsFunction

    id: Optional[str] = None

    index: Optional[float] = None


class PostV2DeploymentsIDMetricsMessagesTypedDict(TypedDict):
    role: PostV2DeploymentsIDMetricsRole
    r"""The role of the prompt message"""
    content: PostV2DeploymentsIDMetricsContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[PostV2DeploymentsIDMetricsToolCallsTypedDict]]


class PostV2DeploymentsIDMetricsMessages(BaseModel):
    role: PostV2DeploymentsIDMetricsRole
    r"""The role of the prompt message"""

    content: PostV2DeploymentsIDMetricsContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[PostV2DeploymentsIDMetricsToolCalls]] = None


class PostV2DeploymentsIDMetricsMessageDeploymentsRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class ThreeTypedDict(TypedDict):
    role: PostV2DeploymentsIDMetricsMessageDeploymentsRole
    r"""The role of the prompt message"""
    url: str


class Three(BaseModel):
    role: PostV2DeploymentsIDMetricsMessageDeploymentsRole
    r"""The role of the prompt message"""

    url: str


class PostV2DeploymentsIDMetricsMessageRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class Message2TypedDict(TypedDict):
    role: PostV2DeploymentsIDMetricsMessageRole
    r"""The role of the prompt message"""
    content: Nullable[str]


class Message2(BaseModel):
    role: PostV2DeploymentsIDMetricsMessageRole
    r"""The role of the prompt message"""

    content: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class MessageRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class MessageType(str, Enum):
    FUNCTION = "function"


class MessageFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class MessageFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class MessageToolCallsTypedDict(TypedDict):
    type: MessageType
    function: MessageFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class MessageToolCalls(BaseModel):
    type: MessageType

    function: MessageFunction

    id: Optional[str] = None

    index: Optional[float] = None


class Message1TypedDict(TypedDict):
    role: MessageRole
    r"""The role of the prompt message"""
    tool_calls: List[MessageToolCallsTypedDict]
    content: NotRequired[Nullable[str]]


class Message1(BaseModel):
    role: MessageRole
    r"""The role of the prompt message"""

    tool_calls: List[MessageToolCalls]

    content: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content"]
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


MessageTypedDict = Union[Message2TypedDict, ThreeTypedDict, Message1TypedDict]


Message = Union[Message2, Three, Message1]


class ChoicesTypedDict(TypedDict):
    index: float
    message: NotRequired[MessageTypedDict]
    finish_reason: NotRequired[Nullable[str]]


class Choices(BaseModel):
    index: float

    message: Optional[Message] = None

    finish_reason: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["message", "finish_reason"]
        nullable_fields = ["finish_reason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2DeploymentsIDMetricsFeedbackTypedDict(TypedDict):
    r"""Feedback from the user on the completion"""

    score: int
    r"""The feedback score. This allow you to come with specific logic on what a `score` number means"""


class PostV2DeploymentsIDMetricsFeedback(BaseModel):
    r"""Feedback from the user on the completion"""

    score: int
    r"""The feedback score. This allow you to come with specific logic on what a `score` number means"""


class PostV2DeploymentsIDMetricsRequestBodyTypedDict(TypedDict):
    r"""The deployment request payload"""

    metadata: NotRequired[Dict[str, Any]]
    r"""Your own custom key-value pairs can be attached to the logs. This is useful for storing additional information related to your interactions with the LLM providers or specifics within your application."""
    usage: NotRequired[UsageTypedDict]
    r"""Usage statistics to add to the deployment"""
    performance: NotRequired[PerformanceTypedDict]
    messages: NotRequired[List[PostV2DeploymentsIDMetricsMessagesTypedDict]]
    r"""A list of messages sent to the model."""
    choices: NotRequired[List[ChoicesTypedDict]]
    r"""A list of completion choices. If you are using a `completion` model then you must provide the `completion content` with the chat completion format"""
    feedback: NotRequired[PostV2DeploymentsIDMetricsFeedbackTypedDict]
    r"""Feedback from the user on the completion"""


class PostV2DeploymentsIDMetricsRequestBody(BaseModel):
    r"""The deployment request payload"""

    metadata: Optional[Dict[str, Any]] = None
    r"""Your own custom key-value pairs can be attached to the logs. This is useful for storing additional information related to your interactions with the LLM providers or specifics within your application."""

    usage: Optional[Usage] = None
    r"""Usage statistics to add to the deployment"""

    performance: Optional[Performance] = None

    messages: Optional[List[PostV2DeploymentsIDMetricsMessages]] = None
    r"""A list of messages sent to the model."""

    choices: Optional[List[Choices]] = None
    r"""A list of completion choices. If you are using a `completion` model then you must provide the `completion content` with the chat completion format"""

    feedback: Optional[PostV2DeploymentsIDMetricsFeedback] = None
    r"""Feedback from the user on the completion"""


class PostV2DeploymentsIDMetricsRequestTypedDict(TypedDict):
    id: str
    r"""Deployment ID"""
    request_body: PostV2DeploymentsIDMetricsRequestBodyTypedDict
    r"""The deployment request payload"""


class PostV2DeploymentsIDMetricsRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Deployment ID"""

    request_body: Annotated[
        PostV2DeploymentsIDMetricsRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""The deployment request payload"""


class PostV2DeploymentsIDMetricsResponseBodyTypedDict(TypedDict):
    r"""Successful operation"""

    code: float
    r"""The status code of the request"""
    success: bool
    r"""Whether the request was successful"""


class PostV2DeploymentsIDMetricsResponseBody(BaseModel):
    r"""Successful operation"""

    code: float
    r"""The status code of the request"""

    success: bool
    r"""Whether the request was successful"""
