"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from orq_poc_python_client.types import BaseModel
from typing import Dict, List, Optional, Union
from typing_extensions import NotRequired, TypedDict


DocumentsTypedDict = Union[str, Dict[str, str]]


Documents = Union[str, Dict[str, str]]


class PostV2RouterRerankRequestBodyTypedDict(TypedDict):
    r"""A request body that follows the official OpenAI schema"""

    query: str
    r"""The search query"""
    documents: List[DocumentsTypedDict]
    r"""A list of document objects or strings to rerank."""
    model: str
    r"""The identifier of the model to use"""
    top_n: NotRequired[float]
    r"""The number of most relevant documents or indices to return, defaults to the length of the documents"""
    return_documents: NotRequired[bool]
    r"""Returns the docs with or without the doc text passed in"""


class PostV2RouterRerankRequestBody(BaseModel):
    r"""A request body that follows the official OpenAI schema"""

    query: str
    r"""The search query"""

    documents: List[Documents]
    r"""A list of document objects or strings to rerank."""

    model: str
    r"""The identifier of the model to use"""

    top_n: Optional[float] = None
    r"""The number of most relevant documents or indices to return, defaults to the length of the documents"""

    return_documents: Optional[bool] = None
    r"""Returns the docs with or without the doc text passed in"""


class DocumentTypedDict(TypedDict):
    r"""If return_documents is set as false this will return none, if true it will return the documents passed in"""

    text: str
    r"""The text of the document to rerank"""


class Document(BaseModel):
    r"""If return_documents is set as false this will return none, if true it will return the documents passed in"""

    text: str
    r"""The text of the document to rerank"""


class ResultsTypedDict(TypedDict):
    index: float
    r"""Corresponds to the index in the original list of documents to which the ranked document belongs."""
    relevance_score: float
    r"""Relevance scores are normalized to be in the range [0, 1]. Scores close to 1 indicate a high relevance to the query, and scores closer to 0 indicate low relevance."""
    document: NotRequired[DocumentTypedDict]
    r"""If return_documents is set as false this will return none, if true it will return the documents passed in"""


class Results(BaseModel):
    index: float
    r"""Corresponds to the index in the original list of documents to which the ranked document belongs."""

    relevance_score: float
    r"""Relevance scores are normalized to be in the range [0, 1]. Scores close to 1 indicate a high relevance to the query, and scores closer to 0 indicate low relevance."""

    document: Optional[Document] = None
    r"""If return_documents is set as false this will return none, if true it will return the documents passed in"""


class APIVersionTypedDict(TypedDict):
    version: str
    is_deprecated: NotRequired[bool]
    is_experimental: NotRequired[bool]


class APIVersion(BaseModel):
    version: str

    is_deprecated: Optional[bool] = None

    is_experimental: Optional[bool] = None


class BilledUnitsTypedDict(TypedDict):
    input_tokens: NotRequired[float]
    r"""The number of billed input tokens."""
    output_tokens: NotRequired[float]
    r"""The number of billed output tokens."""
    search_units: NotRequired[float]
    r"""The number of billed search units."""
    classifications: NotRequired[float]
    r"""The number of billed classifications units."""


class BilledUnits(BaseModel):
    input_tokens: Optional[float] = None
    r"""The number of billed input tokens."""

    output_tokens: Optional[float] = None
    r"""The number of billed output tokens."""

    search_units: Optional[float] = None
    r"""The number of billed search units."""

    classifications: Optional[float] = None
    r"""The number of billed classifications units."""


class TokensTypedDict(TypedDict):
    input_tokens: NotRequired[float]
    r"""The number of tokens used as input to the model."""
    output_tokens: NotRequired[float]
    r"""The number of tokens produced by the model."""


class Tokens(BaseModel):
    input_tokens: Optional[float] = None
    r"""The number of tokens used as input to the model."""

    output_tokens: Optional[float] = None
    r"""The number of tokens produced by the model."""


class MetaTypedDict(TypedDict):
    r"""Some information about the response"""

    api_version: NotRequired[APIVersionTypedDict]
    billed_units: NotRequired[BilledUnitsTypedDict]
    tokens: NotRequired[TokensTypedDict]
    warnings: NotRequired[List[str]]


class Meta(BaseModel):
    r"""Some information about the response"""

    api_version: Optional[APIVersion] = None

    billed_units: Optional[BilledUnits] = None

    tokens: Optional[Tokens] = None

    warnings: Optional[List[str]] = None


class PostV2RouterRerankResponseBodyTypedDict(TypedDict):
    r"""A response body that follows the official OpenAI schema"""

    results: List[ResultsTypedDict]
    r"""An ordered list of ranked documents"""
    id: NotRequired[str]
    r"""A unique identifier for the rerank."""
    meta: NotRequired[MetaTypedDict]
    r"""Some information about the response"""


class PostV2RouterRerankResponseBody(BaseModel):
    r"""A response body that follows the official OpenAI schema"""

    results: List[Results]
    r"""An ordered list of ranked documents"""

    id: Optional[str] = None
    r"""A unique identifier for the rerank."""

    meta: Optional[Meta] = None
    r"""Some information about the response"""
