# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0
#
# This code was automatically generated across versions from 11.0.3 to 12.8.0. Do not modify it directly.

from ..cycusolverDn cimport *


###############################################################################
# Wrapper functions
###############################################################################

cdef cusolverStatus_t _cusolverDnCreate(cusolverDnHandle_t* handle) except* nogil
cdef cusolverStatus_t _cusolverDnDestroy(cusolverDnHandle_t handle) except* nogil
cdef cusolverStatus_t _cusolverDnSetStream(cusolverDnHandle_t handle, cudaStream_t streamId) except* nogil
cdef cusolverStatus_t _cusolverDnGetStream(cusolverDnHandle_t handle, cudaStream_t* streamId) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsCreate(cusolverDnIRSParams_t* params_ptr) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsDestroy(cusolverDnIRSParams_t params) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetRefinementSolver(cusolverDnIRSParams_t params, cusolverIRSRefinement_t refinement_solver) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetSolverMainPrecision(cusolverDnIRSParams_t params, cusolverPrecType_t solver_main_precision) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetSolverLowestPrecision(cusolverDnIRSParams_t params, cusolverPrecType_t solver_lowest_precision) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetSolverPrecisions(cusolverDnIRSParams_t params, cusolverPrecType_t solver_main_precision, cusolverPrecType_t solver_lowest_precision) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetTol(cusolverDnIRSParams_t params, double val) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetTolInner(cusolverDnIRSParams_t params, double val) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetMaxIters(cusolverDnIRSParams_t params, cusolver_int_t maxiters) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsSetMaxItersInner(cusolverDnIRSParams_t params, cusolver_int_t maxiters_inner) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsGetMaxIters(cusolverDnIRSParams_t params, cusolver_int_t* maxiters) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsEnableFallback(cusolverDnIRSParams_t params) except* nogil
cdef cusolverStatus_t _cusolverDnIRSParamsDisableFallback(cusolverDnIRSParams_t params) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosDestroy(cusolverDnIRSInfos_t infos) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosCreate(cusolverDnIRSInfos_t* infos_ptr) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosGetNiters(cusolverDnIRSInfos_t infos, cusolver_int_t* niters) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosGetOuterNiters(cusolverDnIRSInfos_t infos, cusolver_int_t* outer_niters) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosRequestResidual(cusolverDnIRSInfos_t infos) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosGetResidualHistory(cusolverDnIRSInfos_t infos, void** residual_history) except* nogil
cdef cusolverStatus_t _cusolverDnIRSInfosGetMaxIters(cusolverDnIRSInfos_t infos, cusolver_int_t* maxiters) except* nogil
cdef cusolverStatus_t _cusolverDnZZgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZCgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZKgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZEgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZYgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCCgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCEgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCKgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCYgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDDgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDSgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDHgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDBgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDXgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSSgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSHgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSBgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSXgesv(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZZgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZCgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZKgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZEgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZYgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCCgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCKgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCEgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCYgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDDgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDSgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDHgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDBgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDXgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSSgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSHgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSBgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSXgesv_bufferSize(cusolverDnHandle_t handle, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, cusolver_int_t* dipiv, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZZgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZCgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZKgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZEgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZYgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCCgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCKgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCEgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnCYgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDDgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDSgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDHgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDBgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnDXgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSSgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSHgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSBgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnSXgels(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* iter, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnZZgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZCgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZKgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZEgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnZYgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuDoubleComplex* dA, cusolver_int_t ldda, cuDoubleComplex* dB, cusolver_int_t lddb, cuDoubleComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCCgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCKgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCEgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnCYgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, cuComplex* dA, cusolver_int_t ldda, cuComplex* dB, cusolver_int_t lddb, cuComplex* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDDgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDSgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDHgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDBgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnDXgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, double* dA, cusolver_int_t ldda, double* dB, cusolver_int_t lddb, double* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSSgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSHgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSBgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSXgels_bufferSize(cusolverDnHandle_t handle, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, float* dA, cusolver_int_t ldda, float* dB, cusolver_int_t lddb, float* dX, cusolver_int_t lddx, void* dWorkspace, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnIRSXgesv(cusolverDnHandle_t handle, cusolverDnIRSParams_t gesv_irs_params, cusolverDnIRSInfos_t gesv_irs_infos, cusolver_int_t n, cusolver_int_t nrhs, void* dA, cusolver_int_t ldda, void* dB, cusolver_int_t lddb, void* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* niters, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnIRSXgesv_bufferSize(cusolverDnHandle_t handle, cusolverDnIRSParams_t params, cusolver_int_t n, cusolver_int_t nrhs, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnIRSXgels(cusolverDnHandle_t handle, cusolverDnIRSParams_t gels_irs_params, cusolverDnIRSInfos_t gels_irs_infos, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, void* dA, cusolver_int_t ldda, void* dB, cusolver_int_t lddb, void* dX, cusolver_int_t lddx, void* dWorkspace, size_t lwork_bytes, cusolver_int_t* niters, cusolver_int_t* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnIRSXgels_bufferSize(cusolverDnHandle_t handle, cusolverDnIRSParams_t params, cusolver_int_t m, cusolver_int_t n, cusolver_int_t nrhs, size_t* lwork_bytes) except* nogil
cdef cusolverStatus_t _cusolverDnSpotrf_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDpotrf_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCpotrf_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZpotrf_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSpotrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, float* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDpotrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, double* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCpotrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, cuComplex* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZpotrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSpotrs(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, const float* A, int lda, float* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDpotrs(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, const double* A, int lda, double* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCpotrs(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, const cuComplex* A, int lda, cuComplex* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZpotrs(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, const cuDoubleComplex* A, int lda, cuDoubleComplex* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSpotrfBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* Aarray[], int lda, int* infoArray, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDpotrfBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* Aarray[], int lda, int* infoArray, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCpotrfBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* Aarray[], int lda, int* infoArray, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZpotrfBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* Aarray[], int lda, int* infoArray, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSpotrsBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, float* A[], int lda, float* B[], int ldb, int* d_info, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDpotrsBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, double* A[], int lda, double* B[], int ldb, int* d_info, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCpotrsBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, cuComplex* A[], int lda, cuComplex* B[], int ldb, int* d_info, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZpotrsBatched(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, int nrhs, cuDoubleComplex* A[], int lda, cuDoubleComplex* B[], int ldb, int* d_info, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSpotri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDpotri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCpotri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZpotri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSpotri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, float* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDpotri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, double* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCpotri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, cuComplex* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZpotri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSlauum_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDlauum_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnClauum_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZlauum_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSlauum(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, float* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDlauum(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, double* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnClauum(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, cuComplex* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZlauum(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSgetrf_bufferSize(cusolverDnHandle_t handle, int m, int n, float* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDgetrf_bufferSize(cusolverDnHandle_t handle, int m, int n, double* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCgetrf_bufferSize(cusolverDnHandle_t handle, int m, int n, cuComplex* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZgetrf_bufferSize(cusolverDnHandle_t handle, int m, int n, cuDoubleComplex* A, int lda, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSgetrf(cusolverDnHandle_t handle, int m, int n, float* A, int lda, float* Workspace, int* devIpiv, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDgetrf(cusolverDnHandle_t handle, int m, int n, double* A, int lda, double* Workspace, int* devIpiv, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCgetrf(cusolverDnHandle_t handle, int m, int n, cuComplex* A, int lda, cuComplex* Workspace, int* devIpiv, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZgetrf(cusolverDnHandle_t handle, int m, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* Workspace, int* devIpiv, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSlaswp(cusolverDnHandle_t handle, int n, float* A, int lda, int k1, int k2, const int* devIpiv, int incx) except* nogil
cdef cusolverStatus_t _cusolverDnDlaswp(cusolverDnHandle_t handle, int n, double* A, int lda, int k1, int k2, const int* devIpiv, int incx) except* nogil
cdef cusolverStatus_t _cusolverDnClaswp(cusolverDnHandle_t handle, int n, cuComplex* A, int lda, int k1, int k2, const int* devIpiv, int incx) except* nogil
cdef cusolverStatus_t _cusolverDnZlaswp(cusolverDnHandle_t handle, int n, cuDoubleComplex* A, int lda, int k1, int k2, const int* devIpiv, int incx) except* nogil
cdef cusolverStatus_t _cusolverDnSgetrs(cusolverDnHandle_t handle, cublasOperation_t trans, int n, int nrhs, const float* A, int lda, const int* devIpiv, float* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDgetrs(cusolverDnHandle_t handle, cublasOperation_t trans, int n, int nrhs, const double* A, int lda, const int* devIpiv, double* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCgetrs(cusolverDnHandle_t handle, cublasOperation_t trans, int n, int nrhs, const cuComplex* A, int lda, const int* devIpiv, cuComplex* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZgetrs(cusolverDnHandle_t handle, cublasOperation_t trans, int n, int nrhs, const cuDoubleComplex* A, int lda, const int* devIpiv, cuDoubleComplex* B, int ldb, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSgeqrf_bufferSize(cusolverDnHandle_t handle, int m, int n, float* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDgeqrf_bufferSize(cusolverDnHandle_t handle, int m, int n, double* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCgeqrf_bufferSize(cusolverDnHandle_t handle, int m, int n, cuComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZgeqrf_bufferSize(cusolverDnHandle_t handle, int m, int n, cuDoubleComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSgeqrf(cusolverDnHandle_t handle, int m, int n, float* A, int lda, float* TAU, float* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDgeqrf(cusolverDnHandle_t handle, int m, int n, double* A, int lda, double* TAU, double* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCgeqrf(cusolverDnHandle_t handle, int m, int n, cuComplex* A, int lda, cuComplex* TAU, cuComplex* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZgeqrf(cusolverDnHandle_t handle, int m, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* TAU, cuDoubleComplex* Workspace, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSorgqr_bufferSize(cusolverDnHandle_t handle, int m, int n, int k, const float* A, int lda, const float* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDorgqr_bufferSize(cusolverDnHandle_t handle, int m, int n, int k, const double* A, int lda, const double* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCungqr_bufferSize(cusolverDnHandle_t handle, int m, int n, int k, const cuComplex* A, int lda, const cuComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZungqr_bufferSize(cusolverDnHandle_t handle, int m, int n, int k, const cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSorgqr(cusolverDnHandle_t handle, int m, int n, int k, float* A, int lda, const float* tau, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDorgqr(cusolverDnHandle_t handle, int m, int n, int k, double* A, int lda, const double* tau, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCungqr(cusolverDnHandle_t handle, int m, int n, int k, cuComplex* A, int lda, const cuComplex* tau, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZungqr(cusolverDnHandle_t handle, int m, int n, int k, cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSormqr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const float* A, int lda, const float* tau, const float* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDormqr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const double* A, int lda, const double* tau, const double* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCunmqr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const cuComplex* A, int lda, const cuComplex* tau, const cuComplex* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZunmqr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, const cuDoubleComplex* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSormqr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const float* A, int lda, const float* tau, float* C, int ldc, float* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDormqr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const double* A, int lda, const double* tau, double* C, int ldc, double* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCunmqr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const cuComplex* A, int lda, const cuComplex* tau, cuComplex* C, int ldc, cuComplex* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZunmqr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasOperation_t trans, int m, int n, int k, const cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, cuDoubleComplex* C, int ldc, cuDoubleComplex* work, int lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSsytrf_bufferSize(cusolverDnHandle_t handle, int n, float* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsytrf_bufferSize(cusolverDnHandle_t handle, int n, double* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCsytrf_bufferSize(cusolverDnHandle_t handle, int n, cuComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZsytrf_bufferSize(cusolverDnHandle_t handle, int n, cuDoubleComplex* A, int lda, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsytrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, int* ipiv, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsytrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, int* ipiv, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCsytrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, int* ipiv, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZsytrf(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, int* ipiv, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSsytri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, const int* ipiv, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsytri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, const int* ipiv, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCsytri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, const int* ipiv, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZsytri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, const int* ipiv, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsytri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, const int* ipiv, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsytri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, const int* ipiv, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCsytri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, const int* ipiv, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZsytri(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, const int* ipiv, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSgebrd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDgebrd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCgebrd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZgebrd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* Lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSgebrd(cusolverDnHandle_t handle, int m, int n, float* A, int lda, float* D, float* E, float* TAUQ, float* TAUP, float* Work, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnDgebrd(cusolverDnHandle_t handle, int m, int n, double* A, int lda, double* D, double* E, double* TAUQ, double* TAUP, double* Work, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnCgebrd(cusolverDnHandle_t handle, int m, int n, cuComplex* A, int lda, float* D, float* E, cuComplex* TAUQ, cuComplex* TAUP, cuComplex* Work, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnZgebrd(cusolverDnHandle_t handle, int m, int n, cuDoubleComplex* A, int lda, double* D, double* E, cuDoubleComplex* TAUQ, cuDoubleComplex* TAUP, cuDoubleComplex* Work, int Lwork, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnSorgbr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, const float* A, int lda, const float* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDorgbr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, const double* A, int lda, const double* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCungbr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, const cuComplex* A, int lda, const cuComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZungbr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, const cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSorgbr(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, float* A, int lda, const float* tau, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDorgbr(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, double* A, int lda, const double* tau, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCungbr(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, cuComplex* A, int lda, const cuComplex* tau, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZungbr(cusolverDnHandle_t handle, cublasSideMode_t side, int m, int n, int k, cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSsytrd_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const float* A, int lda, const float* d, const float* e, const float* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsytrd_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const double* A, int lda, const double* d, const double* e, const double* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnChetrd_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const float* d, const float* e, const cuComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZhetrd_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const double* d, const double* e, const cuDoubleComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsytrd(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, float* d, float* e, float* tau, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsytrd(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, double* d, double* e, double* tau, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnChetrd(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, float* d, float* e, cuComplex* tau, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZhetrd(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, double* d, double* e, cuDoubleComplex* tau, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSorgtr_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const float* A, int lda, const float* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDorgtr_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const double* A, int lda, const double* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCungtr_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const cuComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZungtr_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSorgtr(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, float* A, int lda, const float* tau, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDorgtr(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, double* A, int lda, const double* tau, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCungtr(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuComplex* A, int lda, const cuComplex* tau, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZungtr(cusolverDnHandle_t handle, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSormtr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, const float* A, int lda, const float* tau, const float* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDormtr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, const double* A, int lda, const double* tau, const double* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCunmtr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, const cuComplex* A, int lda, const cuComplex* tau, const cuComplex* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZunmtr_bufferSize(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, const cuDoubleComplex* A, int lda, const cuDoubleComplex* tau, const cuDoubleComplex* C, int ldc, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSormtr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, float* A, int lda, float* tau, float* C, int ldc, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDormtr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, double* A, int lda, double* tau, double* C, int ldc, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCunmtr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, cuComplex* A, int lda, cuComplex* tau, cuComplex* C, int ldc, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZunmtr(cusolverDnHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, int m, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* tau, cuDoubleComplex* C, int ldc, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvd_bufferSize(cusolverDnHandle_t handle, int m, int n, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvd(cusolverDnHandle_t handle, signed char jobu, signed char jobvt, int m, int n, float* A, int lda, float* S, float* U, int ldu, float* VT, int ldvt, float* work, int lwork, float* rwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvd(cusolverDnHandle_t handle, signed char jobu, signed char jobvt, int m, int n, double* A, int lda, double* S, double* U, int ldu, double* VT, int ldvt, double* work, int lwork, double* rwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvd(cusolverDnHandle_t handle, signed char jobu, signed char jobvt, int m, int n, cuComplex* A, int lda, float* S, cuComplex* U, int ldu, cuComplex* VT, int ldvt, cuComplex* work, int lwork, float* rwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvd(cusolverDnHandle_t handle, signed char jobu, signed char jobvt, int m, int n, cuDoubleComplex* A, int lda, double* S, cuDoubleComplex* U, int ldu, cuDoubleComplex* VT, int ldvt, cuDoubleComplex* work, int lwork, double* rwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevd_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const float* A, int lda, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevd_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const double* A, int lda, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCheevd_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZheevd_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevd(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, float* A, int lda, float* W, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevd(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, double* A, int lda, double* W, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCheevd(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuComplex* A, int lda, float* W, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZheevd(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, double* W, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevdx_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const float* A, int lda, float vl, float vu, int il, int iu, int* meig, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevdx_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const double* A, int lda, double vl, double vu, int il, int iu, int* meig, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnCheevdx_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, float vl, float vu, int il, int iu, int* meig, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZheevdx_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, double vl, double vu, int il, int iu, int* meig, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevdx(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, float* A, int lda, float vl, float vu, int il, int iu, int* meig, float* W, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevdx(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, double* A, int lda, double vl, double vu, int il, int iu, int* meig, double* W, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCheevdx(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, cuComplex* A, int lda, float vl, float vu, int il, int iu, int* meig, float* W, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZheevdx(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, double vl, double vu, int il, int iu, int* meig, double* W, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSsygvdx_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const float* A, int lda, const float* B, int ldb, float vl, float vu, int il, int iu, int* meig, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsygvdx_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const double* A, int lda, const double* B, int ldb, double vl, double vu, int il, int iu, int* meig, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnChegvdx_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const cuComplex* B, int ldb, float vl, float vu, int il, int iu, int* meig, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZhegvdx_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, double vl, double vu, int il, int iu, int* meig, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsygvdx(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, float* A, int lda, float* B, int ldb, float vl, float vu, int il, int iu, int* meig, float* W, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsygvdx(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, double* A, int lda, double* B, int ldb, double vl, double vu, int il, int iu, int* meig, double* W, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnChegvdx(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, cuComplex* A, int lda, cuComplex* B, int ldb, float vl, float vu, int il, int iu, int* meig, float* W, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZhegvdx(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* B, int ldb, double vl, double vu, int il, int iu, int* meig, double* W, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnSsygvd_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const float* A, int lda, const float* B, int ldb, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnDsygvd_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const double* A, int lda, const double* B, int ldb, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnChegvd_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const cuComplex* B, int ldb, const float* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnZhegvd_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const double* W, int* lwork) except* nogil
cdef cusolverStatus_t _cusolverDnSsygvd(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, float* A, int lda, float* B, int ldb, float* W, float* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnDsygvd(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, double* A, int lda, double* B, int ldb, double* W, double* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnChegvd(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuComplex* A, int lda, cuComplex* B, int ldb, float* W, cuComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnZhegvd(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* B, int ldb, double* W, cuDoubleComplex* work, int lwork, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnCreateSyevjInfo(syevjInfo_t* info) except* nogil
cdef cusolverStatus_t _cusolverDnDestroySyevjInfo(syevjInfo_t info) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevjSetTolerance(syevjInfo_t info, double tolerance) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevjSetMaxSweeps(syevjInfo_t info, int max_sweeps) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevjSetSortEig(syevjInfo_t info, int sort_eig) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevjGetResidual(cusolverDnHandle_t handle, syevjInfo_t info, double* residual) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevjGetSweeps(cusolverDnHandle_t handle, syevjInfo_t info, int* executed_sweeps) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const float* A, int lda, const float* W, int* lwork, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const double* A, int lda, const double* W, int* lwork, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCheevjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const float* W, int* lwork, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZheevjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const double* W, int* lwork, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, float* A, int lda, float* W, float* work, int lwork, int* info, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, double* A, int lda, double* W, double* work, int lwork, int* info, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCheevjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuComplex* A, int lda, float* W, cuComplex* work, int lwork, int* info, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZheevjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, double* W, cuDoubleComplex* work, int lwork, int* info, syevjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const float* A, int lda, const float* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const double* A, int lda, const double* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnCheevj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const float* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnZheevj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const double* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnSsyevj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, float* A, int lda, float* W, float* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnDsyevj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, double* A, int lda, double* W, double* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnCheevj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuComplex* A, int lda, float* W, cuComplex* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnZheevj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, double* W, cuDoubleComplex* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnSsygvj_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const float* A, int lda, const float* B, int ldb, const float* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnDsygvj_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const double* A, int lda, const double* B, int ldb, const double* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnChegvj_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, const cuComplex* B, int ldb, const float* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnZhegvj_bufferSize(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const double* W, int* lwork, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnSsygvj(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, float* A, int lda, float* B, int ldb, float* W, float* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnDsygvj(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, double* A, int lda, double* B, int ldb, double* W, double* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnChegvj(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuComplex* A, int lda, cuComplex* B, int ldb, float* W, cuComplex* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnZhegvj(cusolverDnHandle_t handle, cusolverEigType_t itype, cusolverEigMode_t jobz, cublasFillMode_t uplo, int n, cuDoubleComplex* A, int lda, cuDoubleComplex* B, int ldb, double* W, cuDoubleComplex* work, int lwork, int* info, syevjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnCreateGesvdjInfo(gesvdjInfo_t* info) except* nogil
cdef cusolverStatus_t _cusolverDnDestroyGesvdjInfo(gesvdjInfo_t info) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdjSetTolerance(gesvdjInfo_t info, double tolerance) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdjSetMaxSweeps(gesvdjInfo_t info, int max_sweeps) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdjSetSortEig(gesvdjInfo_t info, int sort_svd) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdjGetResidual(cusolverDnHandle_t handle, gesvdjInfo_t info, double* residual) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdjGetSweeps(cusolverDnHandle_t handle, gesvdjInfo_t info, int* executed_sweeps) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvdjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, const float* A, int lda, const float* S, const float* U, int ldu, const float* V, int ldv, int* lwork, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvdjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, const double* A, int lda, const double* S, const double* U, int ldu, const double* V, int ldv, int* lwork, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvdjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, const cuComplex* A, int lda, const float* S, const cuComplex* U, int ldu, const cuComplex* V, int ldv, int* lwork, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvdjBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, const cuDoubleComplex* A, int lda, const double* S, const cuDoubleComplex* U, int ldu, const cuDoubleComplex* V, int ldv, int* lwork, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvdjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, float* A, int lda, float* S, float* U, int ldu, float* V, int ldv, float* work, int lwork, int* info, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvdjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, double* A, int lda, double* S, double* U, int ldu, double* V, int ldv, double* work, int lwork, int* info, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvdjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, cuComplex* A, int lda, float* S, cuComplex* U, int ldu, cuComplex* V, int ldv, cuComplex* work, int lwork, int* info, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvdjBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int m, int n, cuDoubleComplex* A, int lda, double* S, cuDoubleComplex* U, int ldu, cuDoubleComplex* V, int ldv, cuDoubleComplex* work, int lwork, int* info, gesvdjInfo_t params, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvdj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, const float* A, int lda, const float* S, const float* U, int ldu, const float* V, int ldv, int* lwork, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvdj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, const double* A, int lda, const double* S, const double* U, int ldu, const double* V, int ldv, int* lwork, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvdj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, const cuComplex* A, int lda, const float* S, const cuComplex* U, int ldu, const cuComplex* V, int ldv, int* lwork, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvdj_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, const cuDoubleComplex* A, int lda, const double* S, const cuDoubleComplex* U, int ldu, const cuDoubleComplex* V, int ldv, int* lwork, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvdj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, float* A, int lda, float* S, float* U, int ldu, float* V, int ldv, float* work, int lwork, int* info, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvdj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, double* A, int lda, double* S, double* U, int ldu, double* V, int ldv, double* work, int lwork, int* info, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvdj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, cuComplex* A, int lda, float* S, cuComplex* U, int ldu, cuComplex* V, int ldv, cuComplex* work, int lwork, int* info, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvdj(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int econ, int m, int n, cuDoubleComplex* A, int lda, double* S, cuDoubleComplex* U, int ldu, cuDoubleComplex* V, int ldv, cuDoubleComplex* work, int lwork, int* info, gesvdjInfo_t params) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvdaStridedBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const float* d_A, int lda, long long int strideA, const float* d_S, long long int strideS, const float* d_U, int ldu, long long int strideU, const float* d_V, int ldv, long long int strideV, int* lwork, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvdaStridedBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const double* d_A, int lda, long long int strideA, const double* d_S, long long int strideS, const double* d_U, int ldu, long long int strideU, const double* d_V, int ldv, long long int strideV, int* lwork, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvdaStridedBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const cuComplex* d_A, int lda, long long int strideA, const float* d_S, long long int strideS, const cuComplex* d_U, int ldu, long long int strideU, const cuComplex* d_V, int ldv, long long int strideV, int* lwork, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvdaStridedBatched_bufferSize(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const cuDoubleComplex* d_A, int lda, long long int strideA, const double* d_S, long long int strideS, const cuDoubleComplex* d_U, int ldu, long long int strideU, const cuDoubleComplex* d_V, int ldv, long long int strideV, int* lwork, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnSgesvdaStridedBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const float* d_A, int lda, long long int strideA, float* d_S, long long int strideS, float* d_U, int ldu, long long int strideU, float* d_V, int ldv, long long int strideV, float* d_work, int lwork, int* d_info, double* h_R_nrmF, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnDgesvdaStridedBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const double* d_A, int lda, long long int strideA, double* d_S, long long int strideS, double* d_U, int ldu, long long int strideU, double* d_V, int ldv, long long int strideV, double* d_work, int lwork, int* d_info, double* h_R_nrmF, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCgesvdaStridedBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const cuComplex* d_A, int lda, long long int strideA, float* d_S, long long int strideS, cuComplex* d_U, int ldu, long long int strideU, cuComplex* d_V, int ldv, long long int strideV, cuComplex* d_work, int lwork, int* d_info, double* h_R_nrmF, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnZgesvdaStridedBatched(cusolverDnHandle_t handle, cusolverEigMode_t jobz, int rank, int m, int n, const cuDoubleComplex* d_A, int lda, long long int strideA, double* d_S, long long int strideS, cuDoubleComplex* d_U, int ldu, long long int strideU, cuDoubleComplex* d_V, int ldv, long long int strideV, cuDoubleComplex* d_work, int lwork, int* d_info, double* h_R_nrmF, int batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnCreateParams(cusolverDnParams_t* params) except* nogil
cdef cusolverStatus_t _cusolverDnDestroyParams(cusolverDnParams_t params) except* nogil
cdef cusolverStatus_t _cusolverDnSetAdvOptions(cusolverDnParams_t params, cusolverDnFunction_t function, cusolverAlgMode_t algo) except* nogil
cdef cusolverStatus_t _cusolverDnXpotrf_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXpotrf(cusolverDnHandle_t handle, cusolverDnParams_t params, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXpotrs(cusolverDnHandle_t handle, cusolverDnParams_t params, cublasFillMode_t uplo, int64_t n, int64_t nrhs, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeB, void* B, int64_t ldb, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXgeqrf_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, int64_t m, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeTau, const void* tau, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXgeqrf(cusolverDnHandle_t handle, cusolverDnParams_t params, int64_t m, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeTau, void* tau, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXgetrf_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, int64_t m, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXgetrf(cusolverDnHandle_t handle, cusolverDnParams_t params, int64_t m, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, int64_t* ipiv, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXgetrs(cusolverDnHandle_t handle, cusolverDnParams_t params, cublasOperation_t trans, int64_t n, int64_t nrhs, cudaDataType dataTypeA, const void* A, int64_t lda, const int64_t* ipiv, cudaDataType dataTypeB, void* B, int64_t ldb, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevd_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeW, const void* W, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevd(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeW, void* W, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevdx_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, void* vl, void* vu, int64_t il, int64_t iu, int64_t* h_meig, cudaDataType dataTypeW, const void* W, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevdx(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, cusolverEigRange_t range, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, void* vl, void* vu, int64_t il, int64_t iu, int64_t* meig64, cudaDataType dataTypeW, void* W, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvd_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, signed char jobu, signed char jobvt, int64_t m, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeS, const void* S, cudaDataType dataTypeU, const void* U, int64_t ldu, cudaDataType dataTypeVT, const void* VT, int64_t ldvt, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvd(cusolverDnHandle_t handle, cusolverDnParams_t params, signed char jobu, signed char jobvt, int64_t m, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeS, void* S, cudaDataType dataTypeU, void* U, int64_t ldu, cudaDataType dataTypeVT, void* VT, int64_t ldvt, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdp_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, int econ, int64_t m, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeS, const void* S, cudaDataType dataTypeU, const void* U, int64_t ldu, cudaDataType dataTypeV, const void* V, int64_t ldv, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdp(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, int econ, int64_t m, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeS, void* S, cudaDataType dataTypeU, void* U, int64_t ldu, cudaDataType dataTypeV, void* V, int64_t ldv, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* d_info, double* h_err_sigma) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdr_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, signed char jobu, signed char jobv, int64_t m, int64_t n, int64_t k, int64_t p, int64_t niters, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeSrand, const void* Srand, cudaDataType dataTypeUrand, const void* Urand, int64_t ldUrand, cudaDataType dataTypeVrand, const void* Vrand, int64_t ldVrand, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXgesvdr(cusolverDnHandle_t handle, cusolverDnParams_t params, signed char jobu, signed char jobv, int64_t m, int64_t n, int64_t k, int64_t p, int64_t niters, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeSrand, void* Srand, cudaDataType dataTypeUrand, void* Urand, int64_t ldUrand, cudaDataType dataTypeVrand, void* Vrand, int64_t ldVrand, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* d_info) except* nogil
cdef cusolverStatus_t _cusolverDnXsytrs_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, int64_t n, int64_t nrhs, cudaDataType dataTypeA, const void* A, int64_t lda, const int64_t* ipiv, cudaDataType dataTypeB, void* B, int64_t ldb, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXsytrs(cusolverDnHandle_t handle, cublasFillMode_t uplo, int64_t n, int64_t nrhs, cudaDataType dataTypeA, const void* A, int64_t lda, const int64_t* ipiv, cudaDataType dataTypeB, void* B, int64_t ldb, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
cdef cusolverStatus_t _cusolverDnXtrtri_bufferSize(cusolverDnHandle_t handle, cublasFillMode_t uplo, cublasDiagType_t diag, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXtrtri(cusolverDnHandle_t handle, cublasFillMode_t uplo, cublasDiagType_t diag, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* devInfo) except* nogil
cdef cusolverStatus_t _cusolverDnLoggerSetCallback(cusolverDnLoggerCallback_t callback) except* nogil
cdef cusolverStatus_t _cusolverDnLoggerSetFile(FILE* file) except* nogil
cdef cusolverStatus_t _cusolverDnLoggerOpenFile(const char* logFile) except* nogil
cdef cusolverStatus_t _cusolverDnLoggerSetLevel(int level) except* nogil
cdef cusolverStatus_t _cusolverDnLoggerSetMask(int mask) except* nogil
cdef cusolverStatus_t _cusolverDnLoggerForceDisable() except* nogil
cdef cusolverStatus_t _cusolverDnSetDeterministicMode(cusolverDnHandle_t handle, cusolverDeterministicMode_t mode) except* nogil
cdef cusolverStatus_t _cusolverDnGetDeterministicMode(cusolverDnHandle_t handle, cusolverDeterministicMode_t* mode) except* nogil
cdef cusolverStatus_t _cusolverDnXlarft_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverDirectMode_t direct, cusolverStorevMode_t storev, int64_t n, int64_t k, cudaDataType dataTypeV, const void* V, int64_t ldv, cudaDataType dataTypeTau, const void* tau, cudaDataType dataTypeT, void* T, int64_t ldt, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXlarft(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverDirectMode_t direct, cusolverStorevMode_t storev, int64_t n, int64_t k, cudaDataType dataTypeV, const void* V, int64_t ldv, cudaDataType dataTypeTau, const void* tau, cudaDataType dataTypeT, void* T, int64_t ldt, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevBatched_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeW, const void* W, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost, int64_t batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnXsyevBatched(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobz, cublasFillMode_t uplo, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeW, void* W, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info, int64_t batchSize) except* nogil
cdef cusolverStatus_t _cusolverDnXgeev_bufferSize(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobvl, cusolverEigMode_t jobvr, int64_t n, cudaDataType dataTypeA, const void* A, int64_t lda, cudaDataType dataTypeW, const void* W, cudaDataType dataTypeVL, const void* VL, int64_t ldvl, cudaDataType dataTypeVR, const void* VR, int64_t ldvr, cudaDataType computeType, size_t* workspaceInBytesOnDevice, size_t* workspaceInBytesOnHost) except* nogil
cdef cusolverStatus_t _cusolverDnXgeev(cusolverDnHandle_t handle, cusolverDnParams_t params, cusolverEigMode_t jobvl, cusolverEigMode_t jobvr, int64_t n, cudaDataType dataTypeA, void* A, int64_t lda, cudaDataType dataTypeW, void* W, cudaDataType dataTypeVL, void* VL, int64_t ldvl, cudaDataType dataTypeVR, void* VR, int64_t ldvr, cudaDataType computeType, void* bufferOnDevice, size_t workspaceInBytesOnDevice, void* bufferOnHost, size_t workspaceInBytesOnHost, int* info) except* nogil
