# Copyright (c) 2024, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0
#
# This code was automatically generated across versions from 11.0.3 to 12.6.2. Do not modify it directly.

cimport cython  # NOQA
from libcpp.vector cimport vector
from cpython cimport buffer as _buffer
from cpython cimport memoryview as _memoryview

from enum import IntEnum as _IntEnum

import numpy as _numpy


###############################################################################
# POD
###############################################################################

matmul_algo_dtype = _numpy.dtype([
    ("data_", _numpy.uint64, (8,)),
    ], align=True)


cdef class MatmulAlgo:
    """Empty-initialize an array of `cublasLtMatmulAlgo_t`.

    The resulting object is of length `size` and of dtype `matmul_algo_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `cublasLtMatmulAlgo_t`
    """
    cdef:
        readonly object _data

    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=matmul_algo_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(cublasLtMatmulAlgo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size {sizeof(cublasLtMatmulAlgo_t)}"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.MatmulAlgo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.MatmulAlgo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :py:`int`."""
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        if not isinstance(other, MatmulAlgo):
            return False
        if self._data.size != other._data.size:
            return False
        if self._data.dtype != other._data.dtype:
            return False
        return bool((self._data == other._data).all())

    @property
    def data_(self):
        """data_ (~_numpy.uint64): (array of length 8)."""
        return self._data.data_

    @data_.setter
    def data_(self, val):
        self._data.data_ = val

    def __getitem__(self, key):
        if isinstance(key, int):
            size = self._data.size
            if key >= size or key <= -(size+1):
                raise IndexError("index is out of bounds")
            if key < 0:
                key += size
            return MatmulAlgo.from_data(self._data[key:key+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == matmul_algo_dtype:
            return MatmulAlgo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an MatmulAlgo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `matmul_algo_dtype` holding the data.
        """
        cdef MatmulAlgo obj = MatmulAlgo.__new__(MatmulAlgo)
        if not isinstance(data, (_numpy.ndarray, _numpy.recarray)):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != matmul_algo_dtype:
            raise ValueError("data array must be of dtype matmul_algo_dtype")
        obj._data = data.view(_numpy.recarray)
        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an MatmulAlgo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :py:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef MatmulAlgo obj = MatmulAlgo.__new__(MatmulAlgo)
        cdef flag = _buffer.PyBUF_READ if readonly else _buffer.PyBUF_WRITE
        cdef object buf = _memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(cublasLtMatmulAlgo_t) * size, flag)
        data = _numpy.ndarray((size,), buffer=buf,
                              dtype=matmul_algo_dtype)
        obj._data = data.view(_numpy.recarray)
        return obj


matmul_heuristic_result_dtype = _numpy.dtype([
    ("algo", matmul_algo_dtype, ),
    ("workspace_size", _numpy.uint64, ),
    ("state", _numpy.int32, ),
    ("waves_count", _numpy.float32, ),
    ("reserved", _numpy.int32, (4,)),
    ], align=True)


cdef class MatmulHeuristicResult:
    """Empty-initialize an array of `cublasLtMatmulHeuristicResult_t`.

    The resulting object is of length `size` and of dtype `matmul_heuristic_result_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `cublasLtMatmulHeuristicResult_t`
    """
    cdef:
        readonly object _data

    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=matmul_heuristic_result_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(cublasLtMatmulHeuristicResult_t), \
            f"itemsize {self._data.itemsize} mismatches struct size {sizeof(cublasLtMatmulHeuristicResult_t)}"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.MatmulHeuristicResult_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.MatmulHeuristicResult object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :py:`int`."""
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        if not isinstance(other, MatmulHeuristicResult):
            return False
        if self._data.size != other._data.size:
            return False
        if self._data.dtype != other._data.dtype:
            return False
        return bool((self._data == other._data).all())

    @property
    def algo(self):
        """algo (matmul_algo_dtype): """
        return self._data.algo

    @algo.setter
    def algo(self, val):
        self._data.algo = val

    @property
    def workspace_size(self):
        """workspace_size (~_numpy.uint64): """
        if self._data.size == 1:
            return int(self._data.workspace_size[0])
        return self._data.workspace_size

    @workspace_size.setter
    def workspace_size(self, val):
        self._data.workspace_size = val

    @property
    def state(self):
        """state (~_numpy.int32): """
        if self._data.size == 1:
            return int(self._data.state[0])
        return self._data.state

    @state.setter
    def state(self, val):
        self._data.state = val

    @property
    def waves_count(self):
        """waves_count (~_numpy.float32): """
        if self._data.size == 1:
            return float(self._data.waves_count[0])
        return self._data.waves_count

    @waves_count.setter
    def waves_count(self, val):
        self._data.waves_count = val

    def __getitem__(self, key):
        if isinstance(key, int):
            size = self._data.size
            if key >= size or key <= -(size+1):
                raise IndexError("index is out of bounds")
            if key < 0:
                key += size
            return MatmulHeuristicResult.from_data(self._data[key:key+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == matmul_heuristic_result_dtype:
            return MatmulHeuristicResult.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an MatmulHeuristicResult instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `matmul_heuristic_result_dtype` holding the data.
        """
        cdef MatmulHeuristicResult obj = MatmulHeuristicResult.__new__(MatmulHeuristicResult)
        if not isinstance(data, (_numpy.ndarray, _numpy.recarray)):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != matmul_heuristic_result_dtype:
            raise ValueError("data array must be of dtype matmul_heuristic_result_dtype")
        obj._data = data.view(_numpy.recarray)
        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an MatmulHeuristicResult instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :py:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef MatmulHeuristicResult obj = MatmulHeuristicResult.__new__(MatmulHeuristicResult)
        cdef flag = _buffer.PyBUF_READ if readonly else _buffer.PyBUF_WRITE
        cdef object buf = _memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(cublasLtMatmulHeuristicResult_t) * size, flag)
        data = _numpy.ndarray((size,), buffer=buf,
                              dtype=matmul_heuristic_result_dtype)
        obj._data = data.view(_numpy.recarray)
        return obj



###############################################################################
# Enum
###############################################################################

class MatmulTile(_IntEnum):
    """See `cublasLtMatmulTile_t`."""
    TILE_UNDEFINED = CUBLASLT_MATMUL_TILE_UNDEFINED
    TILE_8x8 = CUBLASLT_MATMUL_TILE_8x8
    TILE_8x16 = CUBLASLT_MATMUL_TILE_8x16
    TILE_16x8 = CUBLASLT_MATMUL_TILE_16x8
    TILE_8x32 = CUBLASLT_MATMUL_TILE_8x32
    TILE_16x16 = CUBLASLT_MATMUL_TILE_16x16
    TILE_32x8 = CUBLASLT_MATMUL_TILE_32x8
    TILE_8x64 = CUBLASLT_MATMUL_TILE_8x64
    TILE_16x32 = CUBLASLT_MATMUL_TILE_16x32
    TILE_32x16 = CUBLASLT_MATMUL_TILE_32x16
    TILE_64x8 = CUBLASLT_MATMUL_TILE_64x8
    TILE_32x32 = CUBLASLT_MATMUL_TILE_32x32
    TILE_32x64 = CUBLASLT_MATMUL_TILE_32x64
    TILE_64x32 = CUBLASLT_MATMUL_TILE_64x32
    TILE_32x128 = CUBLASLT_MATMUL_TILE_32x128
    TILE_64x64 = CUBLASLT_MATMUL_TILE_64x64
    TILE_128x32 = CUBLASLT_MATMUL_TILE_128x32
    TILE_64x128 = CUBLASLT_MATMUL_TILE_64x128
    TILE_128x64 = CUBLASLT_MATMUL_TILE_128x64
    TILE_64x256 = CUBLASLT_MATMUL_TILE_64x256
    TILE_128x128 = CUBLASLT_MATMUL_TILE_128x128
    TILE_256x64 = CUBLASLT_MATMUL_TILE_256x64
    TILE_64x512 = CUBLASLT_MATMUL_TILE_64x512
    TILE_128x256 = CUBLASLT_MATMUL_TILE_128x256
    TILE_256x128 = CUBLASLT_MATMUL_TILE_256x128
    TILE_512x64 = CUBLASLT_MATMUL_TILE_512x64
    TILE_64x96 = CUBLASLT_MATMUL_TILE_64x96
    TILE_96x64 = CUBLASLT_MATMUL_TILE_96x64
    TILE_96x128 = CUBLASLT_MATMUL_TILE_96x128
    TILE_128x160 = CUBLASLT_MATMUL_TILE_128x160
    TILE_160x128 = CUBLASLT_MATMUL_TILE_160x128
    TILE_192x128 = CUBLASLT_MATMUL_TILE_192x128
    TILE_128x192 = CUBLASLT_MATMUL_TILE_128x192
    TILE_128x96 = CUBLASLT_MATMUL_TILE_128x96
    TILE_32x256 = CUBLASLT_MATMUL_TILE_32x256
    TILE_256x32 = CUBLASLT_MATMUL_TILE_256x32
    TILE_8x128 = CUBLASLT_MATMUL_TILE_8x128
    TILE_8x192 = CUBLASLT_MATMUL_TILE_8x192
    TILE_8x256 = CUBLASLT_MATMUL_TILE_8x256
    TILE_8x320 = CUBLASLT_MATMUL_TILE_8x320
    TILE_8x384 = CUBLASLT_MATMUL_TILE_8x384
    TILE_8x448 = CUBLASLT_MATMUL_TILE_8x448
    TILE_8x512 = CUBLASLT_MATMUL_TILE_8x512
    TILE_8x576 = CUBLASLT_MATMUL_TILE_8x576
    TILE_8x640 = CUBLASLT_MATMUL_TILE_8x640
    TILE_8x704 = CUBLASLT_MATMUL_TILE_8x704
    TILE_8x768 = CUBLASLT_MATMUL_TILE_8x768
    TILE_16x64 = CUBLASLT_MATMUL_TILE_16x64
    TILE_16x128 = CUBLASLT_MATMUL_TILE_16x128
    TILE_16x192 = CUBLASLT_MATMUL_TILE_16x192
    TILE_16x256 = CUBLASLT_MATMUL_TILE_16x256
    TILE_16x320 = CUBLASLT_MATMUL_TILE_16x320
    TILE_16x384 = CUBLASLT_MATMUL_TILE_16x384
    TILE_16x448 = CUBLASLT_MATMUL_TILE_16x448
    TILE_16x512 = CUBLASLT_MATMUL_TILE_16x512
    TILE_16x576 = CUBLASLT_MATMUL_TILE_16x576
    TILE_16x640 = CUBLASLT_MATMUL_TILE_16x640
    TILE_16x704 = CUBLASLT_MATMUL_TILE_16x704
    TILE_16x768 = CUBLASLT_MATMUL_TILE_16x768
    TILE_24x64 = CUBLASLT_MATMUL_TILE_24x64
    TILE_24x128 = CUBLASLT_MATMUL_TILE_24x128
    TILE_24x192 = CUBLASLT_MATMUL_TILE_24x192
    TILE_24x256 = CUBLASLT_MATMUL_TILE_24x256
    TILE_24x320 = CUBLASLT_MATMUL_TILE_24x320
    TILE_24x384 = CUBLASLT_MATMUL_TILE_24x384
    TILE_24x448 = CUBLASLT_MATMUL_TILE_24x448
    TILE_24x512 = CUBLASLT_MATMUL_TILE_24x512
    TILE_24x576 = CUBLASLT_MATMUL_TILE_24x576
    TILE_24x640 = CUBLASLT_MATMUL_TILE_24x640
    TILE_24x704 = CUBLASLT_MATMUL_TILE_24x704
    TILE_24x768 = CUBLASLT_MATMUL_TILE_24x768
    TILE_32x192 = CUBLASLT_MATMUL_TILE_32x192
    TILE_32x320 = CUBLASLT_MATMUL_TILE_32x320
    TILE_32x384 = CUBLASLT_MATMUL_TILE_32x384
    TILE_32x448 = CUBLASLT_MATMUL_TILE_32x448
    TILE_32x512 = CUBLASLT_MATMUL_TILE_32x512
    TILE_32x576 = CUBLASLT_MATMUL_TILE_32x576
    TILE_32x640 = CUBLASLT_MATMUL_TILE_32x640
    TILE_32x704 = CUBLASLT_MATMUL_TILE_32x704
    TILE_32x768 = CUBLASLT_MATMUL_TILE_32x768
    TILE_40x64 = CUBLASLT_MATMUL_TILE_40x64
    TILE_40x128 = CUBLASLT_MATMUL_TILE_40x128
    TILE_40x192 = CUBLASLT_MATMUL_TILE_40x192
    TILE_40x256 = CUBLASLT_MATMUL_TILE_40x256
    TILE_40x320 = CUBLASLT_MATMUL_TILE_40x320
    TILE_40x384 = CUBLASLT_MATMUL_TILE_40x384
    TILE_40x448 = CUBLASLT_MATMUL_TILE_40x448
    TILE_40x512 = CUBLASLT_MATMUL_TILE_40x512
    TILE_40x576 = CUBLASLT_MATMUL_TILE_40x576
    TILE_40x640 = CUBLASLT_MATMUL_TILE_40x640
    TILE_40x704 = CUBLASLT_MATMUL_TILE_40x704
    TILE_40x768 = CUBLASLT_MATMUL_TILE_40x768
    TILE_48x64 = CUBLASLT_MATMUL_TILE_48x64
    TILE_48x128 = CUBLASLT_MATMUL_TILE_48x128
    TILE_48x192 = CUBLASLT_MATMUL_TILE_48x192
    TILE_48x256 = CUBLASLT_MATMUL_TILE_48x256
    TILE_48x320 = CUBLASLT_MATMUL_TILE_48x320
    TILE_48x384 = CUBLASLT_MATMUL_TILE_48x384
    TILE_48x448 = CUBLASLT_MATMUL_TILE_48x448
    TILE_48x512 = CUBLASLT_MATMUL_TILE_48x512
    TILE_48x576 = CUBLASLT_MATMUL_TILE_48x576
    TILE_48x640 = CUBLASLT_MATMUL_TILE_48x640
    TILE_48x704 = CUBLASLT_MATMUL_TILE_48x704
    TILE_48x768 = CUBLASLT_MATMUL_TILE_48x768
    TILE_56x64 = CUBLASLT_MATMUL_TILE_56x64
    TILE_56x128 = CUBLASLT_MATMUL_TILE_56x128
    TILE_56x192 = CUBLASLT_MATMUL_TILE_56x192
    TILE_56x256 = CUBLASLT_MATMUL_TILE_56x256
    TILE_56x320 = CUBLASLT_MATMUL_TILE_56x320
    TILE_56x384 = CUBLASLT_MATMUL_TILE_56x384
    TILE_56x448 = CUBLASLT_MATMUL_TILE_56x448
    TILE_56x512 = CUBLASLT_MATMUL_TILE_56x512
    TILE_56x576 = CUBLASLT_MATMUL_TILE_56x576
    TILE_56x640 = CUBLASLT_MATMUL_TILE_56x640
    TILE_56x704 = CUBLASLT_MATMUL_TILE_56x704
    TILE_56x768 = CUBLASLT_MATMUL_TILE_56x768
    TILE_64x192 = CUBLASLT_MATMUL_TILE_64x192
    TILE_64x320 = CUBLASLT_MATMUL_TILE_64x320
    TILE_64x384 = CUBLASLT_MATMUL_TILE_64x384
    TILE_64x448 = CUBLASLT_MATMUL_TILE_64x448
    TILE_64x576 = CUBLASLT_MATMUL_TILE_64x576
    TILE_64x640 = CUBLASLT_MATMUL_TILE_64x640
    TILE_64x704 = CUBLASLT_MATMUL_TILE_64x704
    TILE_64x768 = CUBLASLT_MATMUL_TILE_64x768
    TILE_72x64 = CUBLASLT_MATMUL_TILE_72x64
    TILE_72x128 = CUBLASLT_MATMUL_TILE_72x128
    TILE_72x192 = CUBLASLT_MATMUL_TILE_72x192
    TILE_72x256 = CUBLASLT_MATMUL_TILE_72x256
    TILE_72x320 = CUBLASLT_MATMUL_TILE_72x320
    TILE_72x384 = CUBLASLT_MATMUL_TILE_72x384
    TILE_72x448 = CUBLASLT_MATMUL_TILE_72x448
    TILE_72x512 = CUBLASLT_MATMUL_TILE_72x512
    TILE_72x576 = CUBLASLT_MATMUL_TILE_72x576
    TILE_72x640 = CUBLASLT_MATMUL_TILE_72x640
    TILE_80x64 = CUBLASLT_MATMUL_TILE_80x64
    TILE_80x128 = CUBLASLT_MATMUL_TILE_80x128
    TILE_80x192 = CUBLASLT_MATMUL_TILE_80x192
    TILE_80x256 = CUBLASLT_MATMUL_TILE_80x256
    TILE_80x320 = CUBLASLT_MATMUL_TILE_80x320
    TILE_80x384 = CUBLASLT_MATMUL_TILE_80x384
    TILE_80x448 = CUBLASLT_MATMUL_TILE_80x448
    TILE_80x512 = CUBLASLT_MATMUL_TILE_80x512
    TILE_80x576 = CUBLASLT_MATMUL_TILE_80x576
    TILE_88x64 = CUBLASLT_MATMUL_TILE_88x64
    TILE_88x128 = CUBLASLT_MATMUL_TILE_88x128
    TILE_88x192 = CUBLASLT_MATMUL_TILE_88x192
    TILE_88x256 = CUBLASLT_MATMUL_TILE_88x256
    TILE_88x320 = CUBLASLT_MATMUL_TILE_88x320
    TILE_88x384 = CUBLASLT_MATMUL_TILE_88x384
    TILE_88x448 = CUBLASLT_MATMUL_TILE_88x448
    TILE_88x512 = CUBLASLT_MATMUL_TILE_88x512
    TILE_96x192 = CUBLASLT_MATMUL_TILE_96x192
    TILE_96x256 = CUBLASLT_MATMUL_TILE_96x256
    TILE_96x320 = CUBLASLT_MATMUL_TILE_96x320
    TILE_96x384 = CUBLASLT_MATMUL_TILE_96x384
    TILE_96x448 = CUBLASLT_MATMUL_TILE_96x448
    TILE_96x512 = CUBLASLT_MATMUL_TILE_96x512
    TILE_104x64 = CUBLASLT_MATMUL_TILE_104x64
    TILE_104x128 = CUBLASLT_MATMUL_TILE_104x128
    TILE_104x192 = CUBLASLT_MATMUL_TILE_104x192
    TILE_104x256 = CUBLASLT_MATMUL_TILE_104x256
    TILE_104x320 = CUBLASLT_MATMUL_TILE_104x320
    TILE_104x384 = CUBLASLT_MATMUL_TILE_104x384
    TILE_104x448 = CUBLASLT_MATMUL_TILE_104x448
    TILE_112x64 = CUBLASLT_MATMUL_TILE_112x64
    TILE_112x128 = CUBLASLT_MATMUL_TILE_112x128
    TILE_112x192 = CUBLASLT_MATMUL_TILE_112x192
    TILE_112x256 = CUBLASLT_MATMUL_TILE_112x256
    TILE_112x320 = CUBLASLT_MATMUL_TILE_112x320
    TILE_112x384 = CUBLASLT_MATMUL_TILE_112x384
    TILE_120x64 = CUBLASLT_MATMUL_TILE_120x64
    TILE_120x128 = CUBLASLT_MATMUL_TILE_120x128
    TILE_120x192 = CUBLASLT_MATMUL_TILE_120x192
    TILE_120x256 = CUBLASLT_MATMUL_TILE_120x256
    TILE_120x320 = CUBLASLT_MATMUL_TILE_120x320
    TILE_120x384 = CUBLASLT_MATMUL_TILE_120x384
    TILE_128x320 = CUBLASLT_MATMUL_TILE_128x320
    TILE_128x384 = CUBLASLT_MATMUL_TILE_128x384
    TILE_136x64 = CUBLASLT_MATMUL_TILE_136x64
    TILE_136x128 = CUBLASLT_MATMUL_TILE_136x128
    TILE_136x192 = CUBLASLT_MATMUL_TILE_136x192
    TILE_136x256 = CUBLASLT_MATMUL_TILE_136x256
    TILE_136x320 = CUBLASLT_MATMUL_TILE_136x320
    TILE_144x64 = CUBLASLT_MATMUL_TILE_144x64
    TILE_144x128 = CUBLASLT_MATMUL_TILE_144x128
    TILE_144x192 = CUBLASLT_MATMUL_TILE_144x192
    TILE_144x256 = CUBLASLT_MATMUL_TILE_144x256
    TILE_144x320 = CUBLASLT_MATMUL_TILE_144x320
    TILE_152x64 = CUBLASLT_MATMUL_TILE_152x64
    TILE_152x128 = CUBLASLT_MATMUL_TILE_152x128
    TILE_152x192 = CUBLASLT_MATMUL_TILE_152x192
    TILE_152x256 = CUBLASLT_MATMUL_TILE_152x256
    TILE_152x320 = CUBLASLT_MATMUL_TILE_152x320
    TILE_160x64 = CUBLASLT_MATMUL_TILE_160x64
    TILE_160x192 = CUBLASLT_MATMUL_TILE_160x192
    TILE_160x256 = CUBLASLT_MATMUL_TILE_160x256
    TILE_168x64 = CUBLASLT_MATMUL_TILE_168x64
    TILE_168x128 = CUBLASLT_MATMUL_TILE_168x128
    TILE_168x192 = CUBLASLT_MATMUL_TILE_168x192
    TILE_168x256 = CUBLASLT_MATMUL_TILE_168x256
    TILE_176x64 = CUBLASLT_MATMUL_TILE_176x64
    TILE_176x128 = CUBLASLT_MATMUL_TILE_176x128
    TILE_176x192 = CUBLASLT_MATMUL_TILE_176x192
    TILE_176x256 = CUBLASLT_MATMUL_TILE_176x256
    TILE_184x64 = CUBLASLT_MATMUL_TILE_184x64
    TILE_184x128 = CUBLASLT_MATMUL_TILE_184x128
    TILE_184x192 = CUBLASLT_MATMUL_TILE_184x192
    TILE_184x256 = CUBLASLT_MATMUL_TILE_184x256
    TILE_192x64 = CUBLASLT_MATMUL_TILE_192x64
    TILE_192x192 = CUBLASLT_MATMUL_TILE_192x192
    TILE_192x256 = CUBLASLT_MATMUL_TILE_192x256
    TILE_200x64 = CUBLASLT_MATMUL_TILE_200x64
    TILE_200x128 = CUBLASLT_MATMUL_TILE_200x128
    TILE_200x192 = CUBLASLT_MATMUL_TILE_200x192
    TILE_208x64 = CUBLASLT_MATMUL_TILE_208x64
    TILE_208x128 = CUBLASLT_MATMUL_TILE_208x128
    TILE_208x192 = CUBLASLT_MATMUL_TILE_208x192
    TILE_216x64 = CUBLASLT_MATMUL_TILE_216x64
    TILE_216x128 = CUBLASLT_MATMUL_TILE_216x128
    TILE_216x192 = CUBLASLT_MATMUL_TILE_216x192
    TILE_224x64 = CUBLASLT_MATMUL_TILE_224x64
    TILE_224x128 = CUBLASLT_MATMUL_TILE_224x128
    TILE_224x192 = CUBLASLT_MATMUL_TILE_224x192
    TILE_232x64 = CUBLASLT_MATMUL_TILE_232x64
    TILE_232x128 = CUBLASLT_MATMUL_TILE_232x128
    TILE_232x192 = CUBLASLT_MATMUL_TILE_232x192
    TILE_240x64 = CUBLASLT_MATMUL_TILE_240x64
    TILE_240x128 = CUBLASLT_MATMUL_TILE_240x128
    TILE_240x192 = CUBLASLT_MATMUL_TILE_240x192
    TILE_248x64 = CUBLASLT_MATMUL_TILE_248x64
    TILE_248x128 = CUBLASLT_MATMUL_TILE_248x128
    TILE_248x192 = CUBLASLT_MATMUL_TILE_248x192
    TILE_256x192 = CUBLASLT_MATMUL_TILE_256x192
    TILE_264x64 = CUBLASLT_MATMUL_TILE_264x64
    TILE_264x128 = CUBLASLT_MATMUL_TILE_264x128
    TILE_272x64 = CUBLASLT_MATMUL_TILE_272x64
    TILE_272x128 = CUBLASLT_MATMUL_TILE_272x128
    TILE_280x64 = CUBLASLT_MATMUL_TILE_280x64
    TILE_280x128 = CUBLASLT_MATMUL_TILE_280x128
    TILE_288x64 = CUBLASLT_MATMUL_TILE_288x64
    TILE_288x128 = CUBLASLT_MATMUL_TILE_288x128
    TILE_296x64 = CUBLASLT_MATMUL_TILE_296x64
    TILE_296x128 = CUBLASLT_MATMUL_TILE_296x128
    TILE_304x64 = CUBLASLT_MATMUL_TILE_304x64
    TILE_304x128 = CUBLASLT_MATMUL_TILE_304x128
    TILE_312x64 = CUBLASLT_MATMUL_TILE_312x64
    TILE_312x128 = CUBLASLT_MATMUL_TILE_312x128
    TILE_320x64 = CUBLASLT_MATMUL_TILE_320x64
    TILE_320x128 = CUBLASLT_MATMUL_TILE_320x128
    TILE_328x64 = CUBLASLT_MATMUL_TILE_328x64
    TILE_328x128 = CUBLASLT_MATMUL_TILE_328x128
    TILE_336x64 = CUBLASLT_MATMUL_TILE_336x64
    TILE_336x128 = CUBLASLT_MATMUL_TILE_336x128
    TILE_344x64 = CUBLASLT_MATMUL_TILE_344x64
    TILE_344x128 = CUBLASLT_MATMUL_TILE_344x128
    TILE_352x64 = CUBLASLT_MATMUL_TILE_352x64
    TILE_352x128 = CUBLASLT_MATMUL_TILE_352x128
    TILE_360x64 = CUBLASLT_MATMUL_TILE_360x64
    TILE_360x128 = CUBLASLT_MATMUL_TILE_360x128
    TILE_368x64 = CUBLASLT_MATMUL_TILE_368x64
    TILE_368x128 = CUBLASLT_MATMUL_TILE_368x128
    TILE_376x64 = CUBLASLT_MATMUL_TILE_376x64
    TILE_376x128 = CUBLASLT_MATMUL_TILE_376x128
    TILE_384x64 = CUBLASLT_MATMUL_TILE_384x64
    TILE_384x128 = CUBLASLT_MATMUL_TILE_384x128
    TILE_392x64 = CUBLASLT_MATMUL_TILE_392x64
    TILE_400x64 = CUBLASLT_MATMUL_TILE_400x64
    TILE_408x64 = CUBLASLT_MATMUL_TILE_408x64
    TILE_416x64 = CUBLASLT_MATMUL_TILE_416x64
    TILE_424x64 = CUBLASLT_MATMUL_TILE_424x64
    TILE_432x64 = CUBLASLT_MATMUL_TILE_432x64
    TILE_440x64 = CUBLASLT_MATMUL_TILE_440x64
    TILE_448x64 = CUBLASLT_MATMUL_TILE_448x64
    TILE_456x64 = CUBLASLT_MATMUL_TILE_456x64
    TILE_464x64 = CUBLASLT_MATMUL_TILE_464x64
    TILE_472x64 = CUBLASLT_MATMUL_TILE_472x64
    TILE_480x64 = CUBLASLT_MATMUL_TILE_480x64
    TILE_488x64 = CUBLASLT_MATMUL_TILE_488x64
    TILE_496x64 = CUBLASLT_MATMUL_TILE_496x64
    TILE_504x64 = CUBLASLT_MATMUL_TILE_504x64
    TILE_520x64 = CUBLASLT_MATMUL_TILE_520x64
    TILE_528x64 = CUBLASLT_MATMUL_TILE_528x64
    TILE_536x64 = CUBLASLT_MATMUL_TILE_536x64
    TILE_544x64 = CUBLASLT_MATMUL_TILE_544x64
    TILE_552x64 = CUBLASLT_MATMUL_TILE_552x64
    TILE_560x64 = CUBLASLT_MATMUL_TILE_560x64
    TILE_568x64 = CUBLASLT_MATMUL_TILE_568x64
    TILE_576x64 = CUBLASLT_MATMUL_TILE_576x64
    TILE_584x64 = CUBLASLT_MATMUL_TILE_584x64
    TILE_592x64 = CUBLASLT_MATMUL_TILE_592x64
    TILE_600x64 = CUBLASLT_MATMUL_TILE_600x64
    TILE_608x64 = CUBLASLT_MATMUL_TILE_608x64
    TILE_616x64 = CUBLASLT_MATMUL_TILE_616x64
    TILE_624x64 = CUBLASLT_MATMUL_TILE_624x64
    TILE_632x64 = CUBLASLT_MATMUL_TILE_632x64
    TILE_640x64 = CUBLASLT_MATMUL_TILE_640x64
    TILE_648x64 = CUBLASLT_MATMUL_TILE_648x64
    TILE_656x64 = CUBLASLT_MATMUL_TILE_656x64
    TILE_664x64 = CUBLASLT_MATMUL_TILE_664x64
    TILE_672x64 = CUBLASLT_MATMUL_TILE_672x64
    TILE_680x64 = CUBLASLT_MATMUL_TILE_680x64
    TILE_688x64 = CUBLASLT_MATMUL_TILE_688x64
    TILE_696x64 = CUBLASLT_MATMUL_TILE_696x64
    TILE_704x64 = CUBLASLT_MATMUL_TILE_704x64
    TILE_712x64 = CUBLASLT_MATMUL_TILE_712x64
    TILE_720x64 = CUBLASLT_MATMUL_TILE_720x64
    TILE_728x64 = CUBLASLT_MATMUL_TILE_728x64
    TILE_736x64 = CUBLASLT_MATMUL_TILE_736x64
    TILE_744x64 = CUBLASLT_MATMUL_TILE_744x64
    TILE_752x64 = CUBLASLT_MATMUL_TILE_752x64
    TILE_760x64 = CUBLASLT_MATMUL_TILE_760x64
    TILE_768x64 = CUBLASLT_MATMUL_TILE_768x64
    TILE_64x16 = CUBLASLT_MATMUL_TILE_64x16
    TILE_64x24 = CUBLASLT_MATMUL_TILE_64x24
    TILE_64x40 = CUBLASLT_MATMUL_TILE_64x40
    TILE_64x48 = CUBLASLT_MATMUL_TILE_64x48
    TILE_64x56 = CUBLASLT_MATMUL_TILE_64x56
    TILE_64x72 = CUBLASLT_MATMUL_TILE_64x72
    TILE_64x80 = CUBLASLT_MATMUL_TILE_64x80
    TILE_64x88 = CUBLASLT_MATMUL_TILE_64x88
    TILE_64x104 = CUBLASLT_MATMUL_TILE_64x104
    TILE_64x112 = CUBLASLT_MATMUL_TILE_64x112
    TILE_64x120 = CUBLASLT_MATMUL_TILE_64x120
    TILE_64x136 = CUBLASLT_MATMUL_TILE_64x136
    TILE_64x144 = CUBLASLT_MATMUL_TILE_64x144
    TILE_64x152 = CUBLASLT_MATMUL_TILE_64x152
    TILE_64x160 = CUBLASLT_MATMUL_TILE_64x160
    TILE_64x168 = CUBLASLT_MATMUL_TILE_64x168
    TILE_64x176 = CUBLASLT_MATMUL_TILE_64x176
    TILE_64x184 = CUBLASLT_MATMUL_TILE_64x184
    TILE_64x200 = CUBLASLT_MATMUL_TILE_64x200
    TILE_64x208 = CUBLASLT_MATMUL_TILE_64x208
    TILE_64x216 = CUBLASLT_MATMUL_TILE_64x216
    TILE_64x224 = CUBLASLT_MATMUL_TILE_64x224
    TILE_64x232 = CUBLASLT_MATMUL_TILE_64x232
    TILE_64x240 = CUBLASLT_MATMUL_TILE_64x240
    TILE_64x248 = CUBLASLT_MATMUL_TILE_64x248
    TILE_64x264 = CUBLASLT_MATMUL_TILE_64x264
    TILE_64x272 = CUBLASLT_MATMUL_TILE_64x272
    TILE_64x280 = CUBLASLT_MATMUL_TILE_64x280
    TILE_64x288 = CUBLASLT_MATMUL_TILE_64x288
    TILE_64x296 = CUBLASLT_MATMUL_TILE_64x296
    TILE_64x304 = CUBLASLT_MATMUL_TILE_64x304
    TILE_64x312 = CUBLASLT_MATMUL_TILE_64x312
    TILE_64x328 = CUBLASLT_MATMUL_TILE_64x328
    TILE_64x336 = CUBLASLT_MATMUL_TILE_64x336
    TILE_64x344 = CUBLASLT_MATMUL_TILE_64x344
    TILE_64x352 = CUBLASLT_MATMUL_TILE_64x352
    TILE_64x360 = CUBLASLT_MATMUL_TILE_64x360
    TILE_64x368 = CUBLASLT_MATMUL_TILE_64x368
    TILE_64x376 = CUBLASLT_MATMUL_TILE_64x376
    TILE_64x392 = CUBLASLT_MATMUL_TILE_64x392
    TILE_64x400 = CUBLASLT_MATMUL_TILE_64x400
    TILE_64x408 = CUBLASLT_MATMUL_TILE_64x408
    TILE_64x416 = CUBLASLT_MATMUL_TILE_64x416
    TILE_64x424 = CUBLASLT_MATMUL_TILE_64x424
    TILE_64x432 = CUBLASLT_MATMUL_TILE_64x432
    TILE_64x440 = CUBLASLT_MATMUL_TILE_64x440
    TILE_64x456 = CUBLASLT_MATMUL_TILE_64x456
    TILE_64x464 = CUBLASLT_MATMUL_TILE_64x464
    TILE_64x472 = CUBLASLT_MATMUL_TILE_64x472
    TILE_64x480 = CUBLASLT_MATMUL_TILE_64x480
    TILE_64x488 = CUBLASLT_MATMUL_TILE_64x488
    TILE_64x496 = CUBLASLT_MATMUL_TILE_64x496
    TILE_64x504 = CUBLASLT_MATMUL_TILE_64x504
    TILE_64x520 = CUBLASLT_MATMUL_TILE_64x520
    TILE_64x528 = CUBLASLT_MATMUL_TILE_64x528
    TILE_64x536 = CUBLASLT_MATMUL_TILE_64x536
    TILE_64x544 = CUBLASLT_MATMUL_TILE_64x544
    TILE_64x552 = CUBLASLT_MATMUL_TILE_64x552
    TILE_64x560 = CUBLASLT_MATMUL_TILE_64x560
    TILE_64x568 = CUBLASLT_MATMUL_TILE_64x568
    TILE_64x584 = CUBLASLT_MATMUL_TILE_64x584
    TILE_64x592 = CUBLASLT_MATMUL_TILE_64x592
    TILE_64x600 = CUBLASLT_MATMUL_TILE_64x600
    TILE_64x608 = CUBLASLT_MATMUL_TILE_64x608
    TILE_64x616 = CUBLASLT_MATMUL_TILE_64x616
    TILE_64x624 = CUBLASLT_MATMUL_TILE_64x624
    TILE_64x632 = CUBLASLT_MATMUL_TILE_64x632
    TILE_64x648 = CUBLASLT_MATMUL_TILE_64x648
    TILE_64x656 = CUBLASLT_MATMUL_TILE_64x656
    TILE_64x664 = CUBLASLT_MATMUL_TILE_64x664
    TILE_64x672 = CUBLASLT_MATMUL_TILE_64x672
    TILE_64x680 = CUBLASLT_MATMUL_TILE_64x680
    TILE_64x688 = CUBLASLT_MATMUL_TILE_64x688
    TILE_64x696 = CUBLASLT_MATMUL_TILE_64x696
    TILE_64x712 = CUBLASLT_MATMUL_TILE_64x712
    TILE_64x720 = CUBLASLT_MATMUL_TILE_64x720
    TILE_64x728 = CUBLASLT_MATMUL_TILE_64x728
    TILE_64x736 = CUBLASLT_MATMUL_TILE_64x736
    TILE_64x744 = CUBLASLT_MATMUL_TILE_64x744
    TILE_64x752 = CUBLASLT_MATMUL_TILE_64x752
    TILE_64x760 = CUBLASLT_MATMUL_TILE_64x760
    TILE_128x8 = CUBLASLT_MATMUL_TILE_128x8
    TILE_128x16 = CUBLASLT_MATMUL_TILE_128x16
    TILE_128x24 = CUBLASLT_MATMUL_TILE_128x24
    TILE_128x40 = CUBLASLT_MATMUL_TILE_128x40
    TILE_128x48 = CUBLASLT_MATMUL_TILE_128x48
    TILE_128x56 = CUBLASLT_MATMUL_TILE_128x56
    TILE_128x72 = CUBLASLT_MATMUL_TILE_128x72
    TILE_128x80 = CUBLASLT_MATMUL_TILE_128x80
    TILE_128x88 = CUBLASLT_MATMUL_TILE_128x88
    TILE_128x104 = CUBLASLT_MATMUL_TILE_128x104
    TILE_128x112 = CUBLASLT_MATMUL_TILE_128x112
    TILE_128x120 = CUBLASLT_MATMUL_TILE_128x120
    TILE_128x136 = CUBLASLT_MATMUL_TILE_128x136
    TILE_128x144 = CUBLASLT_MATMUL_TILE_128x144
    TILE_128x152 = CUBLASLT_MATMUL_TILE_128x152
    TILE_128x168 = CUBLASLT_MATMUL_TILE_128x168
    TILE_128x176 = CUBLASLT_MATMUL_TILE_128x176
    TILE_128x184 = CUBLASLT_MATMUL_TILE_128x184
    TILE_128x200 = CUBLASLT_MATMUL_TILE_128x200
    TILE_128x208 = CUBLASLT_MATMUL_TILE_128x208
    TILE_128x216 = CUBLASLT_MATMUL_TILE_128x216
    TILE_128x224 = CUBLASLT_MATMUL_TILE_128x224
    TILE_128x232 = CUBLASLT_MATMUL_TILE_128x232
    TILE_128x240 = CUBLASLT_MATMUL_TILE_128x240
    TILE_128x248 = CUBLASLT_MATMUL_TILE_128x248
    TILE_128x264 = CUBLASLT_MATMUL_TILE_128x264
    TILE_128x272 = CUBLASLT_MATMUL_TILE_128x272
    TILE_128x280 = CUBLASLT_MATMUL_TILE_128x280
    TILE_128x288 = CUBLASLT_MATMUL_TILE_128x288
    TILE_128x296 = CUBLASLT_MATMUL_TILE_128x296
    TILE_128x304 = CUBLASLT_MATMUL_TILE_128x304
    TILE_128x312 = CUBLASLT_MATMUL_TILE_128x312
    TILE_128x328 = CUBLASLT_MATMUL_TILE_128x328
    TILE_128x336 = CUBLASLT_MATMUL_TILE_128x336
    TILE_128x344 = CUBLASLT_MATMUL_TILE_128x344
    TILE_128x352 = CUBLASLT_MATMUL_TILE_128x352
    TILE_128x360 = CUBLASLT_MATMUL_TILE_128x360
    TILE_128x368 = CUBLASLT_MATMUL_TILE_128x368
    TILE_128x376 = CUBLASLT_MATMUL_TILE_128x376
    TILE_128x392 = CUBLASLT_MATMUL_TILE_128x392
    TILE_128x400 = CUBLASLT_MATMUL_TILE_128x400
    TILE_128x408 = CUBLASLT_MATMUL_TILE_128x408
    TILE_128x416 = CUBLASLT_MATMUL_TILE_128x416
    TILE_128x424 = CUBLASLT_MATMUL_TILE_128x424
    TILE_128x432 = CUBLASLT_MATMUL_TILE_128x432
    TILE_128x440 = CUBLASLT_MATMUL_TILE_128x440
    TILE_128x448 = CUBLASLT_MATMUL_TILE_128x448
    TILE_128x456 = CUBLASLT_MATMUL_TILE_128x456
    TILE_128x464 = CUBLASLT_MATMUL_TILE_128x464
    TILE_128x472 = CUBLASLT_MATMUL_TILE_128x472
    TILE_128x480 = CUBLASLT_MATMUL_TILE_128x480
    TILE_128x488 = CUBLASLT_MATMUL_TILE_128x488
    TILE_128x496 = CUBLASLT_MATMUL_TILE_128x496
    TILE_128x504 = CUBLASLT_MATMUL_TILE_128x504
    TILE_128x512 = CUBLASLT_MATMUL_TILE_128x512
    TILE_192x8 = CUBLASLT_MATMUL_TILE_192x8
    TILE_192x16 = CUBLASLT_MATMUL_TILE_192x16
    TILE_192x24 = CUBLASLT_MATMUL_TILE_192x24
    TILE_192x32 = CUBLASLT_MATMUL_TILE_192x32
    TILE_192x40 = CUBLASLT_MATMUL_TILE_192x40
    TILE_192x48 = CUBLASLT_MATMUL_TILE_192x48
    TILE_192x56 = CUBLASLT_MATMUL_TILE_192x56
    TILE_192x72 = CUBLASLT_MATMUL_TILE_192x72
    TILE_192x80 = CUBLASLT_MATMUL_TILE_192x80
    TILE_192x88 = CUBLASLT_MATMUL_TILE_192x88
    TILE_192x96 = CUBLASLT_MATMUL_TILE_192x96
    TILE_192x104 = CUBLASLT_MATMUL_TILE_192x104
    TILE_192x112 = CUBLASLT_MATMUL_TILE_192x112
    TILE_192x120 = CUBLASLT_MATMUL_TILE_192x120
    TILE_192x136 = CUBLASLT_MATMUL_TILE_192x136
    TILE_192x144 = CUBLASLT_MATMUL_TILE_192x144
    TILE_192x152 = CUBLASLT_MATMUL_TILE_192x152
    TILE_192x160 = CUBLASLT_MATMUL_TILE_192x160
    TILE_192x168 = CUBLASLT_MATMUL_TILE_192x168
    TILE_192x176 = CUBLASLT_MATMUL_TILE_192x176
    TILE_192x184 = CUBLASLT_MATMUL_TILE_192x184
    TILE_192x200 = CUBLASLT_MATMUL_TILE_192x200
    TILE_192x208 = CUBLASLT_MATMUL_TILE_192x208
    TILE_192x216 = CUBLASLT_MATMUL_TILE_192x216
    TILE_192x224 = CUBLASLT_MATMUL_TILE_192x224
    TILE_192x232 = CUBLASLT_MATMUL_TILE_192x232
    TILE_192x240 = CUBLASLT_MATMUL_TILE_192x240
    TILE_192x248 = CUBLASLT_MATMUL_TILE_192x248
    TILE_192x264 = CUBLASLT_MATMUL_TILE_192x264
    TILE_192x272 = CUBLASLT_MATMUL_TILE_192x272
    TILE_192x280 = CUBLASLT_MATMUL_TILE_192x280
    TILE_192x288 = CUBLASLT_MATMUL_TILE_192x288
    TILE_192x296 = CUBLASLT_MATMUL_TILE_192x296
    TILE_192x304 = CUBLASLT_MATMUL_TILE_192x304
    TILE_192x312 = CUBLASLT_MATMUL_TILE_192x312
    TILE_192x320 = CUBLASLT_MATMUL_TILE_192x320
    TILE_192x328 = CUBLASLT_MATMUL_TILE_192x328
    TILE_192x336 = CUBLASLT_MATMUL_TILE_192x336
    TILE_256x8 = CUBLASLT_MATMUL_TILE_256x8
    TILE_256x16 = CUBLASLT_MATMUL_TILE_256x16
    TILE_256x24 = CUBLASLT_MATMUL_TILE_256x24
    TILE_256x40 = CUBLASLT_MATMUL_TILE_256x40
    TILE_256x48 = CUBLASLT_MATMUL_TILE_256x48
    TILE_256x56 = CUBLASLT_MATMUL_TILE_256x56
    TILE_256x72 = CUBLASLT_MATMUL_TILE_256x72
    TILE_256x80 = CUBLASLT_MATMUL_TILE_256x80
    TILE_256x88 = CUBLASLT_MATMUL_TILE_256x88
    TILE_256x96 = CUBLASLT_MATMUL_TILE_256x96
    TILE_256x104 = CUBLASLT_MATMUL_TILE_256x104
    TILE_256x112 = CUBLASLT_MATMUL_TILE_256x112
    TILE_256x120 = CUBLASLT_MATMUL_TILE_256x120
    TILE_256x136 = CUBLASLT_MATMUL_TILE_256x136
    TILE_256x144 = CUBLASLT_MATMUL_TILE_256x144
    TILE_256x152 = CUBLASLT_MATMUL_TILE_256x152
    TILE_256x160 = CUBLASLT_MATMUL_TILE_256x160
    TILE_256x168 = CUBLASLT_MATMUL_TILE_256x168
    TILE_256x176 = CUBLASLT_MATMUL_TILE_256x176
    TILE_256x184 = CUBLASLT_MATMUL_TILE_256x184
    TILE_256x200 = CUBLASLT_MATMUL_TILE_256x200
    TILE_256x208 = CUBLASLT_MATMUL_TILE_256x208
    TILE_256x216 = CUBLASLT_MATMUL_TILE_256x216
    TILE_256x224 = CUBLASLT_MATMUL_TILE_256x224
    TILE_256x232 = CUBLASLT_MATMUL_TILE_256x232
    TILE_256x240 = CUBLASLT_MATMUL_TILE_256x240
    TILE_256x248 = CUBLASLT_MATMUL_TILE_256x248
    TILE_256x256 = CUBLASLT_MATMUL_TILE_256x256
    TILE_320x8 = CUBLASLT_MATMUL_TILE_320x8
    TILE_320x16 = CUBLASLT_MATMUL_TILE_320x16
    TILE_320x24 = CUBLASLT_MATMUL_TILE_320x24
    TILE_320x32 = CUBLASLT_MATMUL_TILE_320x32
    TILE_320x40 = CUBLASLT_MATMUL_TILE_320x40
    TILE_320x48 = CUBLASLT_MATMUL_TILE_320x48
    TILE_320x56 = CUBLASLT_MATMUL_TILE_320x56
    TILE_320x72 = CUBLASLT_MATMUL_TILE_320x72
    TILE_320x80 = CUBLASLT_MATMUL_TILE_320x80
    TILE_320x88 = CUBLASLT_MATMUL_TILE_320x88
    TILE_320x96 = CUBLASLT_MATMUL_TILE_320x96
    TILE_320x104 = CUBLASLT_MATMUL_TILE_320x104
    TILE_320x112 = CUBLASLT_MATMUL_TILE_320x112
    TILE_320x120 = CUBLASLT_MATMUL_TILE_320x120
    TILE_320x136 = CUBLASLT_MATMUL_TILE_320x136
    TILE_320x144 = CUBLASLT_MATMUL_TILE_320x144
    TILE_320x152 = CUBLASLT_MATMUL_TILE_320x152
    TILE_320x160 = CUBLASLT_MATMUL_TILE_320x160
    TILE_320x168 = CUBLASLT_MATMUL_TILE_320x168
    TILE_320x176 = CUBLASLT_MATMUL_TILE_320x176
    TILE_320x184 = CUBLASLT_MATMUL_TILE_320x184
    TILE_320x192 = CUBLASLT_MATMUL_TILE_320x192
    TILE_320x200 = CUBLASLT_MATMUL_TILE_320x200
    TILE_384x8 = CUBLASLT_MATMUL_TILE_384x8
    TILE_384x16 = CUBLASLT_MATMUL_TILE_384x16
    TILE_384x24 = CUBLASLT_MATMUL_TILE_384x24
    TILE_384x32 = CUBLASLT_MATMUL_TILE_384x32
    TILE_384x40 = CUBLASLT_MATMUL_TILE_384x40
    TILE_384x48 = CUBLASLT_MATMUL_TILE_384x48
    TILE_384x56 = CUBLASLT_MATMUL_TILE_384x56
    TILE_384x72 = CUBLASLT_MATMUL_TILE_384x72
    TILE_384x80 = CUBLASLT_MATMUL_TILE_384x80
    TILE_384x88 = CUBLASLT_MATMUL_TILE_384x88
    TILE_384x96 = CUBLASLT_MATMUL_TILE_384x96
    TILE_384x104 = CUBLASLT_MATMUL_TILE_384x104
    TILE_384x112 = CUBLASLT_MATMUL_TILE_384x112
    TILE_384x120 = CUBLASLT_MATMUL_TILE_384x120
    TILE_384x136 = CUBLASLT_MATMUL_TILE_384x136
    TILE_384x144 = CUBLASLT_MATMUL_TILE_384x144
    TILE_384x152 = CUBLASLT_MATMUL_TILE_384x152
    TILE_384x160 = CUBLASLT_MATMUL_TILE_384x160
    TILE_384x168 = CUBLASLT_MATMUL_TILE_384x168
    TILE_448x8 = CUBLASLT_MATMUL_TILE_448x8
    TILE_448x16 = CUBLASLT_MATMUL_TILE_448x16
    TILE_448x24 = CUBLASLT_MATMUL_TILE_448x24
    TILE_448x32 = CUBLASLT_MATMUL_TILE_448x32
    TILE_448x40 = CUBLASLT_MATMUL_TILE_448x40
    TILE_448x48 = CUBLASLT_MATMUL_TILE_448x48
    TILE_448x56 = CUBLASLT_MATMUL_TILE_448x56
    TILE_448x72 = CUBLASLT_MATMUL_TILE_448x72
    TILE_448x80 = CUBLASLT_MATMUL_TILE_448x80
    TILE_448x88 = CUBLASLT_MATMUL_TILE_448x88
    TILE_448x96 = CUBLASLT_MATMUL_TILE_448x96
    TILE_448x104 = CUBLASLT_MATMUL_TILE_448x104
    TILE_448x112 = CUBLASLT_MATMUL_TILE_448x112
    TILE_448x120 = CUBLASLT_MATMUL_TILE_448x120
    TILE_448x128 = CUBLASLT_MATMUL_TILE_448x128
    TILE_448x136 = CUBLASLT_MATMUL_TILE_448x136
    TILE_448x144 = CUBLASLT_MATMUL_TILE_448x144
    TILE_512x8 = CUBLASLT_MATMUL_TILE_512x8
    TILE_512x16 = CUBLASLT_MATMUL_TILE_512x16
    TILE_512x24 = CUBLASLT_MATMUL_TILE_512x24
    TILE_512x32 = CUBLASLT_MATMUL_TILE_512x32
    TILE_512x40 = CUBLASLT_MATMUL_TILE_512x40
    TILE_512x48 = CUBLASLT_MATMUL_TILE_512x48
    TILE_512x56 = CUBLASLT_MATMUL_TILE_512x56
    TILE_512x72 = CUBLASLT_MATMUL_TILE_512x72
    TILE_512x80 = CUBLASLT_MATMUL_TILE_512x80
    TILE_512x88 = CUBLASLT_MATMUL_TILE_512x88
    TILE_512x96 = CUBLASLT_MATMUL_TILE_512x96
    TILE_512x104 = CUBLASLT_MATMUL_TILE_512x104
    TILE_512x112 = CUBLASLT_MATMUL_TILE_512x112
    TILE_512x120 = CUBLASLT_MATMUL_TILE_512x120
    TILE_512x128 = CUBLASLT_MATMUL_TILE_512x128
    TILE_576x8 = CUBLASLT_MATMUL_TILE_576x8
    TILE_576x16 = CUBLASLT_MATMUL_TILE_576x16
    TILE_576x24 = CUBLASLT_MATMUL_TILE_576x24
    TILE_576x32 = CUBLASLT_MATMUL_TILE_576x32
    TILE_576x40 = CUBLASLT_MATMUL_TILE_576x40
    TILE_576x48 = CUBLASLT_MATMUL_TILE_576x48
    TILE_576x56 = CUBLASLT_MATMUL_TILE_576x56
    TILE_576x72 = CUBLASLT_MATMUL_TILE_576x72
    TILE_576x80 = CUBLASLT_MATMUL_TILE_576x80
    TILE_576x88 = CUBLASLT_MATMUL_TILE_576x88
    TILE_576x96 = CUBLASLT_MATMUL_TILE_576x96
    TILE_576x104 = CUBLASLT_MATMUL_TILE_576x104
    TILE_576x112 = CUBLASLT_MATMUL_TILE_576x112
    TILE_640x8 = CUBLASLT_MATMUL_TILE_640x8
    TILE_640x16 = CUBLASLT_MATMUL_TILE_640x16
    TILE_640x24 = CUBLASLT_MATMUL_TILE_640x24
    TILE_640x32 = CUBLASLT_MATMUL_TILE_640x32
    TILE_640x40 = CUBLASLT_MATMUL_TILE_640x40
    TILE_640x48 = CUBLASLT_MATMUL_TILE_640x48
    TILE_640x56 = CUBLASLT_MATMUL_TILE_640x56
    TILE_640x72 = CUBLASLT_MATMUL_TILE_640x72
    TILE_640x80 = CUBLASLT_MATMUL_TILE_640x80
    TILE_640x88 = CUBLASLT_MATMUL_TILE_640x88
    TILE_640x96 = CUBLASLT_MATMUL_TILE_640x96
    TILE_704x8 = CUBLASLT_MATMUL_TILE_704x8
    TILE_704x16 = CUBLASLT_MATMUL_TILE_704x16
    TILE_704x24 = CUBLASLT_MATMUL_TILE_704x24
    TILE_704x32 = CUBLASLT_MATMUL_TILE_704x32
    TILE_704x40 = CUBLASLT_MATMUL_TILE_704x40
    TILE_704x48 = CUBLASLT_MATMUL_TILE_704x48
    TILE_704x56 = CUBLASLT_MATMUL_TILE_704x56
    TILE_704x72 = CUBLASLT_MATMUL_TILE_704x72
    TILE_704x80 = CUBLASLT_MATMUL_TILE_704x80
    TILE_704x88 = CUBLASLT_MATMUL_TILE_704x88
    TILE_768x8 = CUBLASLT_MATMUL_TILE_768x8
    TILE_768x16 = CUBLASLT_MATMUL_TILE_768x16
    TILE_768x24 = CUBLASLT_MATMUL_TILE_768x24
    TILE_768x32 = CUBLASLT_MATMUL_TILE_768x32
    TILE_768x40 = CUBLASLT_MATMUL_TILE_768x40
    TILE_768x48 = CUBLASLT_MATMUL_TILE_768x48
    TILE_768x56 = CUBLASLT_MATMUL_TILE_768x56
    TILE_768x72 = CUBLASLT_MATMUL_TILE_768x72
    TILE_768x80 = CUBLASLT_MATMUL_TILE_768x80

class MatmulStages(_IntEnum):
    """See `cublasLtMatmulStages_t`."""
    STAGES_UNDEFINED = CUBLASLT_MATMUL_STAGES_UNDEFINED
    STAGES_16x1 = CUBLASLT_MATMUL_STAGES_16x1
    STAGES_16x2 = CUBLASLT_MATMUL_STAGES_16x2
    STAGES_16x3 = CUBLASLT_MATMUL_STAGES_16x3
    STAGES_16x4 = CUBLASLT_MATMUL_STAGES_16x4
    STAGES_16x5 = CUBLASLT_MATMUL_STAGES_16x5
    STAGES_16x6 = CUBLASLT_MATMUL_STAGES_16x6
    STAGES_32x1 = CUBLASLT_MATMUL_STAGES_32x1
    STAGES_32x2 = CUBLASLT_MATMUL_STAGES_32x2
    STAGES_32x3 = CUBLASLT_MATMUL_STAGES_32x3
    STAGES_32x4 = CUBLASLT_MATMUL_STAGES_32x4
    STAGES_32x5 = CUBLASLT_MATMUL_STAGES_32x5
    STAGES_32x6 = CUBLASLT_MATMUL_STAGES_32x6
    STAGES_64x1 = CUBLASLT_MATMUL_STAGES_64x1
    STAGES_64x2 = CUBLASLT_MATMUL_STAGES_64x2
    STAGES_64x3 = CUBLASLT_MATMUL_STAGES_64x3
    STAGES_64x4 = CUBLASLT_MATMUL_STAGES_64x4
    STAGES_64x5 = CUBLASLT_MATMUL_STAGES_64x5
    STAGES_64x6 = CUBLASLT_MATMUL_STAGES_64x6
    STAGES_128x1 = CUBLASLT_MATMUL_STAGES_128x1
    STAGES_128x2 = CUBLASLT_MATMUL_STAGES_128x2
    STAGES_128x3 = CUBLASLT_MATMUL_STAGES_128x3
    STAGES_128x4 = CUBLASLT_MATMUL_STAGES_128x4
    STAGES_128x5 = CUBLASLT_MATMUL_STAGES_128x5
    STAGES_128x6 = CUBLASLT_MATMUL_STAGES_128x6
    STAGES_32x10 = CUBLASLT_MATMUL_STAGES_32x10
    STAGES_8x4 = CUBLASLT_MATMUL_STAGES_8x4
    STAGES_16x10 = CUBLASLT_MATMUL_STAGES_16x10
    STAGES_8x5 = CUBLASLT_MATMUL_STAGES_8x5
    STAGES_8x3 = CUBLASLT_MATMUL_STAGES_8x3
    STAGES_8xAUTO = CUBLASLT_MATMUL_STAGES_8xAUTO
    STAGES_16xAUTO = CUBLASLT_MATMUL_STAGES_16xAUTO
    STAGES_32xAUTO = CUBLASLT_MATMUL_STAGES_32xAUTO
    STAGES_64xAUTO = CUBLASLT_MATMUL_STAGES_64xAUTO
    STAGES_128xAUTO = CUBLASLT_MATMUL_STAGES_128xAUTO
    STAGES_16x80 = CUBLASLT_MATMUL_STAGES_16x80
    STAGES_64x80 = CUBLASLT_MATMUL_STAGES_64x80

class PointerMode(_IntEnum):
    """See `cublasLtPointerMode_t`."""
    HOST = CUBLASLT_POINTER_MODE_HOST
    DEVICE = CUBLASLT_POINTER_MODE_DEVICE
    DEVICE_VECTOR = CUBLASLT_POINTER_MODE_DEVICE_VECTOR
    ALPHA_DEVICE_VECTOR_BETA_ZERO = CUBLASLT_POINTER_MODE_ALPHA_DEVICE_VECTOR_BETA_ZERO
    ALPHA_DEVICE_VECTOR_BETA_HOST = CUBLASLT_POINTER_MODE_ALPHA_DEVICE_VECTOR_BETA_HOST

class PointerModeMask(_IntEnum):
    """See `cublasLtPointerModeMask_t`."""
    HOST = CUBLASLT_POINTER_MODE_MASK_HOST
    DEVICE = CUBLASLT_POINTER_MODE_MASK_DEVICE
    DEVICE_VECTOR = CUBLASLT_POINTER_MODE_MASK_DEVICE_VECTOR
    ALPHA_DEVICE_VECTOR_BETA_ZERO = CUBLASLT_POINTER_MODE_MASK_ALPHA_DEVICE_VECTOR_BETA_ZERO
    ALPHA_DEVICE_VECTOR_BETA_HOST = CUBLASLT_POINTER_MODE_MASK_ALPHA_DEVICE_VECTOR_BETA_HOST
    NO_FILTERING = CUBLASLT_POINTER_MODE_MASK_NO_FILTERING

class Order(_IntEnum):
    """See `cublasLtOrder_t`."""
    COL = CUBLASLT_ORDER_COL
    ROW = CUBLASLT_ORDER_ROW
    COL32 = CUBLASLT_ORDER_COL32
    COL4_4R2_8C = CUBLASLT_ORDER_COL4_4R2_8C
    COL32_2R_4R4 = CUBLASLT_ORDER_COL32_2R_4R4

class MatrixLayoutAttribute(_IntEnum):
    """See `cublasLtMatrixLayoutAttribute_t`."""
    TYPE = CUBLASLT_MATRIX_LAYOUT_TYPE
    ORDER = CUBLASLT_MATRIX_LAYOUT_ORDER
    ROWS = CUBLASLT_MATRIX_LAYOUT_ROWS
    COLS = CUBLASLT_MATRIX_LAYOUT_COLS
    LD = CUBLASLT_MATRIX_LAYOUT_LD
    BATCH_COUNT = CUBLASLT_MATRIX_LAYOUT_BATCH_COUNT
    STRIDED_BATCH_OFFSET = CUBLASLT_MATRIX_LAYOUT_STRIDED_BATCH_OFFSET
    PLANE_OFFSET = CUBLASLT_MATRIX_LAYOUT_PLANE_OFFSET

class MatmulDescAttribute(_IntEnum):
    """See `cublasLtMatmulDescAttributes_t`."""
    COMPUTE_TYPE = CUBLASLT_MATMUL_DESC_COMPUTE_TYPE
    SCALE_TYPE = CUBLASLT_MATMUL_DESC_SCALE_TYPE
    POINTER_MODE = CUBLASLT_MATMUL_DESC_POINTER_MODE
    TRANSA = CUBLASLT_MATMUL_DESC_TRANSA
    TRANSB = CUBLASLT_MATMUL_DESC_TRANSB
    TRANSC = CUBLASLT_MATMUL_DESC_TRANSC
    FILL_MODE = CUBLASLT_MATMUL_DESC_FILL_MODE
    EPILOGUE = CUBLASLT_MATMUL_DESC_EPILOGUE
    BIAS_POINTER = CUBLASLT_MATMUL_DESC_BIAS_POINTER
    BIAS_BATCH_STRIDE = CUBLASLT_MATMUL_DESC_BIAS_BATCH_STRIDE
    EPILOGUE_AUX_POINTER = CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_POINTER
    EPILOGUE_AUX_LD = CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_LD
    EPILOGUE_AUX_BATCH_STRIDE = CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_BATCH_STRIDE
    ALPHA_VECTOR_BATCH_STRIDE = CUBLASLT_MATMUL_DESC_ALPHA_VECTOR_BATCH_STRIDE
    SM_COUNT_TARGET = CUBLASLT_MATMUL_DESC_SM_COUNT_TARGET
    A_SCALE_POINTER = CUBLASLT_MATMUL_DESC_A_SCALE_POINTER
    B_SCALE_POINTER = CUBLASLT_MATMUL_DESC_B_SCALE_POINTER
    C_SCALE_POINTER = CUBLASLT_MATMUL_DESC_C_SCALE_POINTER
    D_SCALE_POINTER = CUBLASLT_MATMUL_DESC_D_SCALE_POINTER
    AMAX_D_POINTER = CUBLASLT_MATMUL_DESC_AMAX_D_POINTER
    EPILOGUE_AUX_DATA_TYPE = CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_DATA_TYPE
    EPILOGUE_AUX_SCALE_POINTER = CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_SCALE_POINTER
    EPILOGUE_AUX_AMAX_POINTER = CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_AMAX_POINTER
    FAST_ACCUM = CUBLASLT_MATMUL_DESC_FAST_ACCUM
    BIAS_DATA_TYPE = CUBLASLT_MATMUL_DESC_BIAS_DATA_TYPE
    ATOMIC_SYNC_NUM_CHUNKS_D_ROWS = CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_ROWS
    ATOMIC_SYNC_NUM_CHUNKS_D_COLS = CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_COLS
    ATOMIC_SYNC_IN_COUNTERS_POINTER = CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_IN_COUNTERS_POINTER
    ATOMIC_SYNC_OUT_COUNTERS_POINTER = CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_OUT_COUNTERS_POINTER

class MatrixTransformDescAttribute(_IntEnum):
    """See `cublasLtMatrixTransformDescAttributes_t`."""
    SCALE_TYPE = CUBLASLT_MATRIX_TRANSFORM_DESC_SCALE_TYPE
    POINTER_MODE = CUBLASLT_MATRIX_TRANSFORM_DESC_POINTER_MODE
    TRANSA = CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSA
    TRANSB = CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSB

class ReductionScheme(_IntEnum):
    """See `cublasLtReductionScheme_t`."""
    NONE = CUBLASLT_REDUCTION_SCHEME_NONE
    INPLACE = CUBLASLT_REDUCTION_SCHEME_INPLACE
    COMPUTE_TYPE = CUBLASLT_REDUCTION_SCHEME_COMPUTE_TYPE
    OUTPUT_TYPE = CUBLASLT_REDUCTION_SCHEME_OUTPUT_TYPE
    MASK = CUBLASLT_REDUCTION_SCHEME_MASK

class Epilogue(_IntEnum):
    """See `cublasLtEpilogue_t`."""
    DEFAULT = CUBLASLT_EPILOGUE_DEFAULT
    RELU = CUBLASLT_EPILOGUE_RELU
    RELU_AUX = CUBLASLT_EPILOGUE_RELU_AUX
    BIAS = CUBLASLT_EPILOGUE_BIAS
    RELU_BIAS = CUBLASLT_EPILOGUE_RELU_BIAS
    RELU_AUX_BIAS = CUBLASLT_EPILOGUE_RELU_AUX_BIAS
    DRELU = CUBLASLT_EPILOGUE_DRELU
    DRELU_BGRAD = CUBLASLT_EPILOGUE_DRELU_BGRAD
    GELU = CUBLASLT_EPILOGUE_GELU
    GELU_AUX = CUBLASLT_EPILOGUE_GELU_AUX
    GELU_BIAS = CUBLASLT_EPILOGUE_GELU_BIAS
    GELU_AUX_BIAS = CUBLASLT_EPILOGUE_GELU_AUX_BIAS
    DGELU = CUBLASLT_EPILOGUE_DGELU
    DGELU_BGRAD = CUBLASLT_EPILOGUE_DGELU_BGRAD
    BGRADA = CUBLASLT_EPILOGUE_BGRADA
    BGRADB = CUBLASLT_EPILOGUE_BGRADB

class MatmulSearch(_IntEnum):
    """See `cublasLtMatmulSearch_t`."""
    BEST_FIT = CUBLASLT_SEARCH_BEST_FIT
    LIMITED_BY_ALGO_ID = CUBLASLT_SEARCH_LIMITED_BY_ALGO_ID
    RESERVED_02 = CUBLASLT_SEARCH_RESERVED_02
    RESERVED_03 = CUBLASLT_SEARCH_RESERVED_03
    RESERVED_04 = CUBLASLT_SEARCH_RESERVED_04
    RESERVED_05 = CUBLASLT_SEARCH_RESERVED_05
    RESERVED_06 = CUBLASLT_SEARCH_RESERVED_06
    RESERVED_07 = CUBLASLT_SEARCH_RESERVED_07
    RESERVED_08 = CUBLASLT_SEARCH_RESERVED_08
    RESERVED_09 = CUBLASLT_SEARCH_RESERVED_09

class MatmulPreferenceAttribute(_IntEnum):
    """See `cublasLtMatmulPreferenceAttributes_t`."""
    SEARCH_MODE = CUBLASLT_MATMUL_PREF_SEARCH_MODE
    MAX_WORKSPACE_BYTES = CUBLASLT_MATMUL_PREF_MAX_WORKSPACE_BYTES
    REDUCTION_SCHEME_MASK = CUBLASLT_MATMUL_PREF_REDUCTION_SCHEME_MASK
    MIN_ALIGNMENT_A_BYTES = CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_A_BYTES
    MIN_ALIGNMENT_B_BYTES = CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_B_BYTES
    MIN_ALIGNMENT_C_BYTES = CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_C_BYTES
    MIN_ALIGNMENT_D_BYTES = CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_D_BYTES
    MAX_WAVES_COUNT = CUBLASLT_MATMUL_PREF_MAX_WAVES_COUNT
    IMPL_MASK = CUBLASLT_MATMUL_PREF_IMPL_MASK
    MATH_MODE_MASK = CUBLASLT_MATMUL_PREF_MATH_MODE_MASK
    GAUSSIAN_MODE_MASK = CUBLASLT_MATMUL_PREF_GAUSSIAN_MODE_MASK
    POINTER_MODE_MASK = CUBLASLT_MATMUL_PREF_POINTER_MODE_MASK
    EPILOGUE_MASK = CUBLASLT_MATMUL_PREF_EPILOGUE_MASK
    SM_COUNT_TARGET = CUBLASLT_MATMUL_PREF_SM_COUNT_TARGET

class MatmulAlgoCapAttribute(_IntEnum):
    """See `cublasLtMatmulAlgoCapAttributes_t`."""
    SPLITK_SUPPORT = CUBLASLT_ALGO_CAP_SPLITK_SUPPORT
    REDUCTION_SCHEME_MASK = CUBLASLT_ALGO_CAP_REDUCTION_SCHEME_MASK
    CTA_SWIZZLING_SUPPORT = CUBLASLT_ALGO_CAP_CTA_SWIZZLING_SUPPORT
    STRIDED_BATCH_SUPPORT = CUBLASLT_ALGO_CAP_STRIDED_BATCH_SUPPORT
    OUT_OF_PLACE_RESULT_SUPPORT = CUBLASLT_ALGO_CAP_OUT_OF_PLACE_RESULT_SUPPORT
    UPLO_SUPPORT = CUBLASLT_ALGO_CAP_UPLO_SUPPORT
    TILE_IDS = CUBLASLT_ALGO_CAP_TILE_IDS
    CUSTOM_OPTION_MAX = CUBLASLT_ALGO_CAP_CUSTOM_OPTION_MAX
    CUSTOM_MEMORY_ORDER = CUBLASLT_ALGO_CAP_CUSTOM_MEMORY_ORDER
    POINTER_MODE_MASK = CUBLASLT_ALGO_CAP_POINTER_MODE_MASK
    EPILOGUE_MASK = CUBLASLT_ALGO_CAP_EPILOGUE_MASK
    STAGES_IDS = CUBLASLT_ALGO_CAP_STAGES_IDS
    LD_NEGATIVE = CUBLASLT_ALGO_CAP_LD_NEGATIVE
    NUMERICAL_IMPL_FLAGS = CUBLASLT_ALGO_CAP_NUMERICAL_IMPL_FLAGS
    MIN_ALIGNMENT_A_BYTES = CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_A_BYTES
    MIN_ALIGNMENT_B_BYTES = CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_B_BYTES
    MIN_ALIGNMENT_C_BYTES = CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_C_BYTES
    MIN_ALIGNMENT_D_BYTES = CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_D_BYTES
    ATOMIC_SYNC = CUBLASLT_ALGO_CAP_ATOMIC_SYNC
    MATHMODE_IMPL = CUBLASLT_ALGO_CAP_MATHMODE_IMPL
    GAUSSIAN_IMPL = CUBLASLT_ALGO_CAP_GAUSSIAN_IMPL

class MatmulAlgoConfigAttribute(_IntEnum):
    """See `cublasLtMatmulAlgoConfigAttributes_t`."""
    ID = CUBLASLT_ALGO_CONFIG_ID
    TILE_ID = CUBLASLT_ALGO_CONFIG_TILE_ID
    SPLITK_NUM = CUBLASLT_ALGO_CONFIG_SPLITK_NUM
    REDUCTION_SCHEME = CUBLASLT_ALGO_CONFIG_REDUCTION_SCHEME
    CTA_SWIZZLING = CUBLASLT_ALGO_CONFIG_CTA_SWIZZLING
    CUSTOM_OPTION = CUBLASLT_ALGO_CONFIG_CUSTOM_OPTION
    STAGES_ID = CUBLASLT_ALGO_CONFIG_STAGES_ID
    INNER_SHAPE_ID = CUBLASLT_ALGO_CONFIG_INNER_SHAPE_ID
    CLUSTER_SHAPE_ID = CUBLASLT_ALGO_CONFIG_CLUSTER_SHAPE_ID

class ClusterShape(_IntEnum):
    """See `cublasLtClusterShape_t`."""
    SHAPE_AUTO = CUBLASLT_CLUSTER_SHAPE_AUTO
    SHAPE_1x1x1 = CUBLASLT_CLUSTER_SHAPE_1x1x1
    SHAPE_2x1x1 = CUBLASLT_CLUSTER_SHAPE_2x1x1
    SHAPE_4x1x1 = CUBLASLT_CLUSTER_SHAPE_4x1x1
    SHAPE_1x2x1 = CUBLASLT_CLUSTER_SHAPE_1x2x1
    SHAPE_2x2x1 = CUBLASLT_CLUSTER_SHAPE_2x2x1
    SHAPE_4x2x1 = CUBLASLT_CLUSTER_SHAPE_4x2x1
    SHAPE_1x4x1 = CUBLASLT_CLUSTER_SHAPE_1x4x1
    SHAPE_2x4x1 = CUBLASLT_CLUSTER_SHAPE_2x4x1
    SHAPE_4x4x1 = CUBLASLT_CLUSTER_SHAPE_4x4x1
    SHAPE_8x1x1 = CUBLASLT_CLUSTER_SHAPE_8x1x1
    SHAPE_1x8x1 = CUBLASLT_CLUSTER_SHAPE_1x8x1
    SHAPE_8x2x1 = CUBLASLT_CLUSTER_SHAPE_8x2x1
    SHAPE_2x8x1 = CUBLASLT_CLUSTER_SHAPE_2x8x1
    SHAPE_16x1x1 = CUBLASLT_CLUSTER_SHAPE_16x1x1
    SHAPE_1x16x1 = CUBLASLT_CLUSTER_SHAPE_1x16x1
    SHAPE_3x1x1 = CUBLASLT_CLUSTER_SHAPE_3x1x1
    SHAPE_5x1x1 = CUBLASLT_CLUSTER_SHAPE_5x1x1
    SHAPE_6x1x1 = CUBLASLT_CLUSTER_SHAPE_6x1x1
    SHAPE_7x1x1 = CUBLASLT_CLUSTER_SHAPE_7x1x1
    SHAPE_9x1x1 = CUBLASLT_CLUSTER_SHAPE_9x1x1
    SHAPE_10x1x1 = CUBLASLT_CLUSTER_SHAPE_10x1x1
    SHAPE_11x1x1 = CUBLASLT_CLUSTER_SHAPE_11x1x1
    SHAPE_12x1x1 = CUBLASLT_CLUSTER_SHAPE_12x1x1
    SHAPE_13x1x1 = CUBLASLT_CLUSTER_SHAPE_13x1x1
    SHAPE_14x1x1 = CUBLASLT_CLUSTER_SHAPE_14x1x1
    SHAPE_15x1x1 = CUBLASLT_CLUSTER_SHAPE_15x1x1
    SHAPE_3x2x1 = CUBLASLT_CLUSTER_SHAPE_3x2x1
    SHAPE_5x2x1 = CUBLASLT_CLUSTER_SHAPE_5x2x1
    SHAPE_6x2x1 = CUBLASLT_CLUSTER_SHAPE_6x2x1
    SHAPE_7x2x1 = CUBLASLT_CLUSTER_SHAPE_7x2x1
    SHAPE_1x3x1 = CUBLASLT_CLUSTER_SHAPE_1x3x1
    SHAPE_2x3x1 = CUBLASLT_CLUSTER_SHAPE_2x3x1
    SHAPE_3x3x1 = CUBLASLT_CLUSTER_SHAPE_3x3x1
    SHAPE_4x3x1 = CUBLASLT_CLUSTER_SHAPE_4x3x1
    SHAPE_5x3x1 = CUBLASLT_CLUSTER_SHAPE_5x3x1
    SHAPE_3x4x1 = CUBLASLT_CLUSTER_SHAPE_3x4x1
    SHAPE_1x5x1 = CUBLASLT_CLUSTER_SHAPE_1x5x1
    SHAPE_2x5x1 = CUBLASLT_CLUSTER_SHAPE_2x5x1
    SHAPE_3x5x1 = CUBLASLT_CLUSTER_SHAPE_3x5x1
    SHAPE_1x6x1 = CUBLASLT_CLUSTER_SHAPE_1x6x1
    SHAPE_2x6x1 = CUBLASLT_CLUSTER_SHAPE_2x6x1
    SHAPE_1x7x1 = CUBLASLT_CLUSTER_SHAPE_1x7x1
    SHAPE_2x7x1 = CUBLASLT_CLUSTER_SHAPE_2x7x1
    SHAPE_1x9x1 = CUBLASLT_CLUSTER_SHAPE_1x9x1
    SHAPE_1x10x1 = CUBLASLT_CLUSTER_SHAPE_1x10x1
    SHAPE_1x11x1 = CUBLASLT_CLUSTER_SHAPE_1x11x1
    SHAPE_1x12x1 = CUBLASLT_CLUSTER_SHAPE_1x12x1
    SHAPE_1x13x1 = CUBLASLT_CLUSTER_SHAPE_1x13x1
    SHAPE_1x14x1 = CUBLASLT_CLUSTER_SHAPE_1x14x1
    SHAPE_1x15x1 = CUBLASLT_CLUSTER_SHAPE_1x15x1

class MatmulInnerShape(_IntEnum):
    """See `cublasLtMatmulInnerShape_t`."""
    UNDEFINED = CUBLASLT_MATMUL_INNER_SHAPE_UNDEFINED
    MMA884 = CUBLASLT_MATMUL_INNER_SHAPE_MMA884
    MMA1684 = CUBLASLT_MATMUL_INNER_SHAPE_MMA1684
    MMA1688 = CUBLASLT_MATMUL_INNER_SHAPE_MMA1688
    MMA16816 = CUBLASLT_MATMUL_INNER_SHAPE_MMA16816


###############################################################################
# Error handling
###############################################################################

class cuBLASLtError(Exception):

    def __init__(self, status):
        self.status = status
        from ._internal.cublasLt import _inspect_function_pointer
        self.status = status
        cdef str err
        if (_inspect_function_pointer("__cublasLtGetStatusName") != 0
                and _inspect_function_pointer("__cublasLtGetStatusString") != 0):
            err = f"{get_status_string(status)} ({get_status_name(status)})"
        else:
            from .cublas import Status
            s = Status(status)
            err = f"{s.name} ({s.value})"
        err = f"{err}. You can set CUBLASLT_LOG_LEVEL=5 environment variable to enable cuBLAS logging to learn more."
        super(cuBLASLtError, self).__init__(err)

    def __reduce__(self):
        return (type(self), (self.status,))


@cython.profile(False)
cpdef inline check_status(int status):
    if status != 0:
        raise cuBLASLtError(status)


###############################################################################
# Wrapper functions
###############################################################################

cpdef intptr_t create() except? 0:
    """See `cublasLtCreate`."""
    cdef Handle light_handle
    with nogil:
        status = cublasLtCreate(&light_handle)
    check_status(status)
    return <intptr_t>light_handle


cpdef destroy(intptr_t light_handle):
    """See `cublasLtDestroy`."""
    with nogil:
        status = cublasLtDestroy(<Handle>light_handle)
    check_status(status)


cpdef size_t get_version() except? 0:
    """See `cublasLtGetVersion`."""
    return cublasLtGetVersion()


cpdef size_t get_cudart_version() except? 0:
    """See `cublasLtGetCudartVersion`."""
    return cublasLtGetCudartVersion()


cpdef int get_property(int type) except? -1:
    """See `cublasLtGetProperty`."""
    cdef int value
    with nogil:
        status = cublasLtGetProperty(<LibraryPropertyType>type, &value)
    check_status(status)
    return value


cpdef matmul(intptr_t light_handle, intptr_t compute_desc, intptr_t alpha, intptr_t a, intptr_t adesc, intptr_t b, intptr_t bdesc, intptr_t beta, intptr_t c, intptr_t cdesc, intptr_t d, intptr_t ddesc, intptr_t algo, intptr_t workspace, size_t workspace_size_in_bytes, intptr_t stream):
    """See `cublasLtMatmul`."""
    with nogil:
        status = cublasLtMatmul(<Handle>light_handle, <MatmulDesc>compute_desc, <const void*>alpha, <const void*>a, <MatrixLayout>adesc, <const void*>b, <MatrixLayout>bdesc, <const void*>beta, <const void*>c, <MatrixLayout>cdesc, <void*>d, <MatrixLayout>ddesc, <const cublasLtMatmulAlgo_t*>algo, <void*>workspace, workspace_size_in_bytes, <Stream>stream)
    check_status(status)


cpdef matrix_transform(intptr_t light_handle, intptr_t transform_desc, intptr_t alpha, intptr_t a, intptr_t adesc, intptr_t beta, intptr_t b, intptr_t bdesc, intptr_t c, intptr_t cdesc, intptr_t stream):
    """See `cublasLtMatrixTransform`."""
    with nogil:
        status = cublasLtMatrixTransform(<Handle>light_handle, <MatrixTransformDesc>transform_desc, <const void*>alpha, <const void*>a, <MatrixLayout>adesc, <const void*>beta, <const void*>b, <MatrixLayout>bdesc, <void*>c, <MatrixLayout>cdesc, <Stream>stream)
    check_status(status)


cpdef intptr_t matrix_layout_create(int type, uint64_t rows, uint64_t cols, int64_t ld) except? 0:
    """See `cublasLtMatrixLayoutCreate`."""
    cdef MatrixLayout mat_layout
    with nogil:
        status = cublasLtMatrixLayoutCreate(&mat_layout, <DataType>type, rows, cols, ld)
    check_status(status)
    return <intptr_t>mat_layout


cpdef matrix_layout_destroy(intptr_t mat_layout):
    """See `cublasLtMatrixLayoutDestroy`."""
    with nogil:
        status = cublasLtMatrixLayoutDestroy(<MatrixLayout>mat_layout)
    check_status(status)


######################### Python specific utility #########################

cdef dict matrix_layout_attribute_sizes = {
    CUBLASLT_MATRIX_LAYOUT_TYPE: _numpy.uint32,
    CUBLASLT_MATRIX_LAYOUT_ORDER: _numpy.int32,
    CUBLASLT_MATRIX_LAYOUT_ROWS: _numpy.uint64,
    CUBLASLT_MATRIX_LAYOUT_COLS: _numpy.uint64,
    CUBLASLT_MATRIX_LAYOUT_LD: _numpy.int64,
    CUBLASLT_MATRIX_LAYOUT_BATCH_COUNT: _numpy.int32,
    CUBLASLT_MATRIX_LAYOUT_STRIDED_BATCH_OFFSET: _numpy.int64,
    CUBLASLT_MATRIX_LAYOUT_PLANE_OFFSET: _numpy.int64,
}

cpdef get_matrix_layout_attribute_dtype(int attr):
    """Get the Python data type of the corresponding MatrixLayoutAttribute attribute.

    Args:
        attr (MatrixLayoutAttribute): The attribute to query.

    Returns:
        The data type of the queried attribute.

    .. note:: This API has no C counterpart and is a convenient helper for
        allocating memory for :func:`matrix_layout_get_attribute`, :func:`matrix_layout_set_attribute`.
    """
    return matrix_layout_attribute_sizes[attr]

###########################################################################


cpdef matrix_layout_set_attribute(intptr_t mat_layout, int attr, intptr_t buf, size_t size_in_bytes):
    """See `cublasLtMatrixLayoutSetAttribute`."""
    with nogil:
        status = cublasLtMatrixLayoutSetAttribute(<MatrixLayout>mat_layout, <_MatrixLayoutAttribute>attr, <const void*>buf, size_in_bytes)
    check_status(status)


cpdef matrix_layout_get_attribute(intptr_t mat_layout, int attr, intptr_t buf, size_t size_in_bytes, intptr_t size_written):
    """See `cublasLtMatrixLayoutGetAttribute`."""
    with nogil:
        status = cublasLtMatrixLayoutGetAttribute(<MatrixLayout>mat_layout, <_MatrixLayoutAttribute>attr, <void*>buf, size_in_bytes, <size_t*>size_written)
    check_status(status)


cpdef intptr_t matmul_desc_create(int compute_type, int scale_type) except? 0:
    """See `cublasLtMatmulDescCreate`."""
    cdef MatmulDesc matmul_desc
    with nogil:
        status = cublasLtMatmulDescCreate(&matmul_desc, <cublasComputeType_t>compute_type, <DataType>scale_type)
    check_status(status)
    return <intptr_t>matmul_desc


cpdef matmul_desc_destroy(intptr_t matmul_desc):
    """See `cublasLtMatmulDescDestroy`."""
    with nogil:
        status = cublasLtMatmulDescDestroy(<MatmulDesc>matmul_desc)
    check_status(status)


######################### Python specific utility #########################

cdef dict matmul_desc_attribute_sizes = {
    CUBLASLT_MATMUL_DESC_COMPUTE_TYPE: _numpy.int32,
    CUBLASLT_MATMUL_DESC_SCALE_TYPE: _numpy.int32,
    CUBLASLT_MATMUL_DESC_POINTER_MODE: _numpy.int32,
    CUBLASLT_MATMUL_DESC_TRANSA: _numpy.int32,
    CUBLASLT_MATMUL_DESC_TRANSB: _numpy.int32,
    CUBLASLT_MATMUL_DESC_TRANSC: _numpy.int32,
    CUBLASLT_MATMUL_DESC_FILL_MODE: _numpy.int32,
    CUBLASLT_MATMUL_DESC_EPILOGUE: _numpy.uint32,
    CUBLASLT_MATMUL_DESC_BIAS_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_BIAS_BATCH_STRIDE: _numpy.int64,
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_LD: _numpy.int64,
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_BATCH_STRIDE: _numpy.int64,
    CUBLASLT_MATMUL_DESC_ALPHA_VECTOR_BATCH_STRIDE: _numpy.int64,
    CUBLASLT_MATMUL_DESC_SM_COUNT_TARGET: _numpy.int32,
    CUBLASLT_MATMUL_DESC_A_SCALE_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_B_SCALE_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_C_SCALE_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_D_SCALE_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_AMAX_D_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_DATA_TYPE: _numpy.int32,
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_SCALE_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_AMAX_POINTER: _numpy.intp,
    CUBLASLT_MATMUL_DESC_FAST_ACCUM: _numpy.int8,
    CUBLASLT_MATMUL_DESC_BIAS_DATA_TYPE: _numpy.int32,
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_ROWS: _numpy.int32,
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_COLS: _numpy.int32,
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_IN_COUNTERS_POINTER: _numpy.int32,
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_OUT_COUNTERS_POINTER: _numpy.int32,
}

cpdef get_matmul_desc_attribute_dtype(int attr):
    """Get the Python data type of the corresponding MatmulDescAttribute attribute.

    Args:
        attr (MatmulDescAttribute): The attribute to query.

    Returns:
        The data type of the queried attribute.

    .. note:: This API has no C counterpart and is a convenient helper for
        allocating memory for :func:`matmul_desc_get_attribute`, :func:`matmul_desc_set_attribute`.
    """
    return matmul_desc_attribute_sizes[attr]

###########################################################################


cpdef matmul_desc_set_attribute(intptr_t matmul_desc, int attr, intptr_t buf, size_t size_in_bytes):
    """See `cublasLtMatmulDescSetAttribute`."""
    with nogil:
        status = cublasLtMatmulDescSetAttribute(<MatmulDesc>matmul_desc, <_MatmulDescAttribute>attr, <const void*>buf, size_in_bytes)
    check_status(status)


cpdef matmul_desc_get_attribute(intptr_t matmul_desc, int attr, intptr_t buf, size_t size_in_bytes, intptr_t size_written):
    """See `cublasLtMatmulDescGetAttribute`."""
    with nogil:
        status = cublasLtMatmulDescGetAttribute(<MatmulDesc>matmul_desc, <_MatmulDescAttribute>attr, <void*>buf, size_in_bytes, <size_t*>size_written)
    check_status(status)


cpdef intptr_t matrix_transform_desc_create(int scale_type) except? 0:
    """See `cublasLtMatrixTransformDescCreate`."""
    cdef MatrixTransformDesc transform_desc
    with nogil:
        status = cublasLtMatrixTransformDescCreate(&transform_desc, <DataType>scale_type)
    check_status(status)
    return <intptr_t>transform_desc


cpdef matrix_transform_desc_destroy(intptr_t transform_desc):
    """See `cublasLtMatrixTransformDescDestroy`."""
    with nogil:
        status = cublasLtMatrixTransformDescDestroy(<MatrixTransformDesc>transform_desc)
    check_status(status)


######################### Python specific utility #########################

cdef dict matrix_transform_desc_attribute_sizes = {
    CUBLASLT_MATRIX_TRANSFORM_DESC_SCALE_TYPE: _numpy.int32,
    CUBLASLT_MATRIX_TRANSFORM_DESC_POINTER_MODE: _numpy.int32,
    CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSA: _numpy.int32,
    CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSB: _numpy.int32,
}

cpdef get_matrix_transform_desc_attribute_dtype(int attr):
    """Get the Python data type of the corresponding MatrixTransformDescAttribute attribute.

    Args:
        attr (MatrixTransformDescAttribute): The attribute to query.

    Returns:
        The data type of the queried attribute.

    .. note:: This API has no C counterpart and is a convenient helper for
        allocating memory for :func:`matrix_transform_desc_get_attribute`, :func:`matrix_transform_desc_set_attribute`.
    """
    return matrix_transform_desc_attribute_sizes[attr]

###########################################################################


cpdef matrix_transform_desc_set_attribute(intptr_t transform_desc, int attr, intptr_t buf, size_t size_in_bytes):
    """See `cublasLtMatrixTransformDescSetAttribute`."""
    with nogil:
        status = cublasLtMatrixTransformDescSetAttribute(<MatrixTransformDesc>transform_desc, <_MatrixTransformDescAttribute>attr, <const void*>buf, size_in_bytes)
    check_status(status)


cpdef matrix_transform_desc_get_attribute(intptr_t transform_desc, int attr, intptr_t buf, size_t size_in_bytes, intptr_t size_written):
    """See `cublasLtMatrixTransformDescGetAttribute`."""
    with nogil:
        status = cublasLtMatrixTransformDescGetAttribute(<MatrixTransformDesc>transform_desc, <_MatrixTransformDescAttribute>attr, <void*>buf, size_in_bytes, <size_t*>size_written)
    check_status(status)


cpdef intptr_t matmul_preference_create() except? 0:
    """See `cublasLtMatmulPreferenceCreate`."""
    cdef MatmulPreference pref
    with nogil:
        status = cublasLtMatmulPreferenceCreate(&pref)
    check_status(status)
    return <intptr_t>pref


cpdef matmul_preference_destroy(intptr_t pref):
    """See `cublasLtMatmulPreferenceDestroy`."""
    with nogil:
        status = cublasLtMatmulPreferenceDestroy(<MatmulPreference>pref)
    check_status(status)


######################### Python specific utility #########################

cdef dict matmul_preference_attribute_sizes = {
    CUBLASLT_MATMUL_PREF_SEARCH_MODE: _numpy.uint32,
    CUBLASLT_MATMUL_PREF_MAX_WORKSPACE_BYTES: _numpy.uint64,
    CUBLASLT_MATMUL_PREF_REDUCTION_SCHEME_MASK: _numpy.uint32,
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_A_BYTES: _numpy.uint32,
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_B_BYTES: _numpy.uint32,
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_C_BYTES: _numpy.uint32,
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_D_BYTES: _numpy.uint32,
    CUBLASLT_MATMUL_PREF_MAX_WAVES_COUNT: _numpy.float32,
    CUBLASLT_MATMUL_PREF_IMPL_MASK: _numpy.uint64,
}

cpdef get_matmul_preference_attribute_dtype(int attr):
    """Get the Python data type of the corresponding MatmulPreferenceAttribute attribute.

    Args:
        attr (MatmulPreferenceAttribute): The attribute to query.

    Returns:
        The data type of the queried attribute.

    .. note:: This API has no C counterpart and is a convenient helper for
        allocating memory for :func:`matmul_preference_get_attribute`, :func:`matmul_preference_set_attribute`.
    """
    if attr == CUBLASLT_MATMUL_PREF_MATH_MODE_MASK:
        raise ValueError('The value has been deprecated and removed. Please use corresponding value from `MatmulNumericalImplFlags`')
    if attr == CUBLASLT_MATMUL_PREF_GAUSSIAN_MODE_MASK:
        raise ValueError('The value has been deprecated and removed. Please use corresponding value from `MatmulNumericalImplFlags`')
    if attr == CUBLASLT_MATMUL_PREF_POINTER_MODE_MASK:
        raise ValueError('The value has been deprecated and removed. Please use corresponding value from `MatmulPreferenceAttribute`')
    if attr == CUBLASLT_MATMUL_PREF_EPILOGUE_MASK:
        raise ValueError('The value has been deprecated and removed. Please use corresponding value from `MatmulPreferenceAttribute`')
    if attr == CUBLASLT_MATMUL_PREF_SM_COUNT_TARGET:
        raise ValueError('The value has been deprecated and removed. Please use corresponding value from `MatmulPreferenceAttribute`')
    return matmul_preference_attribute_sizes[attr]

###########################################################################


cpdef matmul_preference_set_attribute(intptr_t pref, int attr, intptr_t buf, size_t size_in_bytes):
    """See `cublasLtMatmulPreferenceSetAttribute`."""
    with nogil:
        status = cublasLtMatmulPreferenceSetAttribute(<MatmulPreference>pref, <_MatmulPreferenceAttribute>attr, <const void*>buf, size_in_bytes)
    check_status(status)


cpdef matmul_preference_get_attribute(intptr_t pref, int attr, intptr_t buf, size_t size_in_bytes, intptr_t size_written):
    """See `cublasLtMatmulPreferenceGetAttribute`."""
    with nogil:
        status = cublasLtMatmulPreferenceGetAttribute(<MatmulPreference>pref, <_MatmulPreferenceAttribute>attr, <void*>buf, size_in_bytes, <size_t*>size_written)
    check_status(status)


cpdef matmul_algo_get_heuristic(intptr_t light_handle, intptr_t operation_desc, intptr_t adesc, intptr_t bdesc, intptr_t cdesc, intptr_t ddesc, intptr_t preference, int requested_algo_count, intptr_t heuristic_results_array, intptr_t return_algo_count):
    """See `cublasLtMatmulAlgoGetHeuristic`."""
    with nogil:
        status = cublasLtMatmulAlgoGetHeuristic(<Handle>light_handle, <MatmulDesc>operation_desc, <MatrixLayout>adesc, <MatrixLayout>bdesc, <MatrixLayout>cdesc, <MatrixLayout>ddesc, <MatmulPreference>preference, requested_algo_count, <cublasLtMatmulHeuristicResult_t*>heuristic_results_array, <int*>return_algo_count)
    check_status(status)


cpdef matmul_algo_init(intptr_t light_handle, int compute_type, int scale_type, int atype, int btype, int ctype, int dtype, int algo_id, intptr_t algo):
    """See `cublasLtMatmulAlgoInit`."""
    with nogil:
        status = cublasLtMatmulAlgoInit(<Handle>light_handle, <cublasComputeType_t>compute_type, <DataType>scale_type, <DataType>atype, <DataType>btype, <DataType>ctype, <DataType>dtype, algo_id, <cublasLtMatmulAlgo_t*>algo)
    check_status(status)


cpdef matmul_algo_check(intptr_t light_handle, intptr_t operation_desc, intptr_t adesc, intptr_t bdesc, intptr_t cdesc, intptr_t ddesc, intptr_t algo, intptr_t result):
    """See `cublasLtMatmulAlgoCheck`."""
    with nogil:
        status = cublasLtMatmulAlgoCheck(<Handle>light_handle, <MatmulDesc>operation_desc, <MatrixLayout>adesc, <MatrixLayout>bdesc, <MatrixLayout>cdesc, <MatrixLayout>ddesc, <const cublasLtMatmulAlgo_t*>algo, <cublasLtMatmulHeuristicResult_t*>result)
    check_status(status)


######################### Python specific utility #########################

cdef dict matmul_algo_cap_attribute_sizes = {
    CUBLASLT_ALGO_CAP_SPLITK_SUPPORT: _numpy.int32,
    CUBLASLT_ALGO_CAP_REDUCTION_SCHEME_MASK: _numpy.uint32,
    CUBLASLT_ALGO_CAP_CTA_SWIZZLING_SUPPORT: _numpy.uint32,
    CUBLASLT_ALGO_CAP_STRIDED_BATCH_SUPPORT: _numpy.int32,
    CUBLASLT_ALGO_CAP_OUT_OF_PLACE_RESULT_SUPPORT: _numpy.int32,
    CUBLASLT_ALGO_CAP_UPLO_SUPPORT: _numpy.int32,
    CUBLASLT_ALGO_CAP_TILE_IDS: _numpy.uint32,
    CUBLASLT_ALGO_CAP_CUSTOM_OPTION_MAX: _numpy.int32,
    CUBLASLT_ALGO_CAP_CUSTOM_MEMORY_ORDER: _numpy.int32,
    CUBLASLT_ALGO_CAP_POINTER_MODE_MASK: _numpy.uint32,
    CUBLASLT_ALGO_CAP_EPILOGUE_MASK: _numpy.uint32,
    CUBLASLT_ALGO_CAP_STAGES_IDS: _numpy.uint32,
    CUBLASLT_ALGO_CAP_LD_NEGATIVE: _numpy.int32,
    CUBLASLT_ALGO_CAP_NUMERICAL_IMPL_FLAGS: _numpy.uint64,
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_A_BYTES: _numpy.uint32,
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_B_BYTES: _numpy.uint32,
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_C_BYTES: _numpy.uint32,
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_D_BYTES: _numpy.uint32,
    CUBLASLT_ALGO_CAP_ATOMIC_SYNC: _numpy.int32,
    CUBLASLT_ALGO_CAP_MATHMODE_IMPL: _numpy.int32,
    CUBLASLT_ALGO_CAP_GAUSSIAN_IMPL: _numpy.int32,
}

cpdef get_matmul_algo_cap_attribute_dtype(int attr):
    """Get the Python data type of the corresponding MatmulAlgoCapAttribute attribute.

    Args:
        attr (MatmulAlgoCapAttribute): The attribute to query.

    Returns:
        The data type of the queried attribute.

    .. note:: This API has no C counterpart and is a convenient helper for
        allocating memory for :func:`matmul_algo_cap_get_attribute`.
    """
    return matmul_algo_cap_attribute_sizes[attr]

###########################################################################


cpdef matmul_algo_cap_get_attribute(intptr_t algo, int attr, intptr_t buf, size_t size_in_bytes, intptr_t size_written):
    """See `cublasLtMatmulAlgoCapGetAttribute`."""
    with nogil:
        status = cublasLtMatmulAlgoCapGetAttribute(<const cublasLtMatmulAlgo_t*>algo, <_MatmulAlgoCapAttribute>attr, <void*>buf, size_in_bytes, <size_t*>size_written)
    check_status(status)


######################### Python specific utility #########################

cdef dict matmul_algo_config_attribute_sizes = {
    CUBLASLT_ALGO_CONFIG_ID: _numpy.int32,
    CUBLASLT_ALGO_CONFIG_TILE_ID: _numpy.uint32,
    CUBLASLT_ALGO_CONFIG_SPLITK_NUM: _numpy.int32,
    CUBLASLT_ALGO_CONFIG_REDUCTION_SCHEME: _numpy.uint32,
    CUBLASLT_ALGO_CONFIG_CTA_SWIZZLING: _numpy.uint32,
    CUBLASLT_ALGO_CONFIG_CUSTOM_OPTION: _numpy.uint32,
    CUBLASLT_ALGO_CONFIG_STAGES_ID: _numpy.uint32,
    CUBLASLT_ALGO_CONFIG_INNER_SHAPE_ID: _numpy.uint16,
    CUBLASLT_ALGO_CONFIG_CLUSTER_SHAPE_ID: _numpy.uint16,
}

cpdef get_matmul_algo_config_attribute_dtype(int attr):
    """Get the Python data type of the corresponding MatmulAlgoConfigAttribute attribute.

    Args:
        attr (MatmulAlgoConfigAttribute): The attribute to query.

    Returns:
        The data type of the queried attribute.

    .. note:: This API has no C counterpart and is a convenient helper for
        allocating memory for :func:`matmul_algo_config_get_attribute`, :func:`matmul_algo_config_set_attribute`.
    """
    return matmul_algo_config_attribute_sizes[attr]

###########################################################################


cpdef matmul_algo_config_set_attribute(intptr_t algo, int attr, intptr_t buf, size_t size_in_bytes):
    """See `cublasLtMatmulAlgoConfigSetAttribute`."""
    with nogil:
        status = cublasLtMatmulAlgoConfigSetAttribute(<cublasLtMatmulAlgo_t*>algo, <_MatmulAlgoConfigAttribute>attr, <const void*>buf, size_in_bytes)
    check_status(status)


cpdef matmul_algo_config_get_attribute(intptr_t algo, int attr, intptr_t buf, size_t size_in_bytes, intptr_t size_written):
    """See `cublasLtMatmulAlgoConfigGetAttribute`."""
    with nogil:
        status = cublasLtMatmulAlgoConfigGetAttribute(<const cublasLtMatmulAlgo_t*>algo, <_MatmulAlgoConfigAttribute>attr, <void*>buf, size_in_bytes, <size_t*>size_written)
    check_status(status)


cpdef logger_open_file(log_file):
    """See `cublasLtLoggerOpenFile`."""
    if not isinstance(log_file, str):
        raise TypeError("log_file must be a Python str")
    cdef bytes _temp_log_file_ = (<str>log_file).encode()
    cdef char* _log_file_ = _temp_log_file_
    with nogil:
        status = cublasLtLoggerOpenFile(<const char*>_log_file_)
    check_status(status)


cpdef logger_set_level(int level):
    """See `cublasLtLoggerSetLevel`."""
    with nogil:
        status = cublasLtLoggerSetLevel(level)
    check_status(status)


cpdef logger_set_mask(int mask):
    """See `cublasLtLoggerSetMask`."""
    with nogil:
        status = cublasLtLoggerSetMask(mask)
    check_status(status)


cpdef logger_force_disable():
    """See `cublasLtLoggerForceDisable`."""
    with nogil:
        status = cublasLtLoggerForceDisable()
    check_status(status)


cpdef str get_status_name(int status):
    """See `cublasLtGetStatusName`."""
    cdef bytes _output_
    _output_ = cublasLtGetStatusName(<cublasStatus_t>status)
    return _output_.decode()


cpdef str get_status_string(int status):
    """See `cublasLtGetStatusString`."""
    cdef bytes _output_
    _output_ = cublasLtGetStatusString(<cublasStatus_t>status)
    return _output_.decode()


cpdef size_t heuristics_cache_get_capacity() except? 0:
    """See `cublasLtHeuristicsCacheGetCapacity`."""
    cdef size_t capacity
    with nogil:
        status = cublasLtHeuristicsCacheGetCapacity(&capacity)
    check_status(status)
    return capacity


cpdef heuristics_cache_set_capacity(size_t capacity):
    """See `cublasLtHeuristicsCacheSetCapacity`."""
    with nogil:
        status = cublasLtHeuristicsCacheSetCapacity(capacity)
    check_status(status)


cpdef disable_cpu_instructions_set_mask(unsigned mask):
    """See `cublasLtDisableCpuInstructionsSetMask`."""
    with nogil:
        status = cublasLtDisableCpuInstructionsSetMask(mask)
    check_status(status)


cpdef tuple matmul_algo_get_ids(intptr_t light_handle, cublasComputeType_t compute_type, size_t scale_type, size_t atype, size_t btype, size_t ctype, size_t dtype, int requested_algo_count):
    cdef vector[int] algo_ids_array
    algo_ids_array.resize(requested_algo_count)
    cdef int return_algo_count
    with nogil:
        status = cublasLtMatmulAlgoGetIds(<Handle>light_handle, compute_type, <DataType>scale_type, <DataType>atype, <DataType>btype, <DataType>ctype, <DataType>dtype, requested_algo_count, algo_ids_array.data(), &return_algo_count)
    check_status(status)
    if return_algo_count < requested_algo_count:
        algo_ids_array.resize(return_algo_count)
    return tuple(algo_ids_array)
