/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.id;

import io.ray.api.id.BaseId;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TaskId
extends BaseId
implements Serializable {
    private static final int UNIQUE_BYTES_LENGTH = 8;
    public static final int LENGTH = 14;
    public static final TaskId NIL = TaskId.genNil();

    public static TaskId fromHexString(String hex) {
        return new TaskId(TaskId.hexString2Bytes(hex));
    }

    public static TaskId fromByteBuffer(ByteBuffer bb) {
        return new TaskId(TaskId.byteBuffer2Bytes(bb));
    }

    public static TaskId fromBytes(byte[] bytes) {
        return new TaskId(bytes);
    }

    private static TaskId genNil() {
        byte[] b = new byte[14];
        Arrays.fill(b, (byte)-1);
        return new TaskId(b);
    }

    private TaskId(byte[] id) {
        super(id);
    }

    @Override
    public int size() {
        return 14;
    }
}

