/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import com.google.common.base.Preconditions;
import io.ray.api.BaseActor;
import io.ray.api.id.JobId;
import io.ray.api.id.ObjectId;
import io.ray.api.id.UniqueId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.context.LocalModeWorkerContext;
import io.ray.runtime.object.LocalModeObjectStore;
import io.ray.runtime.task.LocalModeTaskExecutor;
import io.ray.runtime.task.LocalModeTaskSubmitter;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RayDevRuntime
extends AbstractRayRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayDevRuntime.class);
    private AtomicInteger jobCounter = new AtomicInteger(0);

    public RayDevRuntime(RayConfig rayConfig) {
        super(rayConfig);
    }

    @Override
    public void start() {
        if (this.rayConfig.getJobId().isNil()) {
            this.rayConfig.setJobId(this.nextJobId());
        }
        this.taskExecutor = new LocalModeTaskExecutor(this);
        this.workerContext = new LocalModeWorkerContext(this.rayConfig.getJobId());
        this.objectStore = new LocalModeObjectStore(this.workerContext);
        this.taskSubmitter = new LocalModeTaskSubmitter(this, this.taskExecutor, (LocalModeObjectStore)this.objectStore);
        ((LocalModeObjectStore)this.objectStore).addObjectPutCallback(objectId -> {
            if (this.taskSubmitter != null) {
                ((LocalModeTaskSubmitter)this.taskSubmitter).onObjectPut((ObjectId)objectId);
            }
        });
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        if (this.taskSubmitter != null) {
            ((LocalModeTaskSubmitter)this.taskSubmitter).shutdown();
            this.taskSubmitter = null;
        }
        this.taskExecutor = null;
        RayConfig.reset();
    }

    @Override
    public void setResource(String resourceName, double capacity, UniqueId nodeId) {
        LOGGER.error("Not implemented under SINGLE_PROCESS mode.");
    }

    @Override
    public void killActor(BaseActor actor, boolean noRestart) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAsyncContext() {
        return null;
    }

    @Override
    public void setAsyncContext(Object asyncContext) {
        Preconditions.checkArgument(asyncContext == null);
        super.setAsyncContext(asyncContext);
    }

    private JobId nextJobId() {
        return JobId.fromInt(this.jobCounter.getAndIncrement());
    }
}

