/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import com.google.common.base.Preconditions;
import io.ray.api.BaseActor;
import io.ray.api.id.JobId;
import io.ray.api.id.UniqueId;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.context.NativeWorkerContext;
import io.ray.runtime.gcs.GcsClient;
import io.ray.runtime.gcs.GcsClientOptions;
import io.ray.runtime.gcs.RedisClient;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeObjectStore;
import io.ray.runtime.runner.RunManager;
import io.ray.runtime.task.NativeTaskExecutor;
import io.ray.runtime.task.NativeTaskSubmitter;
import io.ray.runtime.task.TaskExecutor;
import io.ray.runtime.util.JniUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RayNativeRuntime
extends AbstractRayRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayNativeRuntime.class);
    private RunManager manager = null;

    private static void resetLibraryPath(RayConfig rayConfig) {
        String separator = System.getProperty("path.separator");
        String libraryPath = String.join((CharSequence)separator, rayConfig.libraryPath);
        JniUtils.resetLibraryPath(libraryPath);
    }

    public RayNativeRuntime(RayConfig rayConfig) {
        super(rayConfig);
    }

    @Override
    public void start() {
        if (this.rayConfig.getRedisAddress() == null) {
            this.manager = new RunManager(this.rayConfig);
            this.manager.startRayProcesses(true);
        }
        this.gcsClient = new GcsClient(this.rayConfig.getRedisAddress(), this.rayConfig.redisPassword);
        if (this.rayConfig.getJobId() == JobId.NIL) {
            this.rayConfig.setJobId(this.gcsClient.nextJobId());
        }
        int numWorkersPerProcess = this.rayConfig.workerMode == Common.WorkerType.DRIVER ? 1 : this.rayConfig.numWorkersPerProcess;
        RayNativeRuntime.nativeInitialize(this.rayConfig.workerMode.getNumber(), this.rayConfig.nodeIp, this.rayConfig.getNodeManagerPort(), this.rayConfig.workerMode == Common.WorkerType.DRIVER ? System.getProperty("user.dir") : "", this.rayConfig.objectStoreSocketName, this.rayConfig.rayletSocketName, (this.rayConfig.workerMode == Common.WorkerType.DRIVER ? this.rayConfig.getJobId() : JobId.NIL).getBytes(), new GcsClientOptions(this.rayConfig), numWorkersPerProcess, this.rayConfig.logDir, this.rayConfig.rayletConfigParameters);
        this.taskExecutor = new NativeTaskExecutor(this);
        this.workerContext = new NativeWorkerContext();
        this.objectStore = new NativeObjectStore(this.workerContext);
        this.taskSubmitter = new NativeTaskSubmitter();
        LOGGER.debug("RayNativeRuntime started with store {}, raylet {}", (Object)this.rayConfig.objectStoreSocketName, (Object)this.rayConfig.rayletSocketName);
    }

    @Override
    public void shutdown() {
        if (this.rayConfig.workerMode == Common.WorkerType.DRIVER) {
            RayNativeRuntime.nativeShutdown();
            if (null != this.manager) {
                this.manager.cleanup();
                this.manager = null;
            }
        }
        if (null != this.gcsClient) {
            this.gcsClient.destroy();
            this.gcsClient = null;
        }
        RayConfig.reset();
        LOGGER.debug("RayNativeRuntime shutdown");
    }

    public RunManager getRunManager() {
        return this.manager;
    }

    @Override
    public void setResource(String resourceName, double capacity, UniqueId nodeId) {
        Preconditions.checkArgument(Double.compare(capacity, 0.0) >= 0);
        if (nodeId == null) {
            nodeId = UniqueId.NIL;
        }
        RayNativeRuntime.nativeSetResource(resourceName, capacity, nodeId.getBytes());
    }

    @Override
    public void killActor(BaseActor actor, boolean noRestart) {
        RayNativeRuntime.nativeKillActor(actor.getId().getBytes(), noRestart);
    }

    @Override
    public Object getAsyncContext() {
        return new AsyncContext(this.workerContext.getCurrentWorkerId(), this.workerContext.getCurrentClassLoader());
    }

    @Override
    public void setAsyncContext(Object asyncContext) {
        RayNativeRuntime.nativeSetCoreWorker(((AsyncContext)asyncContext).workerId.getBytes());
        this.workerContext.setCurrentClassLoader(((AsyncContext)asyncContext).currentClassLoader);
        super.setAsyncContext(asyncContext);
    }

    @Override
    public void run() {
        Preconditions.checkState(this.rayConfig.workerMode == Common.WorkerType.WORKER);
        RayNativeRuntime.nativeRunTaskExecutor(this.taskExecutor);
    }

    private static native void nativeInitialize(int var0, String var1, int var2, String var3, String var4, String var5, byte[] var6, GcsClientOptions var7, int var8, String var9, Map<String, String> var10);

    private static native void nativeRunTaskExecutor(TaskExecutor var0);

    private static native void nativeShutdown();

    private static native void nativeSetResource(String var0, double var1, byte[] var3);

    private static native void nativeKillActor(byte[] var0, boolean var1);

    private static native void nativeSetCoreWorker(byte[] var0);

    static {
        LOGGER.debug("Loading native libraries.");
        RayConfig rayConfig = RayConfig.getInstance();
        if (rayConfig.getRedisAddress() != null && rayConfig.workerMode == Common.WorkerType.DRIVER) {
            RedisClient client = new RedisClient(rayConfig.getRedisAddress(), rayConfig.redisPassword);
            String sessionDir = client.get("session_dir", null);
            Preconditions.checkNotNull(sessionDir);
            rayConfig.setSessionDir(sessionDir);
        }
        JniUtils.loadLibrary("core_worker_library_java", true);
        LOGGER.debug("Native libraries loaded.");
        RayNativeRuntime.resetLibraryPath(rayConfig);
        try {
            FileUtils.forceMkdir(new File(rayConfig.logDir));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the log directory.", e);
        }
    }

    static class AsyncContext {
        public final UniqueId workerId;
        public final ClassLoader currentClassLoader;

        AsyncContext(UniqueId workerId, ClassLoader currentClassLoader) {
            this.workerId = workerId;
            this.currentClassLoader = currentClassLoader;
        }
    }
}

