/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.context;

import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.generated.Common;
import java.nio.ByteBuffer;

public class NativeWorkerContext
implements WorkerContext {
    private final ThreadLocal<ClassLoader> currentClassLoader = new ThreadLocal();

    @Override
    public UniqueId getCurrentWorkerId() {
        return UniqueId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentWorkerId());
    }

    @Override
    public JobId getCurrentJobId() {
        return JobId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentJobId());
    }

    @Override
    public ActorId getCurrentActorId() {
        return ActorId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentActorId());
    }

    @Override
    public ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader.get();
    }

    @Override
    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        if (this.currentClassLoader.get() != currentClassLoader) {
            this.currentClassLoader.set(currentClassLoader);
        }
    }

    @Override
    public Common.TaskType getCurrentTaskType() {
        return Common.TaskType.forNumber(NativeWorkerContext.nativeGetCurrentTaskType());
    }

    @Override
    public TaskId getCurrentTaskId() {
        return TaskId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentTaskId());
    }

    private static native int nativeGetCurrentTaskType();

    private static native ByteBuffer nativeGetCurrentTaskId();

    private static native ByteBuffer nativeGetCurrentJobId();

    private static native ByteBuffer nativeGetCurrentWorkerId();

    private static native ByteBuffer nativeGetCurrentActorId();
}

