/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.context;

import com.google.common.base.Preconditions;
import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.runtimecontext.NodeInfo;
import io.ray.api.runtimecontext.RuntimeContext;
import io.ray.runtime.RayRuntimeInternal;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.generated.Common;
import java.util.List;

public class RuntimeContextImpl
implements RuntimeContext {
    private RayRuntimeInternal runtime;

    public RuntimeContextImpl(RayRuntimeInternal runtime) {
        this.runtime = runtime;
    }

    @Override
    public JobId getCurrentJobId() {
        return this.runtime.getWorkerContext().getCurrentJobId();
    }

    @Override
    public ActorId getCurrentActorId() {
        ActorId actorId = this.runtime.getWorkerContext().getCurrentActorId();
        Preconditions.checkState(actorId != null && !actorId.isNil(), "This method should only be called from an actor.");
        return actorId;
    }

    @Override
    public boolean wasCurrentActorRestarted() {
        Common.TaskType currentTaskType = this.runtime.getWorkerContext().getCurrentTaskType();
        Preconditions.checkState(currentTaskType == Common.TaskType.ACTOR_CREATION_TASK, "This method can only be called from an actor creation task.");
        if (this.isSingleProcess()) {
            return false;
        }
        return this.runtime.getGcsClient().wasCurrentActorRestarted(this.getCurrentActorId());
    }

    @Override
    public String getRayletSocketName() {
        return this.runtime.getRayConfig().rayletSocketName;
    }

    @Override
    public String getObjectStoreSocketName() {
        return this.runtime.getRayConfig().objectStoreSocketName;
    }

    @Override
    public boolean isSingleProcess() {
        return RunMode.SINGLE_PROCESS == this.runtime.getRayConfig().runMode;
    }

    @Override
    public List<NodeInfo> getAllNodeInfo() {
        return this.runtime.getGcsClient().getAllNodeInfo();
    }
}

