/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.gcs;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ray.api.Checkpointable;
import io.ray.api.id.ActorId;
import io.ray.api.id.BaseId;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.api.runtimecontext.NodeInfo;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.gcs.GlobalStateAccessor;
import io.ray.runtime.gcs.RedisClient;
import io.ray.runtime.generated.Gcs;
import io.ray.runtime.util.IdUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsClient {
    private static Logger LOGGER = LoggerFactory.getLogger(GcsClient.class);
    private RedisClient primary;
    private List<RedisClient> shards;
    private GlobalStateAccessor globalStateAccessor;

    public GcsClient(String redisAddress, String redisPassword) {
        this.primary = new RedisClient(redisAddress, redisPassword);
        int numShards = 0;
        try {
            numShards = Integer.valueOf(this.primary.get("NumRedisShards", null));
            Preconditions.checkState(numShards > 0, String.format("Expected at least one Redis shards, found %d.", numShards));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get number of redis shards.", e);
        }
        List<byte[]> shardAddresses = this.primary.lrange("RedisShards".getBytes(), 0L, -1L);
        Preconditions.checkState(shardAddresses.size() == numShards);
        this.shards = shardAddresses.stream().map(address -> new RedisClient(new String((byte[])address), redisPassword)).collect(Collectors.toList());
        this.globalStateAccessor = GlobalStateAccessor.getInstance(redisAddress, redisPassword);
    }

    public List<NodeInfo> getAllNodeInfo() {
        List<byte[]> results = this.globalStateAccessor.getAllNodeInfo();
        HashMap<UniqueId, NodeInfo> nodes = new HashMap<UniqueId, NodeInfo>();
        for (byte[] byArray : results) {
            NodeInfo nodeInfo;
            Preconditions.checkNotNull(byArray);
            Gcs.GcsNodeInfo data = null;
            try {
                data = Gcs.GcsNodeInfo.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Received invalid protobuf data from GCS.");
            }
            UniqueId nodeId = UniqueId.fromByteBuffer(data.getNodeId().asReadOnlyByteBuffer());
            if (data.getState() == Gcs.GcsNodeInfo.GcsNodeState.ALIVE) {
                nodeInfo = new NodeInfo(nodeId, data.getNodeManagerAddress(), data.getNodeManagerHostname(), true, new HashMap<String, Double>());
                nodes.put(nodeId, nodeInfo);
                continue;
            }
            nodeInfo = new NodeInfo(nodeId, ((NodeInfo)nodes.get((Object)nodeId)).nodeAddress, ((NodeInfo)nodes.get((Object)nodeId)).nodeHostname, false, new HashMap<String, Double>());
            nodes.put(nodeId, nodeInfo);
        }
        for (Map.Entry entry : nodes.entrySet()) {
            if (!((NodeInfo)entry.getValue()).isAlive) continue;
            ((NodeInfo)entry.getValue()).resources.putAll(this.getResourcesForClient((UniqueId)entry.getKey()));
        }
        return new ArrayList<NodeInfo>(nodes.values());
    }

    private Map<String, Double> getResourcesForClient(UniqueId clientId) {
        Gcs.ResourceMap resourceMap;
        byte[] resourceMapBytes = this.globalStateAccessor.getNodeResourceInfo(clientId);
        try {
            resourceMap = Gcs.ResourceMap.parseFrom(resourceMapBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received invalid protobuf data from GCS.");
        }
        HashMap<String, Double> resources = new HashMap<String, Double>();
        for (Map.Entry<String, Gcs.ResourceTableData> entry : resourceMap.getItemsMap().entrySet()) {
            resources.put(entry.getKey(), entry.getValue().getResourceCapacity());
        }
        return resources;
    }

    public boolean actorExists(ActorId actorId) {
        byte[] result = this.globalStateAccessor.getActorInfo(actorId);
        return result != null;
    }

    public boolean wasCurrentActorRestarted(ActorId actorId) {
        byte[] key = ArrayUtils.addAll(Gcs.TablePrefix.ACTOR.toString().getBytes(), actorId.getBytes());
        if (!RayConfig.getInstance().gcsServiceEnabled) {
            return this.primary.exists(key);
        }
        byte[] value = this.globalStateAccessor.getActorInfo(actorId);
        if (value == null) {
            return false;
        }
        Gcs.ActorTableData actorTableData = null;
        try {
            actorTableData = Gcs.ActorTableData.parseFrom(value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received invalid protobuf data from GCS.");
        }
        return actorTableData.getNumRestarts() != 0L;
    }

    public boolean rayletTaskExistsInGcs(TaskId taskId) {
        byte[] key = ArrayUtils.addAll(Gcs.TablePrefix.RAYLET_TASK.toString().getBytes(), taskId.getBytes());
        RedisClient client = this.getShardClient(taskId);
        return client.exists(key);
    }

    public List<Checkpointable.Checkpoint> getCheckpointsForActor(ActorId actorId) {
        ArrayList<Checkpointable.Checkpoint> checkpoints = new ArrayList<Checkpointable.Checkpoint>();
        byte[] result = this.globalStateAccessor.getActorCheckpointId(actorId);
        if (result != null) {
            int i;
            Gcs.ActorCheckpointIdData data = null;
            try {
                data = Gcs.ActorCheckpointIdData.parseFrom(result);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Received invalid protobuf data from GCS.");
            }
            UniqueId[] checkpointIds = new UniqueId[data.getCheckpointIdsCount()];
            for (i = 0; i < checkpointIds.length; ++i) {
                checkpointIds[i] = UniqueId.fromByteBuffer(data.getCheckpointIds(i).asReadOnlyByteBuffer());
            }
            for (i = 0; i < checkpointIds.length; ++i) {
                checkpoints.add(new Checkpointable.Checkpoint(checkpointIds[i], data.getTimestamps(i)));
            }
        }
        checkpoints.sort((x, y) -> Long.compare(y.timestamp, x.timestamp));
        return checkpoints;
    }

    public JobId nextJobId() {
        int jobCounter = (int)this.primary.incr("JobCounter".getBytes());
        return JobId.fromInt(jobCounter);
    }

    public void destroy() {
        LOGGER.debug("Destroying global state accessor.");
        GlobalStateAccessor.destroyInstance();
    }

    private RedisClient getShardClient(BaseId key) {
        return this.shards.get((int)Long.remainderUnsigned(IdUtil.murmurHashCode(key), this.shards.size()));
    }
}

