/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.Ray;
import io.ray.api.RayObject;
import io.ray.api.id.ObjectId;
import java.io.Serializable;

public final class RayObjectImpl<T>
implements RayObject<T>,
Serializable {
    private final ObjectId id;
    private transient T object;
    private Class<T> type;
    private transient boolean objectGotten;

    public RayObjectImpl(ObjectId id, Class<T> type) {
        this.id = id;
        this.type = type;
        this.object = null;
        this.objectGotten = false;
    }

    @Override
    public synchronized T get() {
        if (!this.objectGotten) {
            this.object = Ray.get(this.id, this.type);
            this.objectGotten = true;
        }
        return this.object;
    }

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

