/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import io.ray.api.Ray;
import io.ray.api.RayObject;
import io.ray.api.id.ObjectId;
import io.ray.runtime.RayRuntimeInternal;
import io.ray.runtime.generated.Common;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.object.ObjectSerializer;
import io.ray.runtime.task.FunctionArg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArgumentsBuilder {
    private static final int LARGEST_SIZE_PASS_BY_VALUE = 102400;
    private static final NativeRayObject PYTHON_DUMMY_TYPE = ObjectSerializer.serialize("__RAY_DUMMY__".getBytes());

    public static List<FunctionArg> wrap(Object[] args, Common.Language language) {
        ArrayList<FunctionArg> ret = new ArrayList<FunctionArg>();
        for (Object arg : args) {
            ObjectId id = null;
            NativeRayObject value = null;
            if (arg instanceof RayObject) {
                id = ((RayObject)arg).getId();
            } else {
                value = ObjectSerializer.serialize(arg);
                if (language != Common.Language.JAVA) {
                    boolean isCrossData;
                    boolean bl = isCrossData = Arrays.equals(value.metadata, ObjectSerializer.OBJECT_METADATA_TYPE_CROSS_LANGUAGE) || Arrays.equals(value.metadata, ObjectSerializer.OBJECT_METADATA_TYPE_RAW);
                    if (!isCrossData) {
                        throw new IllegalArgumentException(String.format("Can't transfer %s data to %s", Arrays.toString(value.metadata), language.getValueDescriptor().getName()));
                    }
                }
                if (value.data.length > 102400) {
                    id = ((RayRuntimeInternal)Ray.internal()).getObjectStore().putRaw(value);
                    value = null;
                }
            }
            if (language == Common.Language.PYTHON) {
                ret.add(FunctionArg.passByValue(PYTHON_DUMMY_TYPE));
            }
            if (id != null) {
                ret.add(FunctionArg.passByReference(id));
                continue;
            }
            ret.add(FunctionArg.passByValue(value));
        }
        return ret;
    }

    public static Object[] unwrap(List<NativeRayObject> args, Class<?>[] types) {
        Object[] realArgs = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            realArgs[i] = ObjectSerializer.deserialize(args.get(i), null, types[i]);
        }
        return realArgs;
    }
}

