/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import com.google.common.base.Preconditions;
import io.ray.api.Checkpointable;
import io.ray.api.id.ActorId;
import io.ray.api.id.UniqueId;
import io.ray.runtime.RayRuntimeInternal;
import io.ray.runtime.task.TaskExecutor;
import java.util.ArrayList;
import java.util.List;

public class NativeTaskExecutor
extends TaskExecutor<NativeActorContext> {
    private static final int NUM_ACTOR_CHECKPOINTS_TO_KEEP = 20;

    public NativeTaskExecutor(RayRuntimeInternal runtime) {
        super(runtime);
    }

    @Override
    protected NativeActorContext createActorContext() {
        return new NativeActorContext();
    }

    @Override
    protected void maybeSaveCheckpoint(Object actor, ActorId actorId) {
        if (!(actor instanceof Checkpointable)) {
            return;
        }
        Checkpointable checkpointable = (Checkpointable)actor;
        NativeActorContext actorContext = (NativeActorContext)this.getActorContext();
        Checkpointable.CheckpointContext checkpointContext = new Checkpointable.CheckpointContext(actorId, ++actorContext.numTasksSinceLastCheckpoint, System.currentTimeMillis() - actorContext.lastCheckpointTimestamp);
        if (!checkpointable.shouldCheckpoint(checkpointContext)) {
            return;
        }
        actorContext.numTasksSinceLastCheckpoint = 0;
        actorContext.lastCheckpointTimestamp = System.currentTimeMillis();
        UniqueId checkpointId = new UniqueId(NativeTaskExecutor.nativePrepareCheckpoint());
        List checkpointIds = actorContext.checkpointIds;
        checkpointIds.add(checkpointId);
        if (checkpointIds.size() > 20) {
            ((Checkpointable)actor).checkpointExpired(actorId, (UniqueId)checkpointIds.get(0));
            checkpointIds.remove(0);
        }
        checkpointable.saveCheckpoint(actorId, checkpointId);
    }

    @Override
    protected void maybeLoadCheckpoint(Object actor, ActorId actorId) {
        if (!(actor instanceof Checkpointable)) {
            return;
        }
        NativeActorContext actorContext = (NativeActorContext)this.getActorContext();
        actorContext.numTasksSinceLastCheckpoint = 0;
        actorContext.lastCheckpointTimestamp = System.currentTimeMillis();
        actorContext.checkpointIds = new ArrayList();
        List<Checkpointable.Checkpoint> availableCheckpoints = this.runtime.getGcsClient().getCheckpointsForActor(actorId);
        if (availableCheckpoints.isEmpty()) {
            return;
        }
        UniqueId checkpointId = ((Checkpointable)actor).loadCheckpoint(actorId, availableCheckpoints);
        if (checkpointId != null) {
            boolean checkpointValid = false;
            for (Checkpointable.Checkpoint checkpoint : availableCheckpoints) {
                if (!checkpoint.checkpointId.equals(checkpointId)) continue;
                checkpointValid = true;
                break;
            }
            Preconditions.checkArgument(checkpointValid, "'loadCheckpoint' must return a checkpoint ID that exists in the 'availableCheckpoints' list, or null.");
            NativeTaskExecutor.nativeNotifyActorResumedFromCheckpoint(checkpointId.getBytes());
        }
    }

    private static native byte[] nativePrepareCheckpoint();

    private static native void nativeNotifyActorResumedFromCheckpoint(byte[] var0);

    static class NativeActorContext
    extends TaskExecutor.ActorContext {
        private int numTasksSinceLastCheckpoint = 0;
        private List<UniqueId> checkpointIds;
        private long lastCheckpointTimestamp = 0L;

        NativeActorContext() {
        }
    }
}

