/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.python;

import com.google.common.base.Preconditions;
import io.ray.streaming.api.partition.Partition;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class PythonPartition
implements Partition<Object> {
    public static final PythonPartition BroadcastPartition = new PythonPartition("ray.streaming.partition", "BroadcastPartition");
    public static final PythonPartition KeyPartition = new PythonPartition("ray.streaming.partition", "KeyPartition");
    public static final PythonPartition RoundRobinPartition = new PythonPartition("ray.streaming.partition", "RoundRobinPartition");
    private byte[] partition;
    private String moduleName;
    private String functionName;

    public PythonPartition(byte[] partition) {
        Preconditions.checkNotNull(partition);
        this.partition = partition;
    }

    public PythonPartition(String moduleName, String functionName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(moduleName));
        Preconditions.checkArgument(StringUtils.isNotBlank(functionName));
        this.moduleName = moduleName;
        this.functionName = functionName;
    }

    @Override
    public int[] partition(Object record, int numPartition) {
        String msg = String.format("partition method of %s shouldn't be called.", this.getClass().getSimpleName());
        throw new UnsupportedOperationException(msg);
    }

    public byte[] getPartition() {
        return this.partition;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", PythonPartition.class.getSimpleName() + "[", "]");
        if (this.partition != null) {
            stringJoiner.add("partition=binary partition");
        } else {
            stringJoiner.add("moduleName='" + this.moduleName + "'").add("functionName='" + this.functionName + "'");
        }
        return stringJoiner.toString();
    }
}

