/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph;

import io.ray.api.BaseActor;
import io.ray.streaming.runtime.core.graph.ExecutionNode;
import io.ray.streaming.runtime.core.graph.ExecutionTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExecutionGraph
implements Serializable {
    private long buildTime;
    private List<ExecutionNode> executionNodeList;
    private List<BaseActor> sourceWorkers = new ArrayList<BaseActor>();
    private List<BaseActor> sinkWorkers = new ArrayList<BaseActor>();

    public ExecutionGraph(List<ExecutionNode> executionNodes) {
        this.executionNodeList = executionNodes;
        for (ExecutionNode executionNode : this.executionNodeList) {
            List actors;
            if (executionNode.getNodeType() == ExecutionNode.NodeType.SOURCE) {
                actors = executionNode.getExecutionTasks().stream().map(ExecutionTask::getWorker).collect(Collectors.toList());
                this.sourceWorkers.addAll(actors);
            }
            if (executionNode.getNodeType() != ExecutionNode.NodeType.SINK) continue;
            actors = executionNode.getExecutionTasks().stream().map(ExecutionTask::getWorker).collect(Collectors.toList());
            this.sinkWorkers.addAll(actors);
        }
        this.buildTime = System.currentTimeMillis();
    }

    public List<BaseActor> getSourceWorkers() {
        return this.sourceWorkers;
    }

    public List<BaseActor> getSinkWorkers() {
        return this.sinkWorkers;
    }

    public List<ExecutionNode> getExecutionNodeList() {
        return this.executionNodeList;
    }

    public ExecutionTask getExecutionTaskByTaskId(int taskId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            for (ExecutionTask executionTask : executionNode.getExecutionTasks()) {
                if (executionTask.getTaskId() != taskId) continue;
                return executionTask;
            }
        }
        throw new RuntimeException("Task " + taskId + " does not exist!");
    }

    public ExecutionNode getExecutionNodeByNodeId(int nodeId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            if (executionNode.getNodeId() != nodeId) continue;
            return executionNode;
        }
        throw new RuntimeException("Node " + nodeId + " does not exist!");
    }

    public ExecutionNode getExecutionNodeByTaskId(int taskId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            for (ExecutionTask executionTask : executionNode.getExecutionTasks()) {
                if (executionTask.getTaskId() != taskId) continue;
                return executionNode;
            }
        }
        throw new RuntimeException("Task " + taskId + " does not exist!");
    }

    public Map<Integer, BaseActor> getTaskId2WorkerByNodeId(int nodeId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            if (executionNode.getNodeId() != nodeId) continue;
            HashMap<Integer, BaseActor> taskId2Worker = new HashMap<Integer, BaseActor>();
            for (ExecutionTask executionTask : executionNode.getExecutionTasks()) {
                taskId2Worker.put(executionTask.getTaskId(), executionTask.getWorker());
            }
            return taskId2Worker;
        }
        throw new RuntimeException("Node " + nodeId + " does not exist!");
    }

    public long getBuildTime() {
        return this.buildTime;
    }
}

