/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.resource;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.ray.api.id.UniqueId;
import io.ray.api.runtimecontext.NodeInfo;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import io.ray.streaming.runtime.core.resource.ContainerID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Container
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Container.class);
    private ContainerID id;
    private String address;
    private String hostname;
    private UniqueId nodeId;
    private Map<String, Double> availableResources = new HashMap<String, Double>();
    private List<Integer> executionVertexIds = new ArrayList<Integer>();
    private int capacity = 0;

    public Container() {
    }

    public Container(String address, UniqueId nodeId, String hostname, Map<String, Double> availableResources) {
        this.id = new ContainerID();
        this.address = address;
        this.hostname = hostname;
        this.nodeId = nodeId;
        this.availableResources = availableResources;
    }

    public static Container from(NodeInfo nodeInfo) {
        return new Container(nodeInfo.nodeAddress, nodeInfo.nodeId, nodeInfo.nodeHostname, nodeInfo.resources);
    }

    public ContainerID getId() {
        return this.id;
    }

    public void setId(ContainerID id) {
        this.id = id;
    }

    public String getName() {
        return this.id.toString();
    }

    public String getAddress() {
        return this.address;
    }

    public UniqueId getNodeId() {
        return this.nodeId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Map<String, Double> getAvailableResources() {
        return this.availableResources;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void updateCapacity(int capacity) {
        LOG.info("Update container capacity, old value: {}, new value: {}.", (Object)this.capacity, (Object)capacity);
        this.capacity = capacity;
    }

    public int getRemainingCapacity() {
        return this.capacity - this.getAllocatedActorNum();
    }

    public int getAllocatedActorNum() {
        return this.executionVertexIds.size();
    }

    public boolean isFull() {
        return this.getAllocatedActorNum() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.getAllocatedActorNum() == 0;
    }

    public void allocateActor(ExecutionVertex vertex) {
        LOG.info("Allocating vertex [{}] in container [{}].", (Object)vertex, (Object)this);
        this.executionVertexIds.add(vertex.getId());
        vertex.setContainerIfNotExist(this.getId());
        vertex.getResources().put(this.getName(), 1.0);
        this.decreaseResource(vertex.getResources());
    }

    public void releaseActor(ExecutionVertex vertex) {
        LOG.info("Release actor, vertex: {}, container: {}.", (Object)vertex, (Object)vertex.getContainerId());
        if (!this.executionVertexIds.contains(vertex.getId())) {
            throw new RuntimeException(String.format("Current container [%s] not found vertex [%s].", this, vertex.getJobVertexName()));
        }
        this.executionVertexIds.removeIf(id -> id.intValue() == vertex.getId());
        this.reclaimResource(vertex.getResources());
    }

    public List<Integer> getExecutionVertexIds() {
        return this.executionVertexIds;
    }

    private void decreaseResource(Map<String, Double> allocatedResource) {
        allocatedResource.forEach((k, v) -> {
            Preconditions.checkArgument(this.availableResources.get(k) >= v, String.format("Available resource %s not >= decreased resource %s", this.availableResources.get(k), v));
            Double newValue = this.availableResources.get(k) - v;
            LOG.info("Decrease container {} resource [{}], from {} to {}.", this.address, k, this.availableResources.get(k), newValue);
            this.availableResources.put((String)k, newValue);
        });
    }

    private void reclaimResource(Map<String, Double> allocatedResource) {
        allocatedResource.forEach((k, v) -> {
            Double newValue = this.availableResources.get(k) + v;
            LOG.info("Reclaim container {} resource [{}], from {} to {}.", this.address, k, this.availableResources.get(k), newValue);
            this.availableResources.put((String)k, newValue);
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("address", this.address).add("hostname", this.hostname).add("nodeId", this.nodeId).add("availableResources", this.availableResources).add("executionVertexIds", this.executionVertexIds).add("capacity", this.capacity).toString();
    }
}

