/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.backend;

import io.ray.streaming.state.StateStoreManager;
import io.ray.streaming.state.backend.AbstractStateBackend;
import io.ray.streaming.state.backend.BackendType;
import io.ray.streaming.state.backend.StateStrategy;
import io.ray.streaming.state.keystate.desc.AbstractStateDescriptor;
import io.ray.streaming.state.keystate.state.proxy.ListStateStoreManagerProxy;
import io.ray.streaming.state.keystate.state.proxy.MapStateStoreManagerProxy;
import io.ray.streaming.state.keystate.state.proxy.ValueStateStoreManagerProxy;
import io.ray.streaming.state.store.KeyMapStore;
import io.ray.streaming.state.store.KeyValueStore;
import io.ray.streaming.state.strategy.StateStoreManagerProxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyStateBackend
implements StateStoreManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKeyStateBackend.class);
    protected long currentCheckpointId;
    protected Object currentKey;
    protected int keyGroupIndex = -1;
    protected Map<String, ValueStateStoreManagerProxy> valueManagerProxyHashMap = new HashMap<String, ValueStateStoreManagerProxy>();
    protected Map<String, ListStateStoreManagerProxy> listManagerProxyHashMap = new HashMap<String, ListStateStoreManagerProxy>();
    protected Map<String, MapStateStoreManagerProxy> mapManagerProxyHashMap = new HashMap<String, MapStateStoreManagerProxy>();
    protected Set<String> descNamespace;
    protected Map<String, KeyValueStore<String, Map<Long, byte[]>>> backStorageCache = new HashMap<String, KeyValueStore<String, Map<Long, byte[]>>>();
    private AbstractStateBackend backend;

    public AbstractKeyStateBackend(AbstractStateBackend backend) {
        this.backend = backend;
        this.descNamespace = new HashSet<String>();
    }

    public <K, T> void put(AbstractStateDescriptor descriptor, K key, T value) {
        String desc = descriptor.getIdentify();
        if (descriptor.getStateType() == AbstractStateDescriptor.StateType.VALUE) {
            if (this.valueManagerProxyHashMap.containsKey(desc)) {
                this.valueManagerProxyHashMap.get(desc).put((String)key, value);
            }
        } else if (descriptor.getStateType() == AbstractStateDescriptor.StateType.LIST) {
            if (this.listManagerProxyHashMap.containsKey(desc)) {
                this.listManagerProxyHashMap.get(desc).put((String)key, value);
            }
        } else if (descriptor.getStateType() == AbstractStateDescriptor.StateType.MAP && this.mapManagerProxyHashMap.containsKey(desc)) {
            this.mapManagerProxyHashMap.get(desc).put((String)key, value);
        }
    }

    public <K, T> T get(AbstractStateDescriptor descriptor, K key) {
        String desc = descriptor.getIdentify();
        if (descriptor.getStateType() == AbstractStateDescriptor.StateType.VALUE) {
            if (this.valueManagerProxyHashMap.containsKey(desc)) {
                return (T)this.valueManagerProxyHashMap.get(desc).get((String)key);
            }
        } else if (descriptor.getStateType() == AbstractStateDescriptor.StateType.LIST) {
            if (this.listManagerProxyHashMap.containsKey(desc)) {
                return (T)this.listManagerProxyHashMap.get(desc).get((String)key);
            }
        } else if (descriptor.getStateType() == AbstractStateDescriptor.StateType.MAP && this.mapManagerProxyHashMap.containsKey(desc)) {
            return (T)this.mapManagerProxyHashMap.get(desc).get((String)key);
        }
        return null;
    }

    @Override
    public void finish(long checkpointId) {
        for (Map.Entry<String, ValueStateStoreManagerProxy> entry : this.valueManagerProxyHashMap.entrySet()) {
            entry.getValue().finish(checkpointId);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.listManagerProxyHashMap.entrySet()) {
            ((ListStateStoreManagerProxy)entry.getValue()).finish(checkpointId);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.mapManagerProxyHashMap.entrySet()) {
            ((MapStateStoreManagerProxy)entry.getValue()).finish(checkpointId);
        }
    }

    @Override
    public void commit(long checkpointId) {
        for (Map.Entry<String, ValueStateStoreManagerProxy> entry : this.valueManagerProxyHashMap.entrySet()) {
            entry.getValue().commit(checkpointId);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.listManagerProxyHashMap.entrySet()) {
            ((ListStateStoreManagerProxy)entry.getValue()).commit(checkpointId);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.mapManagerProxyHashMap.entrySet()) {
            ((MapStateStoreManagerProxy)entry.getValue()).commit(checkpointId);
        }
    }

    @Override
    public void ackCommit(long checkpointId, long timeStamp) {
        for (Map.Entry<String, ValueStateStoreManagerProxy> entry : this.valueManagerProxyHashMap.entrySet()) {
            entry.getValue().ackCommit(checkpointId, timeStamp);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.listManagerProxyHashMap.entrySet()) {
            ((ListStateStoreManagerProxy)entry.getValue()).ackCommit(checkpointId, timeStamp);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.mapManagerProxyHashMap.entrySet()) {
            ((MapStateStoreManagerProxy)entry.getValue()).ackCommit(checkpointId, timeStamp);
        }
    }

    @Override
    public void rollBack(long checkpointId) {
        for (Map.Entry<String, ValueStateStoreManagerProxy> entry : this.valueManagerProxyHashMap.entrySet()) {
            LOG.warn("backend rollback:{},{}", (Object)entry.getKey(), (Object)checkpointId);
            entry.getValue().rollBack(checkpointId);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.listManagerProxyHashMap.entrySet()) {
            LOG.warn("backend rollback:{},{}", (Object)entry.getKey(), (Object)checkpointId);
            ((ListStateStoreManagerProxy)entry.getValue()).rollBack(checkpointId);
        }
        for (Map.Entry<String, StateStoreManagerProxy> entry : this.mapManagerProxyHashMap.entrySet()) {
            LOG.warn("backend rollback:{},{}", (Object)entry.getKey(), (Object)checkpointId);
            ((MapStateStoreManagerProxy)entry.getValue()).rollBack(checkpointId);
        }
    }

    public KeyValueStore<String, Map<Long, byte[]>> getBackStorage(String tableName) {
        if (this.backStorageCache.containsKey(tableName)) {
            return this.backStorageCache.get(tableName);
        }
        KeyMapStore<String, Long, byte[]> ikvStore = this.backend.getKeyMapStore(tableName);
        this.backStorageCache.put(tableName, ikvStore);
        return ikvStore;
    }

    public KeyValueStore<String, Map<Long, byte[]>> getBackStorage(AbstractStateDescriptor stateDescriptor) {
        String tableName = this.backend.getTableName(stateDescriptor);
        return this.getBackStorage(tableName);
    }

    public StateStrategy getStateStrategy() {
        return this.backend.getStateStrategy();
    }

    public BackendType getBackendType() {
        return this.backend.getBackendType();
    }

    public Object getCurrentKey() {
        return this.currentKey;
    }

    public abstract void setCurrentKey(Object var1);

    public long getCheckpointId() {
        return this.currentCheckpointId;
    }

    public void setCheckpointId(long checkpointId) {
        this.currentCheckpointId = checkpointId;
    }

    public void setContext(long checkpointId, Object currentKey) {
        this.setCheckpointId(checkpointId);
        this.setCurrentKey(currentKey);
    }

    public AbstractStateBackend getBackend() {
        return this.backend;
    }

    public int getKeyGroupIndex() {
        return this.keyGroupIndex;
    }

    public void setKeyGroupIndex(int keyGroupIndex) {
        this.keyGroupIndex = keyGroupIndex;
    }
}

