/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate;

import com.google.common.base.Preconditions;
import java.io.Serializable;

public class KeyGroup
implements Serializable {
    private final int startIndex;
    private final int endIndex;

    public KeyGroup(int startIndex, int endIndex) {
        Preconditions.checkArgument(startIndex >= 0 && startIndex <= endIndex);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        Preconditions.checkArgument(this.size() >= 0, "overflow detected.");
    }

    public int size() {
        return 1 + this.endIndex - this.startIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String toString() {
        return "KeyGroup{startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + '}';
    }
}

