/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate.desc;

import io.ray.streaming.state.keystate.desc.AbstractStateDescriptor;
import io.ray.streaming.state.keystate.state.ListState;

public class ListStateDescriptor<T>
extends AbstractStateDescriptor<ListState<T>, T> {
    private final boolean isOperatorList;
    private int index;
    private int partitionNum;

    private ListStateDescriptor(String name, Class<T> type, boolean isOperatorList) {
        super(name, type);
        this.isOperatorList = isOperatorList;
    }

    public static <T> ListStateDescriptor<T> build(String name, Class<T> type) {
        return ListStateDescriptor.build(name, type, false);
    }

    public static <T> ListStateDescriptor<T> build(String name, Class<T> type, boolean isOperatorList) {
        return new ListStateDescriptor<T>(name, type, isOperatorList);
    }

    public boolean isOperatorList() {
        return this.isOperatorList;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getPartitionNumber() {
        return this.partitionNum;
    }

    public void setPartitionNumber(int number) {
        this.partitionNum = number;
    }

    @Override
    public AbstractStateDescriptor.StateType getStateType() {
        return AbstractStateDescriptor.StateType.LIST;
    }

    @Override
    public String getIdentify() {
        if (this.isOperatorList) {
            return String.format("%s%s%d%s%d", super.getIdentify(), "\u0001\b", this.partitionNum, "\u0001\b", this.index);
        }
        return super.getIdentify();
    }
}

