function(add_code_generate_targets)

  foreach(_target ${ARGN})
    #check whether targets are already set up correctly
    if( TARGET ${_target} )
      #obtain compile definitions
      get_target_property( compiledefs ${_target} COMPILE_DEFINITIONS )
      string(REPLACE "compiledefs-NOTFOUND" "" compiledefs "${compiledefs}")

      #optain sources target depends on
      get_target_property( compilesources ${_target} SOURCES )
      string(REPLACE "compilesources-NOTFOUND" "" compilesources "${compilesources}")

      #Add targets and executables
      add_executable( ${_target}_codegenerator EXCLUDE_FROM_ALL "${compilesources}" )
      set_property(TARGET ${_target}_codegenerator APPEND PROPERTY COMPILE_DEFINITIONS "NDEBUG;BASEFUNCTIONSET_CODEGEN_GENERATE;${compiledefs}")
      dune_target_enable_all_packages( ${_target}_codegenerator )

      add_executable( ${_target}_optimized EXCLUDE_FROM_ALL "${compilesources}" )
      set_property(TARGET ${_target}_optimized APPEND PROPERTY COMPILE_DEFINITIONS "USE_BASEFUNCTIONSET_CODEGEN;${compiledefs}")
      dune_target_enable_all_packages( ${_target}_optimized )
      # include current dir because autogenerated code will be placed there
      target_include_directories( ${_target}_optimized PUBLIC "${CMAKE_CURRENT_SOURCE_DIR}" )

      add_custom_target( ${_target}_generate
        ${CMAKE_COMMAND} -D RUN_CODEGEN_PROGRAM=${CMAKE_CURRENT_BINARY_DIR}/${_target}_codegenerator -D RUN_CODEGEN_PARAMFILE="" -P ${CMAKE_SOURCE_DIR}/cmake/scripts/RunGenerate.cmake )

      #Add depenencies
      add_dependencies( ${_target}_generate ${_target}_codegenerator )
    endif()
  endforeach()

endfunction(add_code_generate_targets _target)
