/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.python.utils;

import com.alibaba.alink.common.MTable;
import com.alibaba.alink.common.utils.TableUtil;
import com.alibaba.alink.operator.batch.source.MemSourceBatchOp;
import com.alibaba.alink.operator.common.io.csv.CsvParser;
import com.alibaba.alink.operator.stream.source.MemSourceStreamOp;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.types.Row;

public class MultiLineCsvParser {
    public static List<Row> csvToRows(String content, String schemaStr, String lineTerminator, String fieldDelimiter, Character quoteChar) {
        TypeInformation[] colTypes = TableUtil.getColTypes((String)schemaStr);
        CsvParser csvParser = new CsvParser(colTypes, fieldDelimiter, quoteChar);
        return Arrays.stream(content.split(lineTerminator)).map(arg_0 -> ((CsvParser)csvParser).parse(arg_0)).map(d -> (Row)d.f1).map(Row::copy).collect(Collectors.toList());
    }

    public static MemSourceBatchOp csvToBatchOperator(String content, String schemaStr, String lineTerminator, String fieldDelimiter, Character quoteChar) {
        TableSchema tableSchema = TableUtil.schemaStr2Schema((String)schemaStr);
        List<Row> rows = MultiLineCsvParser.csvToRows(content, schemaStr, lineTerminator, fieldDelimiter, quoteChar);
        return new MemSourceBatchOp(rows, tableSchema);
    }

    public static MemSourceStreamOp csvToStreamOperator(String content, String schemaStr, String lineTerminator, String fieldDelimiter, Character quoteChar) {
        TableSchema tableSchema = TableUtil.schemaStr2Schema((String)schemaStr);
        List<Row> rows = MultiLineCsvParser.csvToRows(content, schemaStr, lineTerminator, fieldDelimiter, quoteChar);
        return new MemSourceStreamOp(rows, tableSchema);
    }

    public static MTable csvToMTable(String content, String schemaStr, String lineTerminator, String fieldDelimiter, Character quoteChar) {
        TableSchema tableSchema = TableUtil.schemaStr2Schema((String)schemaStr);
        List<Row> rows = MultiLineCsvParser.csvToRows(content, schemaStr, lineTerminator, fieldDelimiter, quoteChar);
        return new MTable(rows, tableSchema);
    }
}

