/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalytic;
import org.apache.flink.util.Preconditions;

public abstract class GraphAnalyticBase<K, VV, EV, T>
implements GraphAnalytic<K, VV, EV, T> {
    protected ExecutionEnvironment env;
    protected int parallelism = -1;

    @Override
    public GraphAnalytic<K, VV, EV, T> run(Graph<K, VV, EV> input) throws Exception {
        this.env = input.getContext();
        return this;
    }

    public GraphAnalyticBase<K, VV, EV, T> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
        this.parallelism = parallelism;
        return this;
    }

    @Override
    public T execute() throws Exception {
        this.env.execute();
        return this.getResult();
    }

    @Override
    public T execute(String jobName) throws Exception {
        Preconditions.checkNotNull((Object)jobName);
        this.env.execute(jobName);
        return this.getResult();
    }
}

