/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.util.Preconditions;

public abstract class IterationConfiguration {
    private String name;
    private int parallelism = -1;
    private Map<String, Aggregator<?>> aggregators = new HashMap();
    private boolean unmanagedSolutionSet = false;
    private boolean optNumVertices = false;

    public void setName(String name) {
        this.name = name;
    }

    public String getName(String defaultName) {
        if (this.name != null) {
            return this.name;
        }
        return defaultName;
    }

    public void setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
        this.parallelism = parallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setSolutionSetUnmanagedMemory(boolean unmanaged) {
        this.unmanagedSolutionSet = unmanaged;
    }

    public boolean isSolutionSetUnmanagedMemory() {
        return this.unmanagedSolutionSet;
    }

    public boolean isOptNumVertices() {
        return this.optNumVertices;
    }

    public void setOptNumVertices(boolean optNumVertices) {
        this.optNumVertices = optNumVertices;
    }

    public void registerAggregator(String name, Aggregator<?> aggregator) {
        this.aggregators.put(name, aggregator);
    }

    public Map<String, Aggregator<?>> getAggregators() {
        return this.aggregators;
    }
}

