/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.util.Preconditions;

public class Translate {
    public static <OLD, NEW, VV> DataSet<Vertex<NEW, VV>> translateVertexIds(DataSet<Vertex<OLD, VV>> vertices, TranslateFunction<OLD, NEW> translator) {
        return Translate.translateVertexIds(vertices, translator, -1);
    }

    public static <OLD, NEW, VV> DataSet<Vertex<NEW, VV>> translateVertexIds(DataSet<Vertex<OLD, VV>> vertices, TranslateFunction<OLD, NEW> translator, int parallelism) {
        Preconditions.checkNotNull(vertices);
        Preconditions.checkNotNull(translator);
        Class<Vertex> vertexClass = Vertex.class;
        TypeInformation oldType = ((TupleTypeInfo)vertices.getType()).getTypeAt(0);
        TypeInformation newType = TypeExtractor.getUnaryOperatorReturnType(translator, TranslateFunction.class, (int)0, (int)1, (int[])new int[]{1}, (TypeInformation)oldType, null, (boolean)false);
        TypeInformation vertexValueType = ((TupleTypeInfo)vertices.getType()).getTypeAt(1);
        TupleTypeInfo returnType = new TupleTypeInfo(vertexClass, new TypeInformation[]{newType, vertexValueType});
        return ((MapOperator)((MapOperator)vertices.map(new TranslateVertexId(translator)).returns((TypeInformation)returnType)).setParallelism(parallelism)).name("Translate vertex IDs");
    }

    public static <OLD, NEW, EV> DataSet<Edge<NEW, EV>> translateEdgeIds(DataSet<Edge<OLD, EV>> edges, TranslateFunction<OLD, NEW> translator) {
        return Translate.translateEdgeIds(edges, translator, -1);
    }

    public static <OLD, NEW, EV> DataSet<Edge<NEW, EV>> translateEdgeIds(DataSet<Edge<OLD, EV>> edges, TranslateFunction<OLD, NEW> translator, int parallelism) {
        Preconditions.checkNotNull(edges);
        Preconditions.checkNotNull(translator);
        Class<Edge> edgeClass = Edge.class;
        TypeInformation oldType = ((TupleTypeInfo)edges.getType()).getTypeAt(0);
        TypeInformation newType = TypeExtractor.getUnaryOperatorReturnType(translator, TranslateFunction.class, (int)0, (int)1, (int[])new int[]{1}, (TypeInformation)oldType, null, (boolean)false);
        TypeInformation edgeValueType = ((TupleTypeInfo)edges.getType()).getTypeAt(2);
        TupleTypeInfo returnType = new TupleTypeInfo(edgeClass, new TypeInformation[]{newType, newType, edgeValueType});
        return ((MapOperator)((MapOperator)edges.map(new TranslateEdgeId(translator)).returns((TypeInformation)returnType)).setParallelism(parallelism)).name("Translate edge IDs");
    }

    public static <K, OLD, NEW> DataSet<Vertex<K, NEW>> translateVertexValues(DataSet<Vertex<K, OLD>> vertices, TranslateFunction<OLD, NEW> translator) {
        return Translate.translateVertexValues(vertices, translator, -1);
    }

    public static <K, OLD, NEW> DataSet<Vertex<K, NEW>> translateVertexValues(DataSet<Vertex<K, OLD>> vertices, TranslateFunction<OLD, NEW> translator, int parallelism) {
        Preconditions.checkNotNull(vertices);
        Preconditions.checkNotNull(translator);
        Class<Vertex> vertexClass = Vertex.class;
        TypeInformation idType = ((TupleTypeInfo)vertices.getType()).getTypeAt(0);
        TypeInformation oldType = ((TupleTypeInfo)vertices.getType()).getTypeAt(1);
        TypeInformation newType = TypeExtractor.getUnaryOperatorReturnType(translator, TranslateFunction.class, (int)0, (int)1, (int[])new int[]{1}, (TypeInformation)oldType, null, (boolean)false);
        TupleTypeInfo returnType = new TupleTypeInfo(vertexClass, new TypeInformation[]{idType, newType});
        return ((MapOperator)((MapOperator)vertices.map(new TranslateVertexValue(translator)).returns((TypeInformation)returnType)).setParallelism(parallelism)).name("Translate vertex values");
    }

    public static <K, OLD, NEW> DataSet<Edge<K, NEW>> translateEdgeValues(DataSet<Edge<K, OLD>> edges, TranslateFunction<OLD, NEW> translator) {
        return Translate.translateEdgeValues(edges, translator, -1);
    }

    public static <K, OLD, NEW> DataSet<Edge<K, NEW>> translateEdgeValues(DataSet<Edge<K, OLD>> edges, TranslateFunction<OLD, NEW> translator, int parallelism) {
        Preconditions.checkNotNull(edges);
        Preconditions.checkNotNull(translator);
        Class<Edge> edgeClass = Edge.class;
        TypeInformation idType = ((TupleTypeInfo)edges.getType()).getTypeAt(0);
        TypeInformation oldType = ((TupleTypeInfo)edges.getType()).getTypeAt(2);
        TypeInformation newType = TypeExtractor.getUnaryOperatorReturnType(translator, TranslateFunction.class, (int)0, (int)1, (int[])new int[]{1}, (TypeInformation)oldType, null, (boolean)false);
        TupleTypeInfo returnType = new TupleTypeInfo(edgeClass, new TypeInformation[]{idType, idType, newType});
        return ((MapOperator)((MapOperator)edges.map(new TranslateEdgeValue(translator)).returns((TypeInformation)returnType)).setParallelism(parallelism)).name("Translate edge values");
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static class TranslateEdgeValue<K, OLD, NEW>
    extends WrappingFunction<TranslateFunction<OLD, NEW>>
    implements MapFunction<Edge<K, OLD>, Edge<K, NEW>> {
        private Edge<K, NEW> edge = new Edge();

        public TranslateEdgeValue(TranslateFunction<OLD, NEW> translator) {
            super(translator);
        }

        public Edge<K, NEW> map(Edge<K, OLD> value) throws Exception {
            this.edge.f0 = value.f0;
            this.edge.f1 = value.f1;
            this.edge.f2 = ((TranslateFunction)this.wrappedFunction).translate(value.f2, this.edge.f2);
            return this.edge;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class TranslateVertexValue<K, OLD, NEW>
    extends WrappingFunction<TranslateFunction<OLD, NEW>>
    implements MapFunction<Vertex<K, OLD>, Vertex<K, NEW>> {
        private Vertex<K, NEW> vertex = new Vertex();

        public TranslateVertexValue(TranslateFunction<OLD, NEW> translator) {
            super(translator);
        }

        public Vertex<K, NEW> map(Vertex<K, OLD> value) throws Exception {
            this.vertex.f0 = value.f0;
            this.vertex.f1 = ((TranslateFunction)this.wrappedFunction).translate(value.f1, this.vertex.f1);
            return this.vertex;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"2"})
    private static class TranslateEdgeId<OLD, NEW, EV>
    extends WrappingFunction<TranslateFunction<OLD, NEW>>
    implements MapFunction<Edge<OLD, EV>, Edge<NEW, EV>> {
        private Edge<NEW, EV> edge = new Edge();

        public TranslateEdgeId(TranslateFunction<OLD, NEW> translator) {
            super(translator);
        }

        public Edge<NEW, EV> map(Edge<OLD, EV> value) throws Exception {
            this.edge.f0 = ((TranslateFunction)this.wrappedFunction).translate(value.f0, this.edge.f0);
            this.edge.f1 = ((TranslateFunction)this.wrappedFunction).translate(value.f1, this.edge.f1);
            this.edge.f2 = value.f2;
            return this.edge;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"1"})
    private static class TranslateVertexId<OLD, NEW, VV>
    extends WrappingFunction<TranslateFunction<OLD, NEW>>
    implements MapFunction<Vertex<OLD, VV>, Vertex<NEW, VV>> {
        private Vertex<NEW, VV> vertex = new Vertex();

        public TranslateVertexId(TranslateFunction<OLD, NEW> translator) {
            super(translator);
        }

        public Vertex<NEW, VV> map(Vertex<OLD, VV> value) throws Exception {
            this.vertex.f0 = ((TranslateFunction)this.wrappedFunction).translate(value.f0, this.vertex.f0);
            this.vertex.f1 = value.f1;
            return this.vertex;
        }
    }
}

