/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.translate.Translate;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Preconditions;

public class TranslateGraphIds<OLD, NEW, VV, EV>
extends GraphAlgorithmWrappingGraph<OLD, VV, EV, NEW, VV, EV> {
    private TranslateFunction<OLD, NEW> translator;

    public TranslateGraphIds(TranslateFunction<OLD, NEW> translator) {
        Preconditions.checkNotNull(translator);
        this.translator = translator;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        TranslateGraphIds rhs = (TranslateGraphIds)other;
        return this.translator == rhs.translator;
    }

    @Override
    public Graph<NEW, VV, EV> runInternal(Graph<OLD, VV, EV> input) throws Exception {
        DataSet<Vertex<NEW, VV>> translatedVertices = Translate.translateVertexIds(input.getVertices(), this.translator, this.parallelism);
        DataSet<Edge<NEW, EV>> translatedEdges = Translate.translateEdgeIds(input.getEdges(), this.translator, this.parallelism);
        return Graph.fromDataSet(translatedVertices, translatedEdges, input.getContext());
    }
}

