/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.bipartite;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.bipartite.BipartiteEdge;
import org.apache.flink.graph.bipartite.Projection;
import org.apache.flink.util.Collector;

public class BipartiteGraph<KT, KB, VVT, VVB, EV> {
    private final ExecutionEnvironment context;
    private final DataSet<Vertex<KT, VVT>> topVertices;
    private final DataSet<Vertex<KB, VVB>> bottomVertices;
    private final DataSet<BipartiteEdge<KT, KB, EV>> edges;

    private BipartiteGraph(DataSet<Vertex<KT, VVT>> topVertices, DataSet<Vertex<KB, VVB>> bottomVertices, DataSet<BipartiteEdge<KT, KB, EV>> edges, ExecutionEnvironment context) {
        this.topVertices = topVertices;
        this.bottomVertices = bottomVertices;
        this.edges = edges;
        this.context = context;
    }

    public static <KT, KB, VVT, VVB, EV> BipartiteGraph<KT, KB, VVT, VVB, EV> fromDataSet(DataSet<Vertex<KT, VVT>> topVertices, DataSet<Vertex<KB, VVB>> bottomVertices, DataSet<BipartiteEdge<KT, KB, EV>> edges, ExecutionEnvironment context) {
        return new BipartiteGraph<KT, KB, VVT, VVB, EV>(topVertices, bottomVertices, edges, context);
    }

    public DataSet<Vertex<KT, VVT>> getTopVertices() {
        return this.topVertices;
    }

    public DataSet<Vertex<KB, VVB>> getBottomVertices() {
        return this.bottomVertices;
    }

    public DataSet<BipartiteEdge<KT, KB, EV>> getEdges() {
        return this.edges;
    }

    public Graph<KT, VVT, Tuple2<EV, EV>> projectionTopSimple() {
        Operator newEdges = this.edges.join(this.edges).where(new int[]{1}).equalTo(new int[]{1}).with(new ProjectionTopSimple()).name("Simple top projection");
        return Graph.fromDataSet(this.topVertices, newEdges, this.context);
    }

    public Graph<KB, VVB, Tuple2<EV, EV>> projectionBottomSimple() {
        Operator newEdges = this.edges.join(this.edges).where(new int[]{0}).equalTo(new int[]{0}).with(new ProjectionBottomSimple()).name("Simple bottom projection");
        return Graph.fromDataSet(this.bottomVertices, newEdges, this.context);
    }

    public Graph<KT, VVT, Projection<KB, VVB, VVT, EV>> projectionTopFull() {
        DataSet<Tuple5<KT, KB, EV, VVT, VVB>> edgesWithVertices = this.joinEdgeWithVertices();
        Operator newEdges = edgesWithVertices.join(edgesWithVertices).where(new int[]{1}).equalTo(new int[]{1}).with(new ProjectionTopFull()).name("Full top projection");
        return Graph.fromDataSet(this.topVertices, newEdges, this.context);
    }

    private DataSet<Tuple5<KT, KB, EV, VVT, VVB>> joinEdgeWithVertices() {
        return ((JoinOperator)this.edges.join(this.topVertices, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1, 2}).projectSecond(new int[]{1}).name("Edge with vertex")).join(this.bottomVertices, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1, 2, 3}).projectSecond(new int[]{1}).name("Edge with vertices");
    }

    public Graph<KB, VVB, Projection<KT, VVT, VVB, EV>> projectionBottomFull() {
        DataSet<Tuple5<KT, KB, EV, VVT, VVB>> edgesWithVertices = this.joinEdgeWithVertices();
        Operator newEdges = edgesWithVertices.join(edgesWithVertices).where(new int[]{0}).equalTo(new int[]{0}).with(new ProjectionBottomFull()).name("Full bottom projection");
        return Graph.fromDataSet(this.bottomVertices, newEdges, this.context);
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"1->0; 2->2.4; 3->2.1; 4->2.2"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"1; 2->2.5; 4->2.3"})
    private static class ProjectionBottomFull<KT, KB, EV, VVT, VVB>
    implements FlatJoinFunction<Tuple5<KT, KB, EV, VVT, VVB>, Tuple5<KT, KB, EV, VVT, VVB>, Edge<KB, Projection<KT, VVT, VVB, EV>>> {
        private Projection<KT, VVT, VVB, EV> projection = new Projection();
        private Edge<KB, Projection<KT, VVT, VVB, EV>> edge = new Edge<Object, Projection<KT, VVT, VVB, EV>>(null, null, this.projection);

        private ProjectionBottomFull() {
        }

        public void join(Tuple5<KT, KB, EV, VVT, VVB> first, Tuple5<KT, KB, EV, VVT, VVB> second, Collector<Edge<KB, Projection<KT, VVT, VVB, EV>>> out) throws Exception {
            if (!first.f1.equals(second.f1)) {
                this.edge.f0 = first.f1;
                this.edge.f1 = second.f1;
                this.projection.f0 = first.f0;
                this.projection.f1 = first.f3;
                this.projection.f2 = first.f4;
                this.projection.f3 = second.f4;
                this.projection.f4 = first.f2;
                this.projection.f5 = second.f2;
                out.collect(this.edge);
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 1->2.0; 2->2.4; 3->2.2; 4->2.1"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0->1; 2->2.5; 3->2.3"})
    private static class ProjectionTopFull<KT, KB, EV, VVT, VVB>
    implements FlatJoinFunction<Tuple5<KT, KB, EV, VVT, VVB>, Tuple5<KT, KB, EV, VVT, VVB>, Edge<KT, Projection<KB, VVB, VVT, EV>>> {
        private Projection<KB, VVB, VVT, EV> projection = new Projection();
        private Edge<KT, Projection<KB, VVB, VVT, EV>> edge = new Edge<Object, Projection<KB, VVB, VVT, EV>>(null, null, this.projection);

        private ProjectionTopFull() {
        }

        public void join(Tuple5<KT, KB, EV, VVT, VVB> first, Tuple5<KT, KB, EV, VVT, VVB> second, Collector<Edge<KT, Projection<KB, VVB, VVT, EV>>> out) throws Exception {
            if (!first.f0.equals(second.f0)) {
                this.edge.f0 = first.f0;
                this.edge.f1 = second.f0;
                this.projection.f0 = first.f1;
                this.projection.f1 = first.f4;
                this.projection.f2 = first.f3;
                this.projection.f3 = second.f3;
                this.projection.f4 = first.f2;
                this.projection.f5 = second.f2;
                out.collect(this.edge);
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"1->0; 2->2.0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"1; 2->2.1"})
    private static class ProjectionBottomSimple<KT, KB, EV>
    implements FlatJoinFunction<BipartiteEdge<KT, KB, EV>, BipartiteEdge<KT, KB, EV>, Edge<KB, Tuple2<EV, EV>>> {
        private Tuple2<EV, EV> edgeValues = new Tuple2();
        private Edge<KB, Tuple2<EV, EV>> edge = new Edge<Object, Tuple2<EV, EV>>(null, null, this.edgeValues);

        private ProjectionBottomSimple() {
        }

        public void join(BipartiteEdge<KT, KB, EV> first, BipartiteEdge<KT, KB, EV> second, Collector<Edge<KB, Tuple2<EV, EV>>> out) throws Exception {
            if (!first.f1.equals(second.f1)) {
                this.edge.f0 = first.f1;
                this.edge.f1 = second.f1;
                this.edgeValues.f0 = first.f2;
                this.edgeValues.f1 = second.f2;
                out.collect(this.edge);
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0; 2->2.0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0->1; 2->2.1"})
    private static class ProjectionTopSimple<KT, KB, EV>
    implements FlatJoinFunction<BipartiteEdge<KT, KB, EV>, BipartiteEdge<KT, KB, EV>, Edge<KT, Tuple2<EV, EV>>> {
        private Tuple2<EV, EV> edgeValues = new Tuple2();
        private Edge<KT, Tuple2<EV, EV>> edge = new Edge<Object, Tuple2<EV, EV>>(null, null, this.edgeValues);

        private ProjectionTopSimple() {
        }

        public void join(BipartiteEdge<KT, KB, EV> first, BipartiteEdge<KT, KB, EV> second, Collector<Edge<KT, Tuple2<EV, EV>>> out) throws Exception {
            if (!first.f0.equals(second.f0)) {
                this.edge.f0 = first.f0;
                this.edge.f1 = second.f0;
                this.edgeValues.f0 = first.f2;
                this.edgeValues.f1 = second.f2;
                out.collect(this.edge);
            }
        }
    }
}

